package comon;

import java.io.IOException;
import java.util.ArrayList;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import structure.Struct_Community;
import structure.Struct_Community_Menber;
import structure.Struct_Menber;
import structure.Struct_Session;
import beansApp.AdminCommunityMenber_IO;
import beansApp.AdminCommunity_IO;
import beansApp.AdminMenber_IO;

public class ComonMenberCommunityView extends HttpServlet{
	private String urlbackward 	= new String("/servlet/framecomonmenbercommunitymenu");
	private String urlfoward 		= new String("/servlet/framecomonmenbercommunity");
	private String urlsessionout 	= new String("/servlet/sessionout");
	private String urlMSG 			= new String("/servlet/framecommonmessage");
	
	private String title = "メンバーコミュニティの参照";
	

	public void doPost(HttpServletRequest request, HttpServletResponse response)
	throws IOException, ServletException{

		//***************************************
		//* 初期設定
		//***************************************
		ServletContext scon = getServletConfig().getServletContext();
		HttpSession session = request.getSession(false);
		//* リクエストオブジェクトの文字コード設定
		request.setCharacterEncoding("UTF-8");
		
		//***************************************
		//* セッションチェック
		//***************************************
		Struct_Session ss = session_Check(scon,session);
		if(ss == null){
			HttpSession newsession = request.getSession(true);
			getServletContext().getRequestDispatcher(urlsessionout).forward(request, response);			
			return;
		}

		
		String select 	=  request.getParameter("select");
		if(select == null){
			dataSet(request);
			request.setAttribute("MSG", "選択がありません");
			getServletContext().getRequestDispatcher(urlbackward).forward(request, response);			
			return;				
		}

		
		//***************************************
		//* コミュニティファイルのアクセス準備
		//***************************************
		String[] community;
		
		String filePath = scon.getInitParameter("masterDir") +
							scon.getInitParameter("communityFile");
		AdminCommunity_IO ac = new AdminCommunity_IO();
		ac.setFilePath(filePath);
		byte loadrtn = ac.load();
		
		if(loadrtn == (byte)1){
			//* ロード成功
			ArrayList<Struct_Community> alm	= ac.getdata();
			community  		= new String[alm.size()];
			for(int i=0;i<alm.size() ; i++){
				community[i]			= alm.get(i).getCommunity();
			}	
			
		}else if(loadrtn == (byte)2){
			//* ファイルなし
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "コミュニティファイルは未作成です");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
		
		}else{
			//* ロード失敗
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "コミュニティファイルのロードに失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
		}	
		
		
		//***********************************************
		//* コミュニティメンバーファイルのアクセス準備
		//***********************************************
		ArrayList<Struct_Community_Menber> commenData;
		filePath = scon.getInitParameter("masterDir") +
					scon.getInitParameter("communityMenberFile");
		AdminCommunityMenber_IO acm = new AdminCommunityMenber_IO();
		acm.setFilePath(filePath);
		loadrtn = acm.load();

		if(loadrtn == (byte)1){
			//* ロード成功
			commenData	= acm.getCommunity(select);
			
		}else if(loadrtn == (byte)2){		
			//* ファイルなし
			dataSet(request);
			request.setAttribute("MSG", "参加コミュニティは存在しません");
			getServletContext().getRequestDispatcher(urlbackward).forward(request, response);			
			return;				
			
		}else{
			//* ロード失敗
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "コミュニティメンバーファイルのロードに失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
		}				

	
		if(commenData == null || commenData.size() == 0){
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "参加コミュニティはありません");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
			
		}
		
		boolean[] chkrows = new boolean[community.length];
		if(commenData != null && commenData.size() > 0){
			//既存メンバーの復元
			for(int i=0 ; i<community.length ;i++){
				for(int j=0 ; j<commenData.size() ;j++){
					if(community[i].equals(commenData.get(j).getCommunity())){
						chkrows[i] = true;
						break;
					}
				}
			}
		}
		

		//***********************************************
		//* 一般ユーザーの制限
		//***********************************************
		String editrows = null;
		if(ss.isAdmin() == true || 
			ss.getUserid().equals(select) ||	
				session.getAttribute("ADMINOPTION") != null ){
			editrows = "yes";
		}
		
		
		
		String userid[] 		=  request.getParameterValues("userid");
		String user_fullname[] 	=  request.getParameterValues("user_fullname");

		for(int i=0;i<userid.length;i++){
			if(select.equals(userid[i])){
				request.setAttribute("USER_FULLNAME"	,	user_fullname[i]);
			}
		}
		
		request.setAttribute("USERID"		,	select);
		request.setAttribute("COMMUNITY"		,	community);
		request.setAttribute("CHKROWS"		,	chkrows);
		request.setAttribute("EDITROWS"	,	editrows);
		updatemode(request,scon,session);
		request.setAttribute("MSG", "コミュニティメンバーファイルを表示しました");
		getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
	
	
	}
	

	//セッションチェック
	private Struct_Session session_Check(ServletContext scon,HttpSession session){
		//セッションが切れた場合、は処理続行不可
		if(session == null){
			return null;
		 }
		//ログオンを通過していない場合は処理続行不可
		if(	session.getAttribute("USER") == null){
			return null;
		 }

		//セッションオブジェクトのセッション情報を紛失したは処理続行不可
		Struct_Session ss = (Struct_Session) session.getAttribute("SESSION");
		if(ss == null){
			return null;
		}		
		//サーブレットコンテキストのセッションナンバーを紛失した場合は処理続行不可
		if(scon.getAttribute(ss.getSessionnumber())	== null){
			return null;
		}		
		return ss;
	}
	
	
	private void dataSet(HttpServletRequest request){
		request.setAttribute("USERID"		,	request.getParameterValues("userid"));
		request.setAttribute("USER_FULLNAME",	request.getParameterValues("user_fullname"));
		String select[] 	=  request.getParameterValues("select");

		//選択チェックボックスに入力がある場合
		if(select != null){
			boolean temp_select[]	= new boolean[request.getParameterValues("userid").length];

			//選択チェックボックスの復元
			for(int i=0;i<select.length;i++){
				int line = Integer.valueOf(select[i]).intValue();
				temp_select[line]=true;
			}
			request.setAttribute("SELECT",	temp_select);			
		}
	}

	
	private void updatemode(HttpServletRequest request,ServletContext scon,HttpSession session){
		String updateprm = (String) scon.getAttribute("UPDATEMODE");
		if(updateprm == null || 
			updateprm.equals(session.getId()) == false){
			return;
		}
		request.setAttribute("UPDATEMODE","yes");
	}
	
}
