package comon;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import beansApp.AdminStatus_IO;

import structure.Struct_Session;

public class ComonOperation extends HttpServlet{
	private String urlfoward 		= new String("/servlet/framecomonoperation");
	private String urlsessionout 	= new String("/servlet/sessionout");
	private String urlMSG 			= new String("/servlet/framecommonmessage");
	
	private String title = "サーバー起動停止";
	
	public void doGet(HttpServletRequest request, HttpServletResponse response)
	throws IOException, ServletException{
		//***************************************
		//* 初期設定
		//***************************************
		ServletConfig config =getServletConfig();
		ServletContext scon = config.getServletContext();
		HttpSession session = request.getSession(false);
		//* リクエストオブジェクトの文字コード設定
		request.setCharacterEncoding("UTF-8");
		
		//***************************************
		//* セッションチェック
		//***************************************
		Struct_Session ss = session_Check(scon,session);
		if(ss == null){
			HttpSession newsession = request.getSession(true);
			getServletContext().getRequestDispatcher(urlsessionout).forward(request, response);			
			return;
		}


		if(ss.isAdmin() ==true){
			//アドミン権限のユーザーはスルー
		}else{
			//一般ユーザーはアドミンオプションが付与されていること
			if(session.getAttribute("ADMINOPTION") == null){
				request.setAttribute("TITLE",	title);
				request.setAttribute("MSG", "権限がありません");
				getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
				return;
			}
		}
		
		
		//***************************************
		//* パラメータ取得
		//***************************************
		//jpsコマンド
		String jpsCMD=scon.getInitParameter("jpsCMD");
		//サーバープログラム
		String serverPGM=scon.getInitParameter("serverPGM");
		
		
		//***************************************
		//* サーバ起動チェック
		//***************************************
		if(server_Watch(jpsCMD,serverPGM) == true){
			request.setAttribute("SERVER",	"yes");
		}
		
		updatemode(request,scon,session);
		getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
		return;
		
	}

	public void doPost(HttpServletRequest request, HttpServletResponse response)
	throws IOException, ServletException{
		
		//***************************************
		//* 初期設定
		//***************************************
		ServletConfig config =getServletConfig();
		ServletContext scon = config.getServletContext();
		HttpSession session = request.getSession(false);
		//* リクエストオブジェクトの文字コード設定
		request.setCharacterEncoding("UTF-8");
		
		//***************************************
		//* セッションチェック
		//***************************************
		if(session_Check(scon,session) == null){
			HttpSession newsession = request.getSession(true);
			getServletContext().getRequestDispatcher(urlsessionout).forward(request, response);			
			return;
		}

		//***************************************
		//* パラメータ取得
		//***************************************
		//サーバーディレクトリ
		String serverDir = scon.getInitParameter("serverDir") ;
		//jpsコマンド
		String jpsCMD=scon.getInitParameter("jpsCMD");
		//サーバープログラム
		String serverPGM=scon.getInitParameter("serverPGM");
		//プログラムディレクトリ
		String pgmDir =scon.getInitParameter("pgmDir");
		//ステータスファイル
		String statusFile=config.getInitParameter("statusFile");

		
		//リフレッシュを選択した場合
		if(request.getParameter("refresh") != null){
			//***************************************
			//* サーバ起動チェック
			//***************************************
			if(server_Watch(jpsCMD,serverPGM) == true){
				request.setAttribute("SERVER",	"yes");
			}
			request.setAttribute("MSG", "リフレッシュしました");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
			
		}
		//起動を選択した場合
		else if(request.getParameter("start") != null){
			//***************************************
			//* サーバ起動チェック
			//***************************************
			if(server_Watch(jpsCMD,serverPGM) == true){
				request.setAttribute("MSG", "既に起動中です");
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;
			}

			//***************************************
			//* パラメータ取得
			//***************************************
			
			//ステータスを稼働中にする
			AdminStatus_IO st = new AdminStatus_IO(serverDir + statusFile);
			st.setExecute();
			//受信サーバを起動
			ProcessBuilder builder = new ProcessBuilder("java", "-jar", 
											serverDir + pgmDir +serverPGM);
			Process process = builder.start();
			request.setAttribute("MSG", "サーバーを起動しました");
			//***************************************
			//* サーバ起動チェック
			//***************************************
			if(server_Watch(jpsCMD,serverPGM) == false){
				request.setAttribute("SERVER",	"yes");
			}
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);	
			return;
		}
		//停止を選択した場合
		else if(request.getParameter("stop") != null){
			//***************************************
			//* サーバ起動チェック
			//***************************************
			if(server_Watch(jpsCMD,serverPGM) == false){
				request.setAttribute("MSG", "既に停止中です");
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;
			}
			//ステータスを終了待ちにする
			AdminStatus_IO st = new AdminStatus_IO(serverDir + statusFile);
			st.setEndWait();
			updatemode(request,scon,session);
			request.setAttribute("MSG", "サーバーに停止命令を発信しました<br>"+
											"終了するまで時間が必要な場合があります。");
			//***************************************
			//* サーバ起動チェック
			//***************************************
			if(server_Watch(jpsCMD,serverPGM) == false){
				request.setAttribute("SERVER",	"yes");
			}
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		}
		else if(request.getParameter("force") != null){
			//***************************************
			//* サーバ起動チェック
			//***************************************
			if(server_Watch(jpsCMD,serverPGM) == false){
				request.setAttribute("SERVER",	"yes");
				request.setAttribute("MSG", "既に停止中です");
				updatemode(request,scon,session);
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;
			}
			
		}
		
		
	}
	
	
	//セッションチェック
	private Struct_Session session_Check(ServletContext scon,HttpSession session){
		//セッションが切れた場合、は処理続行不可
		if(session == null){
			return null;
		 }
		//ログオンを通過していない場合は処理続行不可
		if(	session.getAttribute("USER") == null){
			return null;
		 }

		//セッションオブジェクトのセッション情報を紛失したは処理続行不可
		Struct_Session ss = (Struct_Session) session.getAttribute("SESSION");
		if(ss == null){
			return null;
		}		
		//サーブレットコンテキストのセッションナンバーを紛失した場合は処理続行不可
		if(scon.getAttribute(ss.getSessionnumber())	== null){
			return null;
		}		
		return ss;
	}

	//サーバ監視
	private boolean server_Watch(	String jpsCMD,
									String serverPGM) throws IOException{
		//***************************************
		//* サーバー監視
		//***************************************
		String stdout = new String();
		//jpsコマンド発行
		ProcessBuilder builder = new ProcessBuilder(jpsCMD);
   		Process process = builder.start();

		//標準出力を取得
   		InputStream stream = process.getInputStream();
   		BufferedReader br = new BufferedReader(new InputStreamReader(stream)); 
   		String line;
		while ((line = br.readLine()) != null) {
   			stdout += line;
   		}
   		
		//サーバ起動チェック
		if(stdout.indexOf(serverPGM) == -1){
			return false;
		}
		return true;
		
	}
	private void updatemode(HttpServletRequest request,ServletContext scon,HttpSession session){
		String updateprm = (String) scon.getAttribute("UPDATEMODE");
		if(updateprm == null || 
			updateprm.equals(session.getId()) == false){
			return;
		}
		request.setAttribute("UPDATEMODE","yes");
	}

	
	
	
}
