package comon;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import structure.File_Separator;
import structure.Struct_MasterFile;
import structure.Struct_Session;
import tool.Tool_DirDel;
import tool.Tool_FileCopy;
import beansApp.AdminConfig_IO;
import beansApp.AdminMasterFile_IO;
import beansApp.AdminProject_IO;

public class ComonServerBuild extends HttpServlet{
	private String urlfoward 		= new String("/servlet/framecomonserverbuild");
	private String urlsessionout 	= new String("/servlet/sessionout");
	private String urlMSG 			= new String("/servlet/framecommonmessage");
	
	private String title = "サーバー環境構築";

	//***********************************************
	//* リンク呼び出しのため、doGet
	//***********************************************
	public void doGet(HttpServletRequest request, HttpServletResponse response)
	throws IOException, ServletException{
		//***************************************
		//* 初期設定
		//***************************************
		ServletConfig config =getServletConfig();
		ServletContext scon = config.getServletContext();
		HttpSession session = request.getSession(false);
		//* リクエストオブジェクトの文字コード設定
		request.setCharacterEncoding("UTF-8");
		
		//***************************************
		//* セッションチェック
		//***************************************
		Struct_Session ss = session_Check(scon,session);
		if(ss == null){
			HttpSession newsession = request.getSession(true);
			getServletContext().getRequestDispatcher(urlsessionout).forward(request, response);			
			return;
		}
		
		if(ss.isAdmin() ==true){
			//アドミン権限のユーザーはスルー
		}else{
			//一般ユーザーはアドミンオプションが付与されていること
			if(session.getAttribute("ADMINOPTION") == null){
				request.setAttribute("TITLE",	title);
				request.setAttribute("MSG", "権限がありません");
				getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
				return;
			}
		}
		
		
		//***************************************
		//* パラメータ取得
		//***************************************
		//jpsコマンド
		String jpsCMD=scon.getInitParameter("jpsCMD");
		//サーバープログラム
		String serverPGM=scon.getInitParameter("serverPGM");
		
		//***************************************
		//* サーバ起動チェック
		//***************************************
		if(server_Watch(jpsCMD,serverPGM) == true){
			request.setAttribute("MSG", "サーバー起動中のため構築はできません");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
		}

		updatemode(request,scon,session);
		getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
		return;
		
	}
	
	
	public void doPost(HttpServletRequest request, HttpServletResponse response)
	throws IOException, ServletException{

		//***************************************
		//* 初期設定
		//***************************************
		ServletConfig config =getServletConfig();
		ServletContext scon = config.getServletContext();
		HttpSession session = request.getSession(false);
		//* リクエストオブジェクトの文字コード設定
		request.setCharacterEncoding("UTF-8");
		
		//***************************************
		//* セッションチェック
		//***************************************
		if(session_Check(scon,session) == null){
			HttpSession newsession = request.getSession(true);
			getServletContext().getRequestDispatcher(urlsessionout).forward(request, response);			
			return;
		}

		//***************************************
		//* パラメータ取得
		//***************************************
		//jpsコマンド
		String jpsCMD=scon.getInitParameter("jpsCMD");
		//サーバープログラム
		String serverPGM=scon.getInitParameter("serverPGM");
		
		//***************************************
		//* サーバ起動チェック
		//***************************************
		if(server_Watch(jpsCMD,serverPGM) == true){
			request.setAttribute("MSG", "サーバー起動中のため構築はできません");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
		}
		
		
		//***************************************************************************
		//* 作成
		//***************************************************************************
		//***************************************
		//* 更新モードチェック
		//***************************************
		String updateprm = (String) scon.getAttribute("UPDATEMODE");
		if(updateprm == null || 
			updateprm.equals(session.getId()) == false){
			request.setAttribute("TITLE", title );
			request.setAttribute("MSG", "更新権限を剥奪されました<br>"+
										"更新モードの切り替えが必要です"	);
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
		}


		//ファイル有無チェック
		if(fileCheck(scon,session,request,response) == false){
			return;
		}

		
		//本体作成
		if(bodyMake(scon,session,request,response) == false){
			return;
		}
		
		

		request.setAttribute("MSG", "サーバ環境を更新しました");
		updatemode(request,scon,session);
		getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
		return;	
	
	
	}

	//セッションチェック
	private Struct_Session session_Check(ServletContext scon,HttpSession session){
		//セッションが切れた場合、は処理続行不可
		if(session == null){
			return null;
		 }
		//ログオンを通過していない場合は処理続行不可
		if(	session.getAttribute("USER") == null){
			return null;
		 }

		//セッションオブジェクトのセッション情報を紛失したは処理続行不可
		Struct_Session ss = (Struct_Session) session.getAttribute("SESSION");
		if(ss == null){
			return null;
		}		
		//サーブレットコンテキストのセッションナンバーを紛失した場合は処理続行不可
		if(scon.getAttribute(ss.getSessionnumber())	== null){
			return null;
		}		
		return ss;
	}

	

	
	private boolean fileCheck(ServletContext scon,
									HttpSession session,
									HttpServletRequest request,
									HttpServletResponse response)
	throws IOException, ServletException{
		//***************************************
		//* プロジェクトファイルの存在チェック
		//***************************************
		String filePath = scon.getInitParameter("masterDir") +
							scon.getInitParameter("projectFile");
		if(new File(filePath).exists() == false){
			request.setAttribute("MSG", "プロジェクトファイルは未作成です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return false;
		}
		//***************************************
		//* サーバーコンフィグファイルの存在チェック
		//***************************************
		filePath = scon.getInitParameter("masterDir") +
							scon.getInitParameter("serverconfigFile");
		if(new File(filePath).exists() == false){
			request.setAttribute("MSG", "サーバーコンフィグファイルは未作成です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return false;
		}
		//***************************************
		//* サーバーファイルの存在チェック
		//***************************************
		filePath = scon.getInitParameter("masterDir") +
							scon.getInitParameter("serverFile");
		if(new File(filePath).exists() == false){
			request.setAttribute("MSG", "サーバーファイルは未作成です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return false;
		}
		//***************************************
		//* メンバーファイルの存在チェック
		//***************************************
		filePath = scon.getInitParameter("masterDir") +
							scon.getInitParameter("menberFile");
		if(new File(filePath).exists() == false){
			request.setAttribute("MSG", "メンバーファイルは未作成です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return false;
		}
		//***************************************
		//* コミュニティファイルの存在チェック
		//***************************************
		filePath = scon.getInitParameter("masterDir") +
							scon.getInitParameter("communityFile");
		if(new File(filePath).exists() == false){
			request.setAttribute("MSG", "コミュニティファイルは未作成です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return false;
		}
		//***************************************
		//* コミュニティメンバーファイルの存在チェック
		//***************************************
		filePath = scon.getInitParameter("masterDir") +
							scon.getInitParameter("communityMenberFile");
		if(new File(filePath).exists() == false){
			request.setAttribute("MSG", "コミュニティメンバーファイルは未作成です");
			updatemode(request,scon,session);
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return false;
		}
		return true;
	}

	private boolean bodyMake(ServletContext scon,
								HttpSession session,
								HttpServletRequest request,
								HttpServletResponse response)
	throws IOException, ServletException{

		//ＯＳ依存のファイルセパレータ
		File_Separator fs = new File_Separator();

		//環境全削除
		
		
		//ディレクトリクリア
		String serverDir = scon.getInitParameter("serverDir");
		Tool_DirDel dirdel = new Tool_DirDel(serverDir);
		if(dirdel.delete() == false){
			request.setAttribute("TITLE", title );
			request.setAttribute("MSG", "ディレクトリのクリアに失敗しました<br>path="+serverDir);
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}
		
		if( new File(serverDir).mkdir() == false){
			request.setAttribute("TITLE", title );
			request.setAttribute("MSG", "ディレクトリの作成に失敗しました<br>path="+serverDir);
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}

		String filePath = serverDir+"buff_relay";
		if( new File(filePath).mkdir() == false){
			request.setAttribute("TITLE", title );
			request.setAttribute("MSG", "ディレクトリの作成に失敗しました<br>path="+filePath);
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}
		filePath = serverDir+"log";
		if( new File(filePath).mkdir() == false){
			request.setAttribute("TITLE", title );
			request.setAttribute("MSG", "ディレクトリの作成に失敗しました<br>path="+filePath);
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}
		filePath = serverDir+"pgm";
		if( new File(filePath).mkdir() == false){
			request.setAttribute("TITLE", title );
			request.setAttribute("MSG", "ディレクトリの作成に失敗しました<br>path="+filePath);
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}
		filePath = serverDir+"project";
		if( new File(filePath).mkdir() == false){
			request.setAttribute("TITLE", title );
			request.setAttribute("MSG", "ディレクトリの作成に失敗しました<br>path="+filePath);
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}
/*		
		filePath = serverDir+"task";
		if( new File(filePath).mkdir() == false){
			request.setAttribute("TITLE", title );
			request.setAttribute("MSG", "ディレクトリの作成に失敗しました<br>path="+filePath);
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}
		filePath = serverDir+"task_socket";
		if( new File(filePath).mkdir() == false){
			request.setAttribute("TITLE", title );
			request.setAttribute("MSG", "ディレクトリの作成に失敗しました<br>path="+filePath);
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}
*/		
		//***************************************
		//* プログラムコピー
		//***************************************
		//コピー元
		String infilepath =scon.getInitParameter("clientsourceDir")+ 
							scon.getInitParameter("serverPGM");
		//コピー先
		String outfilepath =serverDir+scon.getInitParameter("pgmDir")+ 
							scon.getInitParameter("serverPGM");
		File infile = new File(infilepath);
		File outfile = new File(outfilepath);
		//コピー実行
		if(new Tool_FileCopy().copyFile(infile, outfile) == false){
			request.setAttribute("TITLE", title );
			request.setAttribute("MSG", "ファイルコピーに失敗しました<br>infile="+infilepath+
									"<br>outfile="+outfilepath);
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}
		
		
		//***************************************
		//* サーバーコンフィグファイルコピー
		//***************************************
		//コピー元
		infilepath = scon.getInitParameter("masterDir")+ 
				scon.getInitParameter("serverconfigFile");
		outfilepath =serverDir+ scon.getInitParameter("configFile");
		infile = new File(infilepath);
		outfile = new File(outfilepath);
		//コピー実行
		if(new Tool_FileCopy().copyFile(infile, outfile) == false){
			request.setAttribute("TITLE", title );
			request.setAttribute("MSG", "ファイルコピーに失敗しました<br>infile="+infilepath+
									"<br>outfile="+outfilepath);
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}
    		
		//***************************************
		//* サーバーファイルコピー
		//***************************************
		//コピー元
		infilepath = scon.getInitParameter("masterDir")+ 
				scon.getInitParameter("serverFile");
		outfilepath =serverDir+ scon.getInitParameter("userinitFile");
		infile = new File(infilepath);
		outfile = new File(outfilepath);
		//コピー実行
		if(new Tool_FileCopy().copyFile(infile, outfile) == false){
			request.setAttribute("TITLE", title );
			request.setAttribute("MSG", "ファイルコピーに失敗しました<br>infile="+infilepath+
									"<br>outfile="+outfilepath);
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}

		
		//***************************************
		//*プロジェクトファイルコピー
		//***************************************
		//コピー元
		infilepath = scon.getInitParameter("masterDir")+ 
				scon.getInitParameter("projectFile");
		outfilepath =serverDir+ scon.getInitParameter("projectFile");
		infile = new File(infilepath);
		outfile = new File(outfilepath);
		//コピー実行
		if(new Tool_FileCopy().copyFile(infile, outfile) == false){
			request.setAttribute("TITLE", title );
			request.setAttribute("MSG", "ファイルコピーに失敗しました<br>infile="+infilepath+
									"<br>outfile="+outfilepath);
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}
		
		
		//******************************************************************
		//* プロジェクトディレクトリ作成
		//******************************************************************
		//***************************************
		//* プロジェクトフィアルのアクセス準備
		//***************************************
		scon = getServletConfig().getServletContext();
		filePath = scon.getInitParameter("masterDir") +
							scon.getInitParameter("projectFile");
		AdminProject_IO ap = new AdminProject_IO();
		ap.setFilePath(filePath);
		byte loadrtn = ap.load();

		if(loadrtn == (byte)1){
			//ロード成功
		}else if(loadrtn == (byte)2){
			//* ファイルなし
			request.setAttribute("TITLE", title );
			request.setAttribute("MSG", "プロジェクトファイルは未作成です"+ filePath);
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		
		}else{
			//* ロード失敗
			request.setAttribute("TITLE", title );
			request.setAttribute("MSG", "プロジェクトファイルのロードに失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}   	
    	
		String projectfilePath = serverDir + "project" + fs.getFs()  
									+ ap.getProject() + fs.getFs();
		if( new File(projectfilePath).mkdir() == false){
			request.setAttribute("TITLE", title );
			request.setAttribute("MSG", "ディレクトリの作成に失敗しました<br>path="+filePath);
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}
		

		//***************************************
		//* コミュニティ関連設定ファイルコピー
		//***************************************
		infilepath  = scon.getInitParameter("masterDir") + scon.getInitParameter("communityFile");
		outfilepath =projectfilePath + scon.getInitParameter("communityFile");
		infile  = new File(infilepath);
		outfile = new File(outfilepath);
		//コピー実行
		if(new Tool_FileCopy().copyFile(infile, outfile) == false){
			request.setAttribute("TITLE", title );
			request.setAttribute("MSG", "ファイルコピーに失敗しました<br>infile="+infilepath+
									"<br>outfile="+outfilepath);
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}
		
		infilepath  = scon.getInitParameter("masterDir") + scon.getInitParameter("communityMenberFile");
		outfilepath =projectfilePath + scon.getInitParameter("communityMenberFile");
		infile  = new File(infilepath);
		outfile = new File(outfilepath);
		//コピー実行
		if(new Tool_FileCopy().copyFile(infile, outfile) == false){
			request.setAttribute("TITLE", title );
			request.setAttribute("MSG", "ファイルコピーに失敗しました<br>infile="+infilepath+
									"<br>outfile="+outfilepath);
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}

		
		//***************************************
		//*マスターファイル作成
		//***************************************
		filePath = scon.getInitParameter("serverDir") +
		scon.getInitParameter("MasterFile");
		AdminMasterFile_IO amf = new AdminMasterFile_IO();
		amf.setFilePath(filePath);

		Struct_MasterFile smf = new Struct_MasterFile ();
		smf.setMasterdir(scon.getInitParameter("masterDir"));
		amf.setSmf(smf);
		
		if(amf.save() == false){
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "マスターファイルの作成に失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return false;
		}
		
		return true;
		
	}
	
	
	
	private void updatemode(HttpServletRequest request,ServletContext scon,HttpSession session){
		String updateprm = (String) scon.getAttribute("UPDATEMODE");
		if(updateprm == null || 
			updateprm.equals(session.getId()) == false){
			return;
		}
		request.setAttribute("UPDATEMODE","yes");
	}

	//サーバ監視
	private boolean server_Watch(	String jpsCMD,
									String serverPGM) throws IOException{
		//***************************************
		//* サーバー監視
		//***************************************
		String stdout = new String();
		//jpsコマンド発行
		ProcessBuilder builder = new ProcessBuilder(jpsCMD);
   		Process process = builder.start();

		//標準出力を取得
   		InputStream stream = process.getInputStream();
   		BufferedReader br = new BufferedReader(new InputStreamReader(stream)); 
   		String line;
		while ((line = br.readLine()) != null) {
   			stdout += line;
   		}
   		
		//サーバ起動チェック
		if(stdout.indexOf(serverPGM) == -1){
			return false;
		}
		return true;
		
	}
	

	
	
}
