package comon;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Enumeration;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import structure.Struct_Session;


public class ComonUpdateMode extends HttpServlet{

	private String urlfoward 	= new String("/servlet/framecomonupdatemode");
	private String urlsessionout = new String("/servlet/sessionout");

	//***********************************************
	//* リンク呼び出しのため、doGet
	//***********************************************
	public void doGet(HttpServletRequest request, HttpServletResponse response)
	throws IOException, ServletException{
		
		//***************************************
		//* 初期設定
		//***************************************
		ServletContext scon = getServletConfig().getServletContext();
		HttpSession session = request.getSession(false);
		//* リクエストオブジェクトの文字コード設定
		request.setCharacterEncoding("UTF-8");
		
		//***************************************
		//* セッションチェック
		//***************************************
		if(session_Check(scon,session) == false){
			HttpSession newsession = request.getSession(true);
			getServletContext().getRequestDispatcher(urlsessionout).forward(request, response);			
			return;
		}
		
		//セッション情報の設定
		ArrayList<Struct_Session> arraysession = dataSet(request,scon);
		
		//***************************************
		//* 更新モードの取得
		//***************************************
		String updatemode;
		String updateprm = (String) scon.getAttribute("UPDATEMODE");
		//***************************************
		//* セッション情報の取得
		//***************************************
		Struct_Session ss = (Struct_Session) request.getSession(false).getAttribute("SESSION");
		
		boolean[] authrows = null;
		if( updateprm == null ){
			//更新モードＯＮ可能状態
			updatemode = "modeon";
			scon.setAttribute("UPDATEMODE", ss.getSessionnumber());
			//自ユーザーに目印をつける
			ownSessionNumberMark(request,ss.getSessionnumber(),arraysession);			
		}else{
			if(session.getId().equals(updateprm)){
				//更新モードＯＦＦ可能状態
				updatemode = "modeoff";
				//自ユーザーに目印をつける
				ownSessionIDMark(request,ss.getSessionid(),arraysession);			
			}
			else if(ss.getSessionnumber().equals(updateprm)){
				//更新モードＯＮ可能状態
				updatemode = "modeon";
				//自ユーザーに目印をつける
				ownSessionNumberMark(request,ss.getSessionnumber(),arraysession);			
			}
			else{
				//自分がアドミン権限の場合
				if(ss.isAdmin()){
					//別セッションで更新モードＯＮ状態
					updatemode = "force";
					//権限を持つセッションに目印をつける
					otherSessionMark(request,session,updateprm,arraysession);			
				}else{
					if(otherAdmin(request,session,updateprm,arraysession,response)){
						//相手がアドミン権限の場合
						//権限を持つセッションに目印をつける
						otherSessionMark(request,session,updateprm,arraysession);			
						updatemode = "noaction";
						request.setAttribute("MSG", "Adminユーザー権限が更新モードに介入している間は変更できません");
					}else{
						//別セッションで更新モードＯＮ状態
						updatemode = "force";
						//権限を持つセッションに目印をつける
						otherSessionMark(request,session,updateprm,arraysession);			
					}
					
				}
			}
		}
		
		request.setAttribute("UPDATEMODE"	,updatemode);
		getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
		return;
	}

	
	public void doPost(HttpServletRequest request, HttpServletResponse response)
	throws IOException, ServletException{

		//***************************************
		//* 初期設定
		//***************************************
		ServletContext scon = getServletConfig().getServletContext();
		HttpSession session = request.getSession(false);
		//* リクエストオブジェクトの文字コード設定
		request.setCharacterEncoding("UTF-8");
		
		//***************************************
		//* セッションチェック
		//***************************************
		if(session_Check(scon,session) == false){
			HttpSession newsession = request.getSession(true);
			getServletContext().getRequestDispatcher(urlsessionout).forward(request, response);			
			return;
		}

		//セッション情報の設定
		ArrayList<Struct_Session> arraysession = dataSet(request,scon);
		boolean[] authrows = null;
		
		Struct_Session ss = (Struct_Session) session.getAttribute("SESSION");
		String updateprm = (String) scon.getAttribute("UPDATEMODE");
		//更新モードを選択した場合
		if(request.getParameter("modeon") != null){
			if(ss.getSessionnumber().equals(updateprm) == false){
				//自分のセッションナンバーではないので更新モード不可
				if(ss.isAdmin()){
					//自分がアドミン権限の場合
					request.setAttribute("UPDATEMODE"	,"force");
					request.setAttribute("MSG", "更新モードを変更する権限を失いました");
					//権限を持つセッションに目印をつける
					otherSessionMark(request,session,updateprm,arraysession);			
					getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
					return;
				}else{
					//自分がアドミン権限ではない場合
					if(otherAdmin(request,session,updateprm,arraysession,response)){
						//相手がアドミン権限の場合
						//権限を持つセッションに目印をつける
						otherSessionMark(request,session,updateprm,arraysession);			
						request.setAttribute("UPDATEMODE"	,"noaction");
						request.setAttribute("MSG", "Adminユーザーが更新モードに介入している間は変更できません");
					}else{
						scon.setAttribute("UPDATEMODE", ss.getSessionnumber());
						request.setAttribute("UPDATEMODE"	,"force");
						request.setAttribute("MSG", "更新モードを変更する権限を失いました");
						//自ユーザーに目印をつける
						ownSessionNumberMark(request,ss.getSessionnumber(),arraysession);			
						getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
						return;
						
					}
				}
			}
			scon.setAttribute("UPDATEMODE", ss.getSessionid());
			request.setAttribute("UPDATEMODE"	,"modeoff");
			request.setAttribute("MSG", "更新モードにしました");
			ownSessionIDMark(request,ss.getSessionid(),arraysession);			
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		}
		//更新モード開放を選択した場合
		else if(request.getParameter("modeoff") != null){
			if(session.getId().equals(updateprm) == false){
				//自分のセッションＩＤではない
				if(ss.isAdmin()){
					//自分がアドミン権限の場合
					request.setAttribute("UPDATEMODE"	,"force");
					request.setAttribute("MSG", "更新モードを変更する権限を失いました");
					//権限を持つセッションに目印をつける
					otherSessionMark(request,session,updateprm,arraysession);			
					getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
					return;
				}else{

					//自分が一般ユーザーの場合
					if(otherAdmin(request,session,updateprm,arraysession,response)){
						//相手がアドミン権限の場合
						otherSessionMark(request,session,updateprm,arraysession);			
						request.setAttribute("UPDATEMODE"	,"noaction");
						request.setAttribute("MSG", "Adminユーザーが更新モードに介入している間は変更できません");
						getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
						return;
					}else{
						request.setAttribute("UPDATEMODE"	,"force");
						request.setAttribute("MSG", "更新モードを変更する権限を失いました");
						//権限を持つセッションに目印をつける
						otherSessionMark(request,session,updateprm,arraysession);			
						getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
						return;
						
					}
				}
			}
			scon.setAttribute("UPDATEMODE", ss.getSessionnumber());
			request.setAttribute("UPDATEMODE"	,"modeon");
			request.setAttribute("MSG", "更新モードを開放しました");
			//自ユーザーに目印をつける
			ownSessionNumberMark(request,ss.getSessionnumber(),arraysession);			
			getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
			return;
		}
		//更新モード強制開放を選択した場合
		else if(request.getParameter("forcemodeoff") != null){
			//自分がアドミン権限の場合
			if(ss.isAdmin()){
				scon.setAttribute("UPDATEMODE", ss.getSessionnumber());
				request.setAttribute("UPDATEMODE"	,"modeon");
				request.setAttribute("MSG", "更新モードを強制開放しました");
				//自ユーザーに目印をつける
				ownSessionNumberMark(request,ss.getSessionnumber(),arraysession);			
				getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
				return;
			}else{
				if(otherAdmin(request,session,updateprm,arraysession,response)){
					//相手がアドミン権限の場合
					//権限を持つセッションに目印をつける
					otherSessionMark(request,session,updateprm,arraysession);			
					request.setAttribute("UPDATEMODE"	,"noaction");
					request.setAttribute("MSG", "Adminユーザーが更新モードに介入している間は変更できません");
					return;
				}else{
					scon.setAttribute("UPDATEMODE", ss.getSessionnumber());
					request.setAttribute("UPDATEMODE"	,"modeon");
					request.setAttribute("MSG", "更新モードを強制開放しました");
					//自ユーザーに目印をつける
					ownSessionNumberMark(request,ss.getSessionnumber(),arraysession);			
					getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
					return;
				}
			}

			
		}
		
	}
	//セッションチェック
	private boolean session_Check(ServletContext scon,HttpSession session){
		//セッションが切れた場合、は処理続行不可
		if(session == null){
			return false;
		 }
		//ログオンを通過していない場合は処理続行不可
		if(	session.getAttribute("USER") == null){
			return false;
		 }

		//セッションオブジェクトのセッション情報を紛失したは処理続行不可
		Struct_Session ss = (Struct_Session) session.getAttribute("SESSION");
		if(ss == null){
			return false;
		}		
		//サーブレットコンテキストのセッションナンバーを紛失した場合は処理続行不可
		if(scon.getAttribute(ss.getSessionnumber())	== null){
			return false;
		}		
		return true;
	}
	
	private ArrayList<Struct_Session> dataSet(HttpServletRequest request,ServletContext scon){
		//***************************************
		//* アクセスユーザーの取得
		//***************************************
		ArrayList<Struct_Session> arraysession = new ArrayList();
		Enumeration eParmNames =	scon.getAttributeNames();
		while (eParmNames.hasMoreElements()) {
			String parm = (String) eParmNames.nextElement();
			if(parm.indexOf("SESSIONCOUNT")==0) {
				//セッションカウンターは対象外
			}
			else if(parm.indexOf("SESSION")==0) {
				arraysession.add((Struct_Session) scon.getAttribute(parm));
			}
		 }

		String sessionuser[] 	= new String[arraysession.size()];
		String sessionunumber[] = new String[arraysession.size()];
		String sessionid[] 		= new String[arraysession.size()];
		String logondate[]		= new String[arraysession.size()];

    	DateFormat dfm = new SimpleDateFormat("yyyyMMdd_HHmmss");

		for(int i=0;i<arraysession.size();i++){
			sessionuser[i] 		=  arraysession.get(i).getUserid();
			sessionunumber[i]	=  arraysession.get(i).getSessionnumber();
			sessionid[i] 		=  arraysession.get(i).getSessionid();
			logondate[i]	= dfm.format(arraysession.get(i).getLogondate());
		}
		request.setAttribute("SESSIONUSER"	,sessionuser);
		request.setAttribute("SESSIONNUMBER",sessionunumber);
		request.setAttribute("SESSIONID"	,sessionid);
		request.setAttribute("LOGONDATE"	,logondate);
		
		return arraysession;
	}

	private void ownSessionNumberMark(HttpServletRequest request,String sessionnumber,ArrayList<Struct_Session> arraysession){
		boolean[] authrows = null;
		int search = sessionNumberSerach(sessionnumber,arraysession);
		if(search>-1){
			authrows = new boolean[arraysession.size()];
			authrows[search] = true;
		}
		request.setAttribute("AUTHROWS"	,authrows);
		request.setAttribute("AUTHORITY"	,"○");
	}
	private void ownSessionIDMark(HttpServletRequest request,String sessionID,ArrayList<Struct_Session> arraysession){
		boolean[] authrows = null;
		int search = sessionIDSerach(sessionID,arraysession);
		if(search>-1){
			authrows = new boolean[arraysession.size()];
			authrows[search] = true;
		}
		request.setAttribute("AUTHROWS"	,authrows);
		request.setAttribute("AUTHORITY"	,"●");
	}
	private String otherSessionMark(HttpServletRequest request,HttpSession session,String updateprm,ArrayList<Struct_Session> arraysession){
		boolean[] authrows = null;
		String othersessionnumber = null;
		if(updateprm.indexOf("SESSION") == 0){
			int search = sessionNumberSerach(updateprm,arraysession);
			if(search>-1){
				authrows = new boolean[arraysession.size()];
				authrows[search] = true;
				request.setAttribute("AUTHROWS"	,authrows);
				request.setAttribute("AUTHORITY"	,"○");
				return arraysession.get(search).getSessionnumber();
			}
			
		}else{
			int search = sessionIDSerach(updateprm,arraysession);
			if(search>-1){
				authrows = new boolean[arraysession.size()];
				authrows[search] = true;
				request.setAttribute("AUTHROWS"	,authrows);
				request.setAttribute("AUTHORITY"	,"●");
				return  arraysession.get(search).getSessionnumber();
			}
		}		
		return null;
	}
	//[SESSION]サーブレットコンテキストからセッションナンバーを取得して
	//そのセッションがアドミン権限の場合、trueを返す
	private boolean otherAdmin(HttpServletRequest request,
								HttpSession session,
								String updateprm,
								ArrayList<Struct_Session> arraysession,
								HttpServletResponse response)
	throws IOException, ServletException{
		String othersessionnumber = null;
		if(updateprm.indexOf("SESSION") == 0){
			for(int i=0;i<arraysession.size();i++){
				if(arraysession.get(i).getSessionnumber().equals(updateprm)){
					if(arraysession.get(i).isAdmin() == true){
						return true;
					}else{
						return false;
					}
				}
			}
		}else{
			for(int i=0;i<arraysession.size();i++){
				if(arraysession.get(i).getSessionid().equals(updateprm)){
					if(arraysession.get(i).isAdmin() == true){
						return true;
					}else{
						return false;
					}
				}
			}
		}		
		return false;
	
	}	
	
	
	private int sessionNumberSerach(String sessionnumber,ArrayList<Struct_Session> arraysession){
		for(int i=0;i<arraysession.size();i++){
			if(arraysession.get(i).getSessionnumber().equals(sessionnumber)){
				return i;
			}
		}
		return -1;
	}
	private int sessionIDSerach(String sessionID,ArrayList<Struct_Session> arraysession){
		for(int i=0;i<arraysession.size();i++){
			if(arraysession.get(i).getSessionid().equals(sessionID)){
				return i;
			}
		}
		return -1;
	}
	
}
