package gener;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

import structure.File_Separator;
import structure.Struct_Community_Menber;
import structure.Struct_History;
import structure.Struct_Menber;
import structure.Struct_Session;
import structure.Struct_User;
import structure.Struct_UserConfirm;
import tool.Tool_DirDel;
import tool.Tool_FileCopy;
import tool.Tool_Zip;
import tool.Tool_unZIP;
import beansApp.AdminCommunityMenber_IO;
import beansApp.AdminHistory_IO;
import beansApp.AdminMenber_IO;
import beansApp.AdminProject_IO;
import beansApp.AdminUserConfirm_IO;
import beansApp.AdminUser_IO;
import beansApp.GenerCommunitySelect_IO;
import beansApp.Gener_WindowList_IO;

public class GenerDownload  extends HttpServlet{
	
	private String urlfoward 		= new String("/servlet/framegenerdownload");
	private String urlsessionout 	= new String("/servlet/sessionout");
	private String urlMSG 			= new String("/servlet/framecommonmessage");

	private String title = "ダウンロード";
	
	//***********************************************
	//* リンク呼び出しのため、doGet
	//***********************************************
	public void doGet(HttpServletRequest request, HttpServletResponse response)
	throws IOException, ServletException{

		//***************************************
		//* 初期設定
		//***************************************
		ServletContext scon = getServletConfig().getServletContext();
		HttpSession session = request.getSession(false);
		//* リクエストオブジェクトの文字コード設定
		request.setCharacterEncoding("UTF-8");
		
		//***************************************
		//* セッションチェック
		//***************************************
		if(session_Check(scon,session) == false){
			HttpSession newsession = request.getSession(true);
			getServletContext().getRequestDispatcher(urlsessionout).forward(request, response);			
			return;
		}

		//***************************************
		//* ヒストリーフィアルのアクセス準備
		//***************************************
		String filePath = scon.getInitParameter("masterDir") +
							scon.getInitParameter("HistoryFile");
		AdminHistory_IO ah = new AdminHistory_IO();
		ah.setFilePath(filePath);
		ArrayList<Struct_History> data;
		byte loadrtn = ah.load();
		if(loadrtn == (byte)1){
			//* ロード成功
			data= ah.getData();
			
		}else if(loadrtn == (byte)2){
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "ヒストリーファイルのロードは未作成です");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
		}else{
			//* ロード失敗
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "ヒストリーファイルのロードに失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
		}			

		
		
		String version 	= double2String_keta2(data.get(0).getVersion());

		request.setAttribute("VERSION"		,	version);
		getServletContext().getRequestDispatcher(urlfoward).forward(request, response);			
		return;
		
	}
	
	public void doPost(HttpServletRequest request, HttpServletResponse response)
	throws IOException, ServletException{

		//***************************************
		//* 初期設定
		//***************************************
		ServletContext scon = getServletConfig().getServletContext();
		HttpSession session = request.getSession(false);
		//* リクエストオブジェクトの文字コード設定
		request.setCharacterEncoding("UTF-8");
		
		//***************************************
		//* セッションチェック
		//***************************************
		if(session_Check(scon,session) == false){
			HttpSession newsession = request.getSession(true);
			getServletContext().getRequestDispatcher(urlsessionout).forward(request, response);			
			return;
		}

		//***************************************
		//* プロジェクトフィアルのアクセス準備
		//***************************************
		String project ;
		String filePath = scon.getInitParameter("masterDir") +
							scon.getInitParameter("projectFile");
		AdminProject_IO ap = new AdminProject_IO();
		ap.setFilePath(filePath);
		byte loadrtn = ap.load();

		if(loadrtn == (byte)1){
			project= ap.getProject();
		}else if(loadrtn == (byte)2){
			//* ファイルなし
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "プロジェクトファイルは未作成です"+ filePath);
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
		
		}else{
			//* ロード失敗
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "プロジェクトファイルのロードに失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
		}
		
		//****************************
		//* メンバーフィアルのロード準備
		//****************************
		String uid = (String) request.getSession(false).getAttribute("USER");
		String user_fullname = new String();;
		String node = new String();;
		filePath = scon.getInitParameter("masterDir") +
					scon.getInitParameter("menberFile");
		AdminMenber_IO am = new AdminMenber_IO();
		am.setFilePath(filePath);
		loadrtn = am.load();
		ArrayList<Struct_Menber> menberData = null;
		
		if(loadrtn == (byte)1){
			//* ロード成功
			menberData	= am.getdata();
		
		}else if(loadrtn == (byte)2){
			//* ファイルなし
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "メンバーファイルは未作成です");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
		}else{
			//* ロード失敗
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "メンバーファイルのロードに失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
		}				
		
		boolean found = false;
		int line = 0;
		for(int i=0 ; i<menberData.size() ;i++){
			if(menberData.get(i).getUserid().equals(uid) == true){
				user_fullname = menberData.get(i).getUser_fullname();
				if( user_fullname == null && user_fullname.length() == 0){
					request.setAttribute("TITLE",	title);
					request.setAttribute("MSG", "一般ユーザーの名称がありません");
					getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
					return;
				}
				node = menberData.get(i).getNode();
				if( node == null && node.length() == 0){
					request.setAttribute("TITLE",	title);
					request.setAttribute("MSG", "一般ユーザーのノードがありません");
					getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
					return;
				}
				found = true;
				line = i;
				break;
			}
		}
		
		if(found == false){
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "一般ユーザーがありません");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
		}
		
		
		//***********************************************
		//* コミュニティメンバーファイルのアクセス準備
		//***********************************************
		ArrayList<Struct_Community_Menber> commenData;
		filePath = scon.getInitParameter("masterDir") +
					scon.getInitParameter("communityMenberFile");
		AdminCommunityMenber_IO acm = new AdminCommunityMenber_IO();
		acm.setFilePath(filePath);
		loadrtn = acm.load();

		if(loadrtn == (byte)1){
			//* ロード成功
			commenData	= acm.getCommunity(uid);
		}else if(loadrtn == (byte)2){		
			//* ファイルなし
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "コミュニティメンバーファイルは未作成です");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
			
		}else{
			//* ロード失敗
			request.setAttribute("TITLE",	title);
			request.setAttribute("MSG", "コミュニティメンバーファイルのロードに失敗しました");
			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
			return;
		}			

		//*********************************************************************************
		//* クライアント環境一式を圧縮してテンポラリーディレクトリにコピーしてから解凍する
		//*********************************************************************************
		//ＯＳ依存のファイルセパレータ
		File_Separator fs = new File_Separator();
		String version = (String) request.getParameter("version");
		
    	//日付のフォーマット変換
    	long nowtime = System.currentTimeMillis();
    	DateFormat dfm = new SimpleDateFormat("yyyyMMdd_HHmmssSSS");
    	String timestamp = dfm.format(nowtime);

    	//**********************************************************
    	//* プログラムダウンロード
    	//**********************************************************
		if(request.getParameter("select").equals("program")){
			//*********************************************
			//* ファイル定義
			//*********************************************
	    	String mailcostzip		=  "mailcost_" + timestamp+".zip";
	    	String mailcostDir		=  "mailcost_" + timestamp + fs.getFs();
	    	String temporaryzip		=  "temp_" + timestamp+".zip";

			//*********************************************
			//* 圧縮ファイルを作成する
			//*********************************************
			String inDirPath 	=  scon.getInitParameter("mailcostDir")+ "_" + 
										version.replace(".", "_") + fs.getFs();
			String outZippath	= scon.getInitParameter("temporaryDir") +mailcostzip;
			Tool_Zip tz = new Tool_Zip();
			tz.submit(outZippath, inDirPath);

			//*********************************************
			//* 圧縮ファイルを展開する
			//*********************************************
			String inZipPath = outZippath;
			String outDirPath = scon.getInitParameter("temporaryDir");
			Tool_unZIP unzip = new Tool_unZIP();
			unzip.submit(inZipPath, outDirPath,temporaryzip,true);
			
			//*********************************************
			//* 一般ユーザー毎のWindowList作成
			//*********************************************
			DefaultMutableTreeNode root = new DefaultMutableTreeNode(user_fullname);
			JTree tree = new JTree(root);
			
			//１階層ノードの作成(プロジェクトノード)
//			ImageIcon icon = new ImageIcon(scon.getInitParameter("clienticonDir")+"\\project.gif");
//			Struct_AbstractAction iconProject = new Struct_AbstractAction(project,icon);
//		    JLabel iconProject = new JLabel(project);
//			ImageIcon icon2 = new ImageIcon();
//			icon2.setDescription(icon.getDescription());
//			icon2.setImageObserver(icon.getImageObserver());
//			icon2.setImage(icon.getImage());
//		    iconProject.setIcon(icon2);

			
//			DefaultMutableTreeNode nodeProject = new DefaultMutableTreeNode(iconProject);
			DefaultMutableTreeNode nodeProject = new DefaultMutableTreeNode(project);
			root.add(nodeProject);
			
			//２階層ノードの作成(コミュニティノード)
			DefaultMutableTreeNode nodecommunity = new DefaultMutableTreeNode("Community");
			nodeProject.add(nodecommunity);
			
			//３階層ノードの作成(コミュニティ)
			for(int i=0;i<commenData.size();i++){
				nodecommunity.add(new DefaultMutableTreeNode(commenData.get(i).getCommunity()));
			}

			//２階層ノードの作成(コストノード)
			DefaultMutableTreeNode nodeCost = new DefaultMutableTreeNode("Cost");
			nodeProject.add(nodeCost);
			//３階層ノードの作成(コスト要素)
			nodeCost.add(new DefaultMutableTreeNode("Send"));
			nodeCost.add(new DefaultMutableTreeNode("Recieve"));
			nodeCost.add(new DefaultMutableTreeNode("Analysis"));
			
			//展開
	   		DefaultMutableTreeNode dummynode = root;
			int row_total = 0;
	   		while(true){
	   			row_total++;
	   			dummynode = dummynode.getNextNode();
	   			if(dummynode == null)break;
	   		}
	   		for(int i=0;i<row_total;i++){
	   			tree.expandRow(i);
	   		}
			
			//コミュニティノードの第一子を選択状態にする
			tree.setSelectionRow(3);
			
//			tree.setCellRenderer(new Tool_CellRenderer());

			
			//***********************************************
			//* ウインドウリストファイルのアクセス準備
			//***********************************************
			String windowlist_filePath = scon.getInitParameter("temporaryDir") +
											mailcostDir  +
											scon.getInitParameter("windowlistFile");
			Gener_WindowList_IO gwl = new Gener_WindowList_IO();
			gwl.putJTree(tree);
			gwl.setFilePath(windowlist_filePath);
			if(gwl.save() == false){
				request.setAttribute("TITLE",	title);
				request.setAttribute("MSG", "ウインドウリストの登録・変更に失敗しました");
				getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
				return;
			}
			
			//***************************************
			//*ユーザーファイルのアクセス準備
			//***************************************
			Struct_User sui;
			filePath = scon.getInitParameter("temporaryDir") +
						mailcostDir + scon.getInitParameter("userinitFile");
			AdminUser_IO aui = new AdminUser_IO();
			aui.setFilePath(filePath);
			loadrtn = aui.load();
			if(loadrtn == (byte)1){
				//* ロード成功
				sui = (Struct_User)aui.getData();
			}else if(loadrtn == (byte)2){		
				//* ファイルなし
				request.setAttribute("TITLE",	title);
				request.setAttribute("MSG", "ユーザー初期情報ファイルは未作成です");
				getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
				return;
				
			}else{
				//* ロード失敗
				request.setAttribute("TITLE",	title);
				request.setAttribute("MSG", "ユーザー初期情報ファイルのロードに失敗しました");
				getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
				return;
			}				
					
			sui.setUserid(uid);
			sui.setUser_fullname(user_fullname);
			sui.setNode(node);
			sui.setLastbatchtimestamp(System.currentTimeMillis());
			if(aui.save() == false){
				request.setAttribute("TITLE",	title);
				request.setAttribute("MSG", "ユーザー初期情報の登録・変更に失敗しました");
				getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
				return;
			}
			
			
			//***************************************
			//*参加コミュニティファイルのアクセス準備
			//***************************************
			filePath = scon.getInitParameter("temporaryDir") +
						mailcostDir  + 	"project" + fs.getFs() +
						project +	fs.getFs() +
						scon.getInitParameter("communityselectFile");
			GenerCommunitySelect_IO gcs = new GenerCommunitySelect_IO();
			gcs.setFilePath(filePath);

			//***************************************
			//*参加コミュニティ追加
			//***************************************
	    	DefaultListModel listmodel = new DefaultListModel();
			for(int i=0;i<commenData.size();i++){
		    	listmodel.addElement(commenData.get(i).getCommunity());
			}
	    	JList list = new JList(listmodel);
			gcs.setData(list);
			if(gcs.save() == false){
				request.setAttribute("TITLE",	title);
				request.setAttribute("MSG", "参加コミュニティの登録・変更に失敗しました");
				getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
				return;
			}		
			

			//*********************************************
			//*ディレクトリ追加
			//*********************************************
			//コミュニティ
			for(int i=0;i<commenData.size();i++){
				new File(scon.getInitParameter("temporaryDir") +
						mailcostDir + "project" + fs.getFs() +
						project + fs.getFs() +
						commenData.get(i).getCommunity()).mkdir();
			}
			//コスト
			new File(scon.getInitParameter("temporaryDir") +
					mailcostDir + "project" + fs.getFs() +
					project + fs.getFs() +
					"cost").mkdir();
			new File(scon.getInitParameter("temporaryDir") +
					mailcostDir + "project" + fs.getFs() +
					project + fs.getFs() +
					"cost" + fs.getFs() +
					"send"	).mkdir();
			new File(scon.getInitParameter("temporaryDir") +
					mailcostDir + "project" + fs.getFs() +
					project + fs.getFs() +
					"cost" + fs.getFs() +
					"recieve"	).mkdir();
			new File(scon.getInitParameter("temporaryDir") +
					mailcostDir + "project" + fs.getFs() +
					project + fs.getFs() +
					"cost" + fs.getFs() +
					"analysis"	).mkdir();
			
			//*********************************************
			//* 圧縮ファイル作成（ダウンロード用）
			//*********************************************
			String outfile	= scon.getInitParameter("mailcostFile");
			inDirPath 	=  scon.getInitParameter("temporaryDir") + 	mailcostDir;
			outZippath	= scon.getInitParameter("downlaodDir") + mailcostzip;
			tz.submit(outZippath, inDirPath);
			
			
			//*********************************************
			//* ダウンロード
			//*********************************************
			//キャンセルしても後始末できるようにtryで括る
			try{
				response.setContentType("application/octet-stream");
				response.setHeader("Content-Disposition"
				         , "attachment; filename=\""+"mailcost.zip"+"\"");
				OutputStream out = response.getOutputStream();
				    
				byte buffer[]  = new byte[1024];
				FileInputStream fin = new FileInputStream(outZippath);

				int size;
				while((size = fin.read(buffer))!=-1) {
				   	out.write(buffer,0, size);
				}
				out.close();
				
			}catch(Exception e){
				
			}

			//*********************************************
			//* 後始末
			//*********************************************
			//* テンポラリー　メールコスト環境一式
			System.out.println(inDirPath);
			new Tool_DirDel(inDirPath).delete();
			//圧縮ファイルは削除できないので、古いファイル(６０秒前)をクリアする
	    	File[] files=new File(scon.getInitParameter("downlaodDir")).listFiles();
	    	for(int i=0;i<files.length;i++){
	    		if(files[i].isFile() &&
	   				files[i].lastModified() < System.currentTimeMillis()-60*1000){
	    			files[i].delete();
	    		}
	    	}			
		}
    	//**********************************************************
    	//* プロジェクト追加データダウンロード
    	//**********************************************************
		else if(request.getParameter("select").equals("data")){
			//*********************************************
			//* ファイル定義
			//*********************************************
	    	String projectzip		=  "project_" + timestamp+".zip";
	    	String projectDir		=  "project_" + timestamp + fs.getFs();
	    	String temporaryzip		=  "temp_" + timestamp+".zip";

			//*********************************************
			//* 圧縮ファイルを作成する
			//*********************************************
			String inDirPath 	=  scon.getInitParameter("mailcostDir")+ "_" + 
										version.replace(".", "_") + fs.getFs()+
										"project" + fs.getFs() + project;
			String outZippath	= scon.getInitParameter("temporaryDir") +projectzip;
			Tool_Zip tz = new Tool_Zip();
			tz.submit(outZippath, inDirPath);

			//*********************************************
			//* 圧縮ファイルを展開する
			//*********************************************
			String inZipPath = outZippath;
			String outDirPath = scon.getInitParameter("temporaryDir");
			Tool_unZIP unzip = new Tool_unZIP();
			unzip.submit(inZipPath, outDirPath,temporaryzip,true);

			//*********************************************
			//* 一般ユーザー毎のWindowList作成
			//*********************************************
			//ルートはプロジェクト名
			DefaultMutableTreeNode root = new DefaultMutableTreeNode(project);
			JTree tree = new JTree(root);
			
			//１階層ノードの作成(コミュニティノード)
			DefaultMutableTreeNode nodecommunity = new DefaultMutableTreeNode("Community");
			root.add(nodecommunity);
			
			//２階層ノードの作成(コミュニティ)
			for(int i=0;i<commenData.size();i++){
				nodecommunity.add(new DefaultMutableTreeNode(commenData.get(i).getCommunity()));
			}

			//１階層ノードの作成(コストノード)
			DefaultMutableTreeNode nodeCost = new DefaultMutableTreeNode("Cost");
			root.add(nodeCost);
			//２階層ノードの作成(コスト要素)
			nodeCost.add(new DefaultMutableTreeNode("Send"));
			nodeCost.add(new DefaultMutableTreeNode("Recieve"));
			nodeCost.add(new DefaultMutableTreeNode("Analysis"));
			
			//***********************************************
			//* ウインドウリストファイルのアクセス準備
			//***********************************************
			String windowlist_filePath = scon.getInitParameter("temporaryDir") +
											projectDir  +
											scon.getInitParameter("windowlistFile");
			Gener_WindowList_IO gwl = new Gener_WindowList_IO();
			gwl.putJTree(tree);
			gwl.setFilePath(windowlist_filePath);
			if(gwl.projectsave() == false){
				request.setAttribute("TITLE",	title);
				request.setAttribute("MSG", "ウインドウリストの登録・変更に失敗しました");
				getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
				return;
			}
						
			//***************************************
			//*確認用ユーザーファイルのアクセス準備
			//***************************************
			Struct_User sui;
			filePath = scon.getInitParameter("temporaryDir") +
						projectDir + scon.getInitParameter("userconfirmFile");
			AdminUserConfirm_IO auci = new AdminUserConfirm_IO();
			auci.setFilePath(filePath);

			Struct_UserConfirm suc = new Struct_UserConfirm();
			suc.setUserid(uid);
			suc.setUser_fullname(user_fullname);
			suc.setNode(node);
			auci.setData(suc);

			if(auci.save() == false){
				request.setAttribute("TITLE",	title);
				request.setAttribute("MSG", "確認用ユーザー情報の登録・変更に失敗しました");
				getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
				return;
			}

			//***************************************
			//*参加コミュニティファイルのアクセス準備
			//***************************************
			filePath = scon.getInitParameter("temporaryDir") +
						projectDir  + 	fs.getFs() +
						scon.getInitParameter("communityselectFile");
			GenerCommunitySelect_IO gcs = new GenerCommunitySelect_IO();
			gcs.setFilePath(filePath);

			//***************************************
			//*参加コミュニティ追加
			//***************************************
	    	DefaultListModel listmodel = new DefaultListModel();
			for(int i=0;i<commenData.size();i++){
		    	listmodel.addElement(commenData.get(i).getCommunity());
			}
	    	JList list = new JList(listmodel);
			gcs.setData(list);
			if(gcs.save() == false){
				request.setAttribute("TITLE",	title);
				request.setAttribute("MSG", "参加コミュニティの登録・変更に失敗しました");
				getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
				return;
			}		
						
			//***************************************
			//*プロジェクトファイルのコピー
			//***************************************
    		//コピー元
    		String pinfilepath = scon.getInitParameter("mailcostDir")+ "_" + 
								version.replace(".", "_") + fs.getFs() +
								scon.getInitParameter("projectFile");
    		String poutfilepath =scon.getInitParameter("temporaryDir") +
								projectDir  + fs.getFs() +
								scon.getInitParameter("projectFile");
    		File pinfile = new File(pinfilepath);
    		File poutfile = new File(poutfilepath);
    		//コピー実行
    		if(new Tool_FileCopy().copyFile(pinfile, poutfile) == false){
    			request.setAttribute("TITLE", title );
    			request.setAttribute("MSG", "ファイルコピーに失敗しました<br>infile="+pinfilepath+
    									"<br>outfile="+poutfilepath);
    			getServletContext().getRequestDispatcher(urlMSG).forward(request, response);			
    			return;
    		}
			
			
			//*********************************************
			//*ディレクトリ追加
			//*********************************************
			//コミュニティ
			for(int i=0;i<commenData.size();i++){
				new File(scon.getInitParameter("temporaryDir") +
						projectDir + fs.getFs() +
						commenData.get(i).getCommunity()).mkdir();
			}
			//コスト
			new File(scon.getInitParameter("temporaryDir") +
					projectDir  + fs.getFs() +
					"cost").mkdir();
			new File(scon.getInitParameter("temporaryDir") +
					projectDir  + fs.getFs() +
					"cost" + fs.getFs() +
					"send"	).mkdir();
			new File(scon.getInitParameter("temporaryDir") +
					projectDir + fs.getFs() +
					"cost" + fs.getFs() +
					"recieve"	).mkdir();
			new File(scon.getInitParameter("temporaryDir") +
					projectDir  + fs.getFs() +
					"cost" + fs.getFs() +
					"analysis"	).mkdir();
								
			//*********************************************
			//* 圧縮ファイル作成（ダウンロード用）
			//*********************************************
			String outfile	= scon.getInitParameter("mailcostFile");
			inDirPath 	=  scon.getInitParameter("temporaryDir") + 	projectDir;
			outZippath	= scon.getInitParameter("downlaodDir") + projectzip;
			tz.submit(outZippath, inDirPath);
			
			
			//*********************************************
			//* ダウンロード
			//*********************************************
			//キャンセルしても後始末できるようにtryで括る
			try{
				//*日本語対応
				String fileName  = project+".zip";			
				response.setContentType("application/octet-stream;charset=UTF-8");
//				response.setHeader("Content-Disposition"
//				         , "attachment; filename=\""+project+".zip"+"\"");
				response.setHeader("Content-Disposition",
						"attachment; filename=" + URLEncoder.encode(fileName, "UTF-8"));
				OutputStream out = response.getOutputStream();
				    
				byte buffer[]  = new byte[1024];
				FileInputStream fin = new FileInputStream(outZippath);

				int size;
				while((size = fin.read(buffer))!=-1) {
				   	out.write(buffer,0, size);
				}
				out.close();
				
			}catch(Exception e){
				
			}

			//*********************************************
			//* 後始末
			//*********************************************
			//* テンポラリー　メールコスト環境一式
			System.out.println(inDirPath);
			new Tool_DirDel(inDirPath).delete();
			//圧縮ファイルは削除できないので、古いファイル(６０秒前)をクリアする
	    	File[] files=new File(scon.getInitParameter("downlaodDir")).listFiles();
	    	for(int i=0;i<files.length;i++){
	    		if(files[i].isFile() &&
	   				files[i].lastModified() < System.currentTimeMillis()-60*1000){
	    			files[i].delete();
	    		}
	    	}	
			
		}
		
		
		
    	

		return;
		
	}

	//セッションチェック
	private boolean session_Check(ServletContext scon,HttpSession session){
		//セッションが切れた場合、は処理続行不可
		if(session == null){
			return false;
		 }
		//ログオンを通過していない場合は処理続行不可
		if(	session.getAttribute("USER") == null){
			return false;
		 }

		//セッションオブジェクトのセッション情報を紛失したは処理続行不可
		Struct_Session ss = (Struct_Session) session.getAttribute("SESSION");
		if(ss == null){
			return false;
		}		
		//サーブレットコンテキストのセッションナンバーを紛失した場合は処理続行不可
		if(scon.getAttribute(ss.getSessionnumber())	== null){
			return false;
		}		
		return true;
	}
	
	
	private void dataSet(HttpServletRequest request){
		request.setAttribute("VERSION",	request.getParameter("version"));
	}	
	
	private String double2String_keta2(double number){
		DecimalFormat dfuc = new DecimalFormat("#0.00");
		return(dfuc.format(number));
		
	}	
}
