package gener;

import java.io.IOException;
import java.util.ArrayList;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import structure.Struct_Menber;
import structure.Struct_Session;
import beansApp.AdminMenber_IO;


public class GenerPassword extends HttpServlet{

	//***********************************************
	//* リンク呼び出しのため、doGet
	//***********************************************
	public void doGet(HttpServletRequest request, HttpServletResponse response)
	throws IOException, ServletException{

		//***************************************
		//* 初期設定
		//***************************************
		ServletContext scon = getServletConfig().getServletContext();
		HttpSession session = request.getSession(false);
		//* リクエストオブジェクトの文字コード設定
		request.setCharacterEncoding("UTF-8");
		
		//***************************************
		//* セッションチェック
		//***************************************
		if(session_Check(scon,session) == false){
			HttpSession newsession = request.getSession(true);
			getServletContext().getRequestDispatcher("/servlet/sessionout").forward(request, response);			
			return;
		}

		updatemode(request,scon,session);
		getServletContext().getRequestDispatcher("/servlet/framegenerpassword").forward(request, response);			
		return;
		
	}
	
	
	public void doPost(HttpServletRequest request, HttpServletResponse response)
	throws IOException, ServletException{

		//***************************************
		//* 初期設定
		//***************************************
		ServletContext scon = getServletConfig().getServletContext();
		HttpSession session = request.getSession(false);
		//* リクエストオブジェクトの文字コード設定
		request.setCharacterEncoding("UTF-8");
		
		//***************************************
		//* セッションチェック
		//***************************************
		if(session_Check(scon,session) == false){
			HttpSession newsession = request.getSession(true);
			getServletContext().getRequestDispatcher("/servlet/sessionout").forward(request, response);			
			return;
		}

		String uid = (String) request.getSession(false).getAttribute("USER");

		//****************************
		//* 旧パスワード　ナル値チェック
		//****************************
		String oldpsw = (String) request.getParameter("oldpsw");
		if(oldpsw == null || oldpsw.length() == 0){
			request.setAttribute("MSG", "旧パスワードが未入力です");
			getServletContext().getRequestDispatcher("/servlet/framegenerpassword").forward(request, response);			
			return;
		}
		//****************************
		//* 新パスワード　ナル値チェック
		//****************************
		String newpsw = (String) request.getParameter("newpsw");
		if(newpsw == null || newpsw.length() == 0){
			request.setAttribute("MSG", "新パスワードが未入力です");
			getServletContext().getRequestDispatcher("/servlet/framegenerpassword").forward(request, response);			
			return;
		}
		//****************************
		//* 確認パスワード　ナル値チェック
		//****************************
		String cfmpsw = (String) request.getParameter("cfmpsw");
		if(cfmpsw == null || cfmpsw.length() == 0){
			request.setAttribute("MSG", "確認パスワードが未入力です");
			getServletContext().getRequestDispatcher("/servlet/framegenerpassword").forward(request, response);			
			return;
		}
		//****************************
		//* 旧パスワード　文字数チェック
		//****************************
		if(oldpsw.length()<1 || oldpsw.length() > 128){
			request.setAttribute("MSG", "旧パスワードは128文字以下です");
			getServletContext().getRequestDispatcher("/servlet/framegenerpassword").forward(request, response);			
			return;
		}
		//****************************
		//* 新パスワード　文字数チェック
		//****************************
		if(newpsw.length()<6 || newpsw.length() > 128){
			request.setAttribute("MSG", "新パスワードは6文字以上 128文字以下です");
			getServletContext().getRequestDispatcher("/servlet/framegenerpassword").forward(request, response);			
			return;
		}
		//****************************
		//* 確認パスワード　文字数チェック
		//****************************
		if(cfmpsw.length()<6 || cfmpsw.length() > 128){
			request.setAttribute("MSG", "確認パスワードは6文字以上 128文字以下です");
			getServletContext().getRequestDispatcher("/servlet/framegenerpassword").forward(request, response);			
			return;
		}

		//****************************
		//* 確認パスワード　一致チェック
		//****************************
		if(	newpsw.equals(cfmpsw) ==false	){
			request.setAttribute("MSG", "新パスワードと確認パスワードが一致しません");
			getServletContext().getRequestDispatcher("/servlet/framegenerpassword").forward(request, response);			
			return;
		}
		//****************************
		//* メンバーフィアルのロード準備
		//****************************
		String filePath = scon.getInitParameter("masterDir") +
					scon.getInitParameter("menberFile");
		AdminMenber_IO am = new AdminMenber_IO();
		am.setFilePath(filePath);
		byte loadrtn = am.load();
		ArrayList<Struct_Menber> menberData = null;
		
		if(loadrtn == (byte)1){
		//* ロード成功
		menberData	= am.getdata();
		
		}else if(loadrtn == (byte)2){
		//* ファイルなし
		request.setAttribute("TITLE",	"メンバーの登録・変更");
		request.setAttribute("MSG", "認証できません");
		getServletContext().getRequestDispatcher("/servlet/framecommonmessage").forward(request, response);			
		return;
		}else{
		//* ロード失敗
		request.setAttribute("TITLE",	"メンバーの登録・変更");
		request.setAttribute("MSG", "メンバーファイルのロードに失敗しました");
		getServletContext().getRequestDispatcher("/servlet/framecommonmessage").forward(request, response);			
		}		

		//****************************************************************
		//* パスワード　チェック
		//****************************************************************
		boolean found = false;
		int line = 0;
		for(int i=0 ; i<menberData.size() ;i++){
			if(menberData.get(i).getUserid().equals(uid) == true){
				String password = menberData.get(i).getPassword();
				if(password == null || password .length() == 0){
					if(oldpsw.equals(uid+"pw") == true){
						found = true;
					}
				}
				else if(oldpsw.equals(password) == true){
					found = true;
				}
				line = i;
				break;
			}
		}
		
		if(found == false){
			request.setAttribute("MSG", "旧パスワードが違います");
			getServletContext().getRequestDispatcher("/servlet/framegenerpassword").forward(request, response);			
			return;
		}
		
		//****************************
		//* ユーザー＆パスワードの保存
		//****************************
		menberData.get(line).setPassword(newpsw);	
		am.putdata(menberData);
		if(am.save() == false){
			request.setAttribute("MSG", "ユーザーＩＤおよびパスワードの変更に失敗しました");
			getServletContext().getRequestDispatcher("/servlet/framegenerpassword").forward(request, response);			
			return;
		}

		request.setAttribute("MSG", "ユーザーＩＤおよびパスワードを変更しました");
		updatemode(request,scon,session);
		getServletContext().getRequestDispatcher("/servlet/framegenerpassword").forward(request, response);			
		return;
	}

	//セッションチェック
	private boolean session_Check(ServletContext scon,HttpSession session){
		//セッションが切れた場合、は処理続行不可
		if(session == null){
			return false;
		 }
		//ログオンを通過していない場合は処理続行不可
		if(	session.getAttribute("USER") == null){
			return false;
		 }

		//セッションオブジェクトのセッション情報を紛失したは処理続行不可
		Struct_Session ss = (Struct_Session) session.getAttribute("SESSION");
		if(ss == null){
			return false;
		}		
		//サーブレットコンテキストのセッションナンバーを紛失した場合は処理続行不可
		if(scon.getAttribute(ss.getSessionnumber())	== null){
			return false;
		}		
		return true;
	}
	
	private void updatemode(HttpServletRequest request,ServletContext scon,HttpSession session){
		String updateprm = (String) scon.getAttribute("UPDATEMODE");
		if(updateprm == null || 
			updateprm.equals(session.getId()) == false){
			return;
		}
		request.setAttribute("UPDATEMODE","yes");
	}
	
		
}
