package beansApp;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.*;
import java.util.ArrayList;

import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class Gener_WindowList_IO  {

	private String 		FilePath;

	JTree	 			tree;
	
	//展開状態
	ArrayList  expandnodes;
	
	//jtreeのセーブ	
	public boolean save(){
		
		if(FilePath == null || FilePath.length() == 0){
			return false;
		}
		
		FileOutputStream os = null;
		BufferedOutputStream bos = null;
		XMLEncoder xml = null;

		try {
			os  = new FileOutputStream(FilePath);
			bos = new BufferedOutputStream(os);
			xml = new XMLEncoder(bos);

	   		DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
	   		xml.writeObject(model);

	   		//**************************************	
	   		//* 展開状態のセーブ
	   		//**************************************
	   		DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
	   		DefaultMutableTreeNode node = root;
	   		int row_total = 0;
	   		while(true){
	   			row_total++;
	   			node = node.getNextNode();
	   			if(node == null)break;
	   		}
	   		expandnodes = new ArrayList();
	   		for(int i=0 ; i<row_total ; i++){
		   		if(tree.isExpanded(i) == true){
		   			expandnodes.add(i);
		   		}
	   		}
	   		xml.writeObject(expandnodes);
	   		
	   		//**************************************	
	   		//* 選択状態のセーブ
	   		//**************************************
	   		int[] selectionrows = tree.getSelectionRows();

	   		if(selectionrows != null || selectionrows.length > 0){
		   		xml.writeObject(String.valueOf(selectionrows[0]));
	   		}
	   		else{
		   		xml.writeObject("0");
	   		}
	   		
	   		
		} catch (FileNotFoundException e) {
			e.printStackTrace();
			return false;
		}finally{
			try{
				xml.close();
			} catch(Exception e2){
				e2.printStackTrace();
				return false;
			}
		}
		return true;
	}
	
	//jtreeのセーブ	
	public boolean projectsave(){
		
		if(FilePath == null || FilePath.length() == 0){
			return false;
		}
		
		FileOutputStream os = null;
		BufferedOutputStream bos = null;
		XMLEncoder xml = null;

		try {
			os  = new FileOutputStream(FilePath);
			bos = new BufferedOutputStream(os);
			xml = new XMLEncoder(bos);

	   		DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
	   		xml.writeObject(model);

	   		
		} catch (FileNotFoundException e) {
			e.printStackTrace();
			return false;
		}finally{
			try{
				xml.close();
			} catch(Exception e2){
				e2.printStackTrace();
				return false;
			}
		}
		return true;
	}
	
	public String getFilePath() {
		return FilePath;
	}

	public void setFilePath(String filePath) {
		FilePath = filePath;
	}
	
	public void putJTree(JTree tree){
		this.tree = tree;
	}

	
}
