package logon_check;

import java.io.IOException;
import java.util.ArrayList;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import structure.Struct_Community_Menber;
import structure.Struct_Menber;
import structure.Struct_Session;
import beansApp.AdminCommunityMenber_IO;
import beansApp.AdminMenber_IO;
import beansApp.AdminUserPassword_IO;

public class Logon_Check extends HttpServlet{

	public void doPost(HttpServletRequest request, HttpServletResponse response)
	throws IOException, ServletException{
		
		//****************************
		//* ユーザーＩＤ　ナル値チェック
		//****************************
		String uid = (String) request.getParameter("uid");
		if(uid == null || uid.length() == 0){
			HttpSession session = request.getSession(false);
			request.setAttribute("MSG", "ユーザーＩＤが未入力です");
			getServletContext().getRequestDispatcher("/servlet/logonfailed").forward(request, response);			
			return;
		}
		//****************************
		//* パスワード　ナル値チェック
		//****************************
		String psw = (String) request.getParameter("psw");
		if(psw == null || psw.length() == 0){
			HttpSession session = request.getSession(false);
			request.setAttribute("MSG", "パスワードが未入力です");
			getServletContext().getRequestDispatcher("/servlet/logonfailed").forward(request, response);			
			return;
		}
		//****************************
		//* ユーザーＩＤ　文字数チェック
		//****************************
		if(uid.length() > 128){
			HttpSession session = request.getSession(false);
			request.setAttribute("MSG", "ユーザーＩＤは128文字以下です");
			getServletContext().getRequestDispatcher("/servlet/logonfailed").forward(request, response);			
			return;
		}
		//****************************
		//* パスワード　文字数チェック
		//****************************
		if(psw.length() > 128){
			HttpSession session = request.getSession(false);
			request.setAttribute("MSG", "パスワードは128文字以下です");
			getServletContext().getRequestDispatcher("/servlet/logonfailed").forward(request, response);			
			return;
		}

		String role = (String) request.getParameter("role");

		
		//****************************
		//* 管理者の選択
		//****************************
		if(role.equals("admin")){
			
			//****************************
			//* 管理者フィアルのロード準備
			//****************************
			ServletContext scon = getServletConfig().getServletContext();
			String filePath = scon.getInitParameter("masterDir") +
								scon.getInitParameter("adminFile");
//			ServletConfig config =getServletConfig();
//			String filePath=config.getInitParameter("adminFile");

			AdminUserPassword_IO au = new AdminUserPassword_IO();
			au.setFilePath(filePath);

			//*********************************
			//* ユーザー＆パスワードのチェック
			//*********************************
			au.setUserid(uid);
			au.setPassword(psw);
			if(au.authenticate() == false){
				HttpSession session = request.getSession(false);
				request.setAttribute("MSG", "ユーザーＩＤまたはパスワードが違います");
				getServletContext().getRequestDispatcher("/servlet/logonfailed").forward(request, response);			
				return;
			}
			
			//*******************************************
			//* セッション開始
			//*******************************************
			HttpSession session = request.getSession(true);
			//リスナーイベントが採番したセッション番号をチェック
			Struct_Session session_info = (Struct_Session) session.getAttribute("SESSION");
			if(session_info == null){
				request.setAttribute("TITLE",	"ログオンチェック");
				request.setAttribute("MSG", "センションＩＤの取得に失敗しました");
				getServletContext().getRequestDispatcher("/servlet/framecommonmessage").forward(request, response);			
			}
			//サーブレットコンテキストにユーザーＩＤを登録
			session_info.setUserid(au.getUserid());
			session_info.setAdmin(true);
			scon.setAttribute(session_info.getSessionnumber(), session_info);
			session.setAttribute("USER", au.getUserid());
			response.sendRedirect("../adminmain.html");
			return;
		}			
		//****************************
		//* 一般ユーザーの選択
		//****************************
		else if(role.equals("general")){
			ArrayList<Struct_Community_Menber> commenData;
			//***********************************************
			//* コミュニティメンバーファイルのアクセス準備
			//***********************************************
			ServletContext scon = getServletConfig().getServletContext();
			String filePath = scon.getInitParameter("masterDir") +
						scon.getInitParameter("communityMenberFile");
			AdminCommunityMenber_IO acm = new AdminCommunityMenber_IO();
			acm.setFilePath(filePath);
			byte loadrtn = acm.load();

			if(loadrtn == (byte)1){
				//* ロード成功
				commenData	= acm.getdata();
				
			}else if(loadrtn == (byte)2){		
				//* ファイルなし
				HttpSession session = request.getSession(false);
				request.setAttribute("MSG", "認証できません");
				getServletContext().getRequestDispatcher("/servlet/logonfailed").forward(request, response);			
				return;
				
			}else{
				//* ロード失敗
				HttpSession session = request.getSession(false);
				request.setAttribute("MSG", "認証できません");
				getServletContext().getRequestDispatcher("/servlet/logonfailed").forward(request, response);			
				return;
			}		
			
			//****************************************************************
			//* ユーザーがコミュニティメンバーに登録されているか　チェック
			//****************************************************************
			boolean found = false;
			for(int i=0 ; i<commenData.size() ;i++){
				if(commenData.get(i).getUserid().equals(uid) == true){
					found = true;
					break;
				}
			}
			
			if(found == false){
				request.setAttribute("MSG", "ユーザーＩＤまたはパスワードが違います");
				getServletContext().getRequestDispatcher("/servlet/logonfailed").forward(request, response);			
				return;
			}

			//*********************************
			//* ユーザー＆パスワードのチェック
			//*********************************
			filePath = scon.getInitParameter("masterDir") +
								scon.getInitParameter("menberFile");
			AdminMenber_IO am = new AdminMenber_IO();
			am.setFilePath(filePath);
			loadrtn = am.load();
			ArrayList<Struct_Menber> menberData = null;
			
			if(loadrtn == (byte)1){
				//* ロード成功
				menberData	= am.getdata();

			}else if(loadrtn == (byte)2){
				//* ファイルなし
				HttpSession session = request.getSession(false);
				request.setAttribute("MSG", "認証できません");
				getServletContext().getRequestDispatcher("/servlet/logonfailed").forward(request, response);			
				return;
			}else{
				//* ロード失敗
				HttpSession session = request.getSession(false);
				request.setAttribute("MSG", "認証できません");
				getServletContext().getRequestDispatcher("/servlet/logonfailed").forward(request, response);			
				return;
			}		
			
			
			//****************************************************************
			//* パスワード　		チェック
			//* アドミンオプション　チェック
			//****************************************************************
			found = false;
			boolean adminoption = false;
			for(int i=0 ; i<menberData.size() ;i++){
				if(menberData.get(i).getUserid().equals(uid) == true){
					String password = menberData.get(i).getPassword();
					if(password == null || password .length() == 0){
						if(psw.equals(uid+"pw") == true){
							found = true;
						}
					}
					else if(psw.equals(password) == true){
						found = true;
					}
					adminoption = menberData.get(i).isAdminoption();
					break;
				}
			}
			
			if(found == false){
				request.setAttribute("MSG", "ユーザーＩＤまたはパスワードが違います");
				getServletContext().getRequestDispatcher("/servlet/logonfailed").forward(request, response);			
				return;
			}
			
			//*******************************************
			//* セッション開始
			//*******************************************
			HttpSession session = request.getSession(true);
			//リスナーイベントが採番したセッション番号をチェック
			Struct_Session session_info = (Struct_Session) session.getAttribute("SESSION");
			if(session_info == null){
				request.setAttribute("TITLE",	"ログオンチェック");
				request.setAttribute("MSG", "センションＩＤの取得に失敗しました");
				getServletContext().getRequestDispatcher("/servlet/framecommonmessage").forward(request, response);			
			}
			//サーブレットコンテキストにユーザーＩＤを登録
			session_info.setUserid(uid);
			scon.setAttribute(session_info.getSessionnumber(), session_info);
			session.setAttribute("USER", uid);
			if(adminoption == true){
				session.setAttribute("ADMINOPTION", "yes");
			}
			session_info.setAdmin(false);
			response.sendRedirect("../genermain.html");
			return;
		}
	}
	
}
		
