package listener;

import java.text.DecimalFormat;
import java.util.ArrayList;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

import structure.Struct_Session;

public class SessionCounter implements ServletContextListener,HttpSessionListener{

	ServletContext scon;

	private static int count = 0;
	private static int number = 0; 

	ArrayList<Struct_Session> arraysession = new ArrayList();
	
	public void SessionCount() { 
	} 
	//Webアプリケーションがリクエストを処理する準備ができたことを検知
	public void contextInitialized(ServletContextEvent se) {
	      scon = se.getServletContext();
	      
	      
	}
	//Servletコンテキストのシャットドウンの検知
	public void contextDestroyed(ServletContextEvent arg0) {
	} 

	//セッション作成を検知
	public void sessionCreated(HttpSessionEvent se) { 
		//* セッション本数
		count ++; 
	    scon.setAttribute("SESSIONCOUNT", String.valueOf(count));

	    if(number == 99999){
			number =1; 
		}else{
			number ++; 
		}

    	//セッションナンバーの取得
    	HttpSession session=se.getSession();
    	//セッションオブジェクトにセッション番号を付与
    	DecimalFormat df = new DecimalFormat("00000");
    	String sessionnumber = "SESSION"+df.format(number);

    	//セッションテーブルの保存
    	Struct_Session ss = new Struct_Session(); 
    	ss.setSessionid(session.getId());
    	ss.setSessionnumber(sessionnumber);
    	ss.setLogondate(System.currentTimeMillis());
    	arraysession.add(ss);

    	//新セッションにセンッションナンバーを提供する
	    session.setAttribute("SESSION",ss); 
    	
	} 
	//セッション破棄を検知
	public void sessionDestroyed(HttpSessionEvent se) 	{ 
		//* セッション本数
		count --; 
		scon.setAttribute("SESSIONCOUNT", String.valueOf(count));
		String sessionId=se.getSession().getId();
		
    	//セッションテーブルから開放
		for(int i=0;i<arraysession.size();i++){
			if(sessionId.equals(arraysession.get(i).getSessionid())){
				if(scon.getAttribute(arraysession.get(i).getSessionnumber()) != null){
					scon.removeAttribute(arraysession.get(i).getSessionnumber());
				}
				String updateprm = (String) scon.getAttribute("UPDATEMODE");
				if(updateprm == null){
					//作業なし
				}
				else if( updateprm.equals(arraysession.get(i).getSessionnumber()) 	||
						updateprm.equals(arraysession.get(i).getSessionid())	){
					//更新モードを開放
					scon.removeAttribute("UPDATEMODE");
				}
				arraysession.remove(i);
				break;
			}
		}
		
	} 

}
