package structure;

import java.io.Serializable;

public class Struct_System_Config implements Serializable{
	//********************************************
	//* mailcost コンフィグ
	//********************************************
	
	int timer_main ;			// 1.メインウィンドウのタイマー			単位：１ミリ秒
	int timer_server ;			// 2.受信サーバ　送受信切替タイマー		単位：１ミリ秒	
	int timer_out ;				// 3.受信タイムアウト					単位：１ミリ秒
	int cost_timer;				// 4.コスト計算間隔						単位：１ミリ秒
	boolean testmode;			// 5.true：テストモード　false:本番モード
	boolean standardmode;		// 6.true：標準出力、エラー出力をファイルに出力する
	int port;					// 7.接続元ポート
	int buffsize;				// 8.バッファサイズ
	boolean start_relay;		// 9.アプリケーション起動直後に中継送信を実行
	int timer_relay;			//10.中継送信タイマー	単位：分
	int max_relay_keeptime;		//11.最大中継保持時間	単位：時
	boolean end_server;		//12.アプリケーション終了直後にサーバ送信を実行
	
	byte logmode;				//13.ログ出力モード
	final byte logmode1 = 1;	//本番用	システムエラー
	final byte logmode2 = 2;	//本番用　　ユーザーエラー
	final byte logmode3 = 3;	//debug		主クラススタートエンドメッセージ
	final byte logmode4 = 4;	//debug		既存埋め込み
	final byte logmode5 = 5;	//debug		書き込み用


	public void init(){
		timer_main		=	5000;		// 1.（５秒）メインウィンドウのタイマー	
		timer_server	=	5000;		// 2.（５秒）受信サーバ　送受信切替タイマー	
		timer_out		=	10000;		// 3.（１分）受信タイムアウト
		cost_timer		=	15000;		// 4.（１５秒）コスト計算間隔
		testmode		=	false;		// 5.本番モード
		standardmode	=	true;		// 6.ファイル出力する
		port			=	65535;		// 7.65535ポート
		buffsize		=	1024;		// 8.１０２４バイトのバッファ
		start_relay		=	true;		// 9.アプリケーション起動直後に中継送信を実行
		timer_relay		=	15;			//10.中継送信タイマー	単位：分
		max_relay_keeptime	=	1;		//11.最大中継保持時間	単位：時
		end_server		=	true;		//12.アプリケーション終了直後にサーバ送信を実行
		logmode			=	logmode2;	//ユーザーエラー
	}

	public void serverinit(){
		timer_main		=	0;			// 1.（５秒）メインウィンドウのタイマー	
		timer_server	=	5000;		// 2.（５秒）受信サーバ　送受信切替タイマー	
		timer_out		=	10000;		// 3.（１分）受信タイムアウト
		cost_timer		=	0;			// 4.（１５秒）コスト計算間隔
		testmode		=	false;		// 5.本番モード
		standardmode	=	true;		// 6.ファイル出力する
		port			=	65535;		// 7.65535ポート
		buffsize		=	1024;		// 8.１０２４バイトのバッファ
		start_relay		=	false;		// 9.アプリケーション起動直後に中継送信を実行
		timer_relay		=	120;		//10.中継送信タイマー	単位：分
		max_relay_keeptime	=	0;		//11.最大中継保持時間	単位：時
		end_server		=	false;		//12.アプリケーション終了直後にサーバ送信を実行
		logmode			=	logmode2;	//ユーザーエラー
	}
	
	//ゲッター＆セッター
	public byte getLogmode() {
		return logmode;
	}
	public void setLogmode(byte logmode) {
		this.logmode = logmode;
	}
	public boolean isStandardmode() {
		return standardmode;
	}
	public void setStandardmode(boolean standardmode) {
		this.standardmode = standardmode;
	}
	public int getTimer_main() {
		return timer_main;
	}
	public int getTimer_out() {
		return timer_out;
	}
	public void setTimer_out(int timer_out) {
		this.timer_out = timer_out;
	}
	public void setTimer_main(int timer_main) {
		this.timer_main = timer_main;
	}
	public boolean isTestmode() {
		return testmode;
	}
	public void setTestmode(boolean testmode) {
		this.testmode = testmode;
	}
	public int getBuffsize() {
		return buffsize;
	}
	public void setBuffsize(int buffsize) {
		this.buffsize = buffsize;
	}
	public int getPort() {
		return port;
	}
	public void setPort(int port) {
		this.port = port;
	}
	public int getTimer_server() {
		return timer_server;
	}
	public void setTimer_server(int timer_server) {
		this.timer_server = timer_server;
	}
	public byte getLogmode1() {
		return logmode1;
	}
	public byte getLogmode2() {
		return logmode2;
	}
	public byte getLogmode3() {
		return logmode3;
	}
	public byte getLogmode4() {
		return logmode4;
	}
	public byte getLogmode5() {
		return logmode5;
	}
	public int getCost_timer() {
		return cost_timer;
	}
	public void setCost_timer(int cost_timer) {
		this.cost_timer = cost_timer;
	}
	public int getMax_relay_keeptime() {
		return max_relay_keeptime;
	}
	public void setMax_relay_keeptime(int max_relay_keeptime) {
		this.max_relay_keeptime = max_relay_keeptime;
	}
	public boolean isStart_relay() {
		return start_relay;
	}
	public void setStart_relay(boolean start_relay) {
		this.start_relay = start_relay;
	}
	public int getTimer_relay() {
		return timer_relay;
	}
	public void setTimer_relay(int timer_relay) {
		this.timer_relay = timer_relay;
	}
	public boolean isEnd_server() {
		return end_server;
	}
	public void setEnd_server(boolean end_server) {
		this.end_server = end_server;
	}
}
