package structure;

import java.io.Serializable;

public class Struct_User  implements Serializable{
	//********************************************
	//* mailcost user
	//********************************************

	
	String userid;						// 1.ユーザーＩＤ
	String user_fullname;				// 2.ユーザー名称
	String node;						// 3.ノード 
	int last_send_number;				// 4.最終送信番号
	Struct_UnitCost struct_unitcost ;	// 5.役割と（月）単価
	
	
	int business_year_days;				// 6.年間営業日数
	double working_time;				// 7.１日の労働時間	有効整数２桁少数２桁
	double unit_cost;					// 8.１秒あたりの単価	有効少数７桁

	double normal_maxtime;				// 9.正常最大時間　	有効整数２桁少数２桁
	double semi_warning_maxtime;		//10.準警告最大時間	有効整数２桁少数２桁
	double warning_maxtime;				//11.警告最大時間		有効整数２桁少数２桁
	double semi_abnormal_maxtime;		//12.準異常最大時間	有効整数２桁少数２桁
	double abnormal_maxtime;			//13.異常最大時間		有効整数２桁少数２桁

	//s：秒	m：分	h：時	d：日
	String normal_kind;					//14.正常最大時間の単位		　
	String semi_warning_kind;			//15.準警告最大時間の単位	　
	String warning_kind;				//16.警告最大時間の単位	　
	String semi_abnormal_kind;			//17.準異常最大時間の単位	
	String abnormal_kind;				//18.異常最大時間の単位	
	
	int normal_maxcost;					//19.正常最大コスト
	int semi_warning_maxcost;			//20.準警告最大コスト
	int warning_maxcost;				//21.警告最大コスト
	int semi_abnormal_maxcost;			//22.準異常最大コスト
	int abnormal_maxcost;				//23.異常最大コスト
	
	boolean std_chk;					//24.標準単価の表示
	
	
	String eval_rank;					//25.評価ランク

	int last_system_send_number;		//26.最終システム送信番号

	double write_maxtime;				//27.書き込み最大時間　	有効整数２桁少数２桁
	double read_maxtime;				//28.読み取り最大時間　	有効整数２桁少数２桁
	double real_maxtime;				//29.実最大時間　			有効整数２桁少数２桁
	double my_eval_maxtime;				//30.評価された最大時間	有効整数２桁少数２桁
	double other_eval_maxtime;			//31.評価した最大時間		有効整数２桁少数２桁
	double cont_maxtime;				//32.貢献最大時間　		有効整数２桁少数２桁
	double total_maxtime;				//33.総合最大時間　		有効整数２桁少数２桁
	
	int write_maxcost;					//34.書き込み最大コスト　	
	int read_maxcost;					//35.読み取り最大コスト　	
	int real_maxcost;					//36.実最大コスト　		
	int my_eval_maxcost;				//37.評価された最大コスト	
	int other_eval_maxcost;				//38.評価した最大コスト	
	int cont_maxcost;					//39.貢献最大コスト　		
	int total_maxcost;					//40.総合最大コスト　		

	boolean autobatch;					//41.自動実行
	long lastbatchtimestamp;			//42.前回実行タイムスタンプ

	boolean send_direct;				//43.直接送信
	boolean send_direct_option;		//44.直接送信オプション
	boolean send_direct_option_relay;	//45.直接送信オプション他ノード中継
	boolean send_direct_option_server;	//46.直接送信オプションサーバ中継
	
	String relay1_project;				//47.中継プロジェクト１
	String relay1_community;			//48.中継コミュニティ１
	String relay1_userid;				//49.中継ユーザーＩＤ１
	String relay1_node;					//50.中継ノード１
	
	String relay2_project;				//51.中継プロジェクト２
	String relay2_community;			//52.中継コミュニティ２
	String relay2_userid;				//53.中継ユーザーＩＤ２
	String relay2_node;					//54.中継ノード２

	String relay3_project;				//55.中継プロジェクト３
	String relay3_community;			//56.中継コミュニティ３
	String relay3_userid;				//57.中継ユーザーＩＤ３
	String relay3_node;					//58.中継ノード３

	String relay4_project;				//59.中継プロジェクト４
	String relay4_community;			//60.中継コミュニティ４
	String relay4_userid;				//61.中継ユーザーＩＤ４
	String relay4_node;					//62.中継ノード４

	String relay5_project;				//63.中継プロジェクト５
	String relay5_community;			//64.中継コミュニティ５
	String relay5_userid;				//65.中継ユーザーＩＤ５
	String relay5_node;					//66.中継ノード５
	
	
	public void init(){
		userid				=	"nodata"	;	//ユーザーＩＤ
		user_fullname		=	"ななしさん";	//ユーザー名称
		node				=	"0.0.0.0";		//ノード
		last_send_number	=	-1;				//最終送信番号
		struct_unitcost = new Struct_UnitCost();
		struct_unitcost.init();
		
		business_year_days		=	245;			//年間営業日数
		working_time			=	8.00;			//１日の労働時間少数２桁含む
		unit_cost				=	-1.0;			//１秒あたりの単価少数３桁含む
		normal_maxtime			=	-1.0;			//正常最大時間　　秒単位
		semi_warning_maxtime	=	-1.0;			//準警告最大時間　秒単位
		warning_maxtime			=	-1.0;			//警告最大時間　　秒単位
		semi_abnormal_maxtime	=	-1.0;			//準異常最大時間　秒単位
		abnormal_maxtime		=	-1.0;			//異常最大時間　　秒単位
		normal_maxcost			=	-1;				//正常最大コスト
		semi_warning_maxcost	=	-1;				//準警告最大コスト
		warning_maxcost			=	-1;				//警告最大コスト
		semi_abnormal_maxcost	=	-1;				//準異常最大コスト
		abnormal_maxcost		=	-1;				//異常最大コスト
		normal_kind				=	"s";
		semi_warning_kind		=	"s";
		warning_kind			=	"s";
		semi_abnormal_kind		=	"s";
		abnormal_kind			=	"s";
		std_chk					=	false;
		eval_rank				=	"2";
		last_system_send_number	=	-1;				//最終システム送信番号
		write_maxtime			=	-1.0;			//書き込み最大時間
		read_maxtime			=	-1.0;			//読み取り最大時間
		real_maxtime			=	-1.0;			//実最大時間
		my_eval_maxtime			=	-1.0;			//評価された最大時間
		other_eval_maxtime		=	-1.0;			//評価した最大時間
		cont_maxtime			=	-1.0;			//貢献最大時間
		total_maxtime			=	-1.0;			//総合最大時間
		write_maxcost			=	-1;				//書き込み最大コスト
		read_maxcost			=	-1;				//読み取り最大コスト
		real_maxcost			=	-1;				//実最大コスト
		my_eval_maxcost			=	-1;				//評価された最大コスト
		other_eval_maxcost		=	-1;				//評価した最大コスト
		cont_maxcost			=	-1;				//貢献最大コスト
		total_maxcost			=	-1;				//総合最大コスト
		autobatch				=	false;			//自動実行
		lastbatchtimestamp		=	-1;		
		send_direct				=	true;			//42.直接送信
		send_direct_option		=	false;			//43.直接送信オプション
		send_direct_option_relay =	false;			//44.直接送信オプション他ノード中継
		send_direct_option_server =	false;			//45.直接送信オプションサーバ中継
		
		relay1_project 			= new String();		//46.中継プロジェクト１
		relay1_community 		= new String();		//47.中継コミュニティ１
		relay1_userid 			= new String();		//48.中継ユーザーＩＤ１
		relay1_node 			= new String();		//49.中継ノード１
		
		relay2_project 			= new String();		//50.中継プロジェクト２
		relay2_community 		= new String();		//51.中継コミュニティ２
		relay2_userid 			= new String();		//52.中継ユーザーＩＤ２
		relay2_node 			= new String();		//53.中継ノード２

		relay3_project 			= new String();		//54.中継プロジェクト３
		relay3_community 		= new String();		//55.中継コミュニティ３
		relay3_userid 			= new String();		//56.中継ユーザーＩＤ３
		relay3_node 			= new String();		//57.中継ノード３
	
		relay4_project 			= new String();		//58.中継プロジェクト４
		relay4_community 		= new String();		//59.中継コミュニティ４
		relay4_userid 			= new String();		//60.中継ユーザーＩＤ４
		relay4_node 			= new String();		//61.中継ノード４

		relay5_project 			= new String();		//62.中継プロジェクト５
		relay5_community 		= new String();		//63.中継コミュニティ５
		relay5_userid 			= new String();		//64.中継ユーザーＩＤ５
		relay5_node 			= new String();		//65.中継ノード５

	}
	
	public byte getMode(int value){
		//正数
		if(value > semi_abnormal_maxcost){
			return 5;
		}
		else if(value > warning_maxcost){
			return 4;
		}
		else if(value > semi_warning_maxcost){
			return 3;
		}
		else if(value > normal_maxcost){
			return 2;
		}
		else if(value >= 0){
			return 1;
		}
		//負の数
		else if(value < -(semi_abnormal_maxcost)){
			return -5;
		}
		else if(value < -(warning_maxcost)){
			return -4;
		}
		else if(value < -(semi_warning_maxcost)){
			return -3;
		}
		else if(value < -(normal_maxcost)){
			return -2;
		}
		else {
			return -1;
		}
	}
	
	public int getMaxValue(int value){
		if(value > abnormal_maxcost){
			return value;
		}
		else if(value > semi_abnormal_maxcost){
			return abnormal_maxcost;
		}
		else if(value > warning_maxcost){
			return semi_abnormal_maxcost;
		}
		else if(value > semi_warning_maxcost){
			return warning_maxcost;
		}
		else if(value > normal_maxcost){
			return semi_warning_maxcost;
		}
		else if(value >= 0){
			return normal_maxcost;
		}
		//負の数
		else if(value < -(semi_abnormal_maxcost)){
			return -(abnormal_maxcost);
		}
		else if(value < -(warning_maxcost)){
			return -(semi_abnormal_maxcost);
		}
		else if(value < -(semi_warning_maxcost)){
			return -(warning_maxcost);
		}
		else if(value < -(normal_maxcost)){
			return -(semi_warning_maxcost);
		}
		else {
			return -(normal_maxcost);
		}
	
	}

	//最終送信番号　カウントアップ
	public void Last_send_number_CountUp() {
		last_send_number++;
	}
	//最終システム送信番号　カウントアップ
	public void Last_system_send_number_CountUp() {
		last_system_send_number++;
		//限界を超えたら１に戻る
		if(last_system_send_number > 99999){
			last_system_send_number = 1;
		}
	}
	
	
	//ゲッター＆セッター
	public int getLast_send_number() {
		return last_send_number;
	}
	public void setLast_send_number(int last_send_number) {
		this.last_send_number = last_send_number;
	}
	public String getNode() {
		return node;
	}
	public void setNode(String node) {
		this.node = node;
	}
	public String getUser_fullname() {
		return user_fullname;
	}
	public void setUser_fullname(String user_fullname) {
		this.user_fullname = user_fullname;
	}
	public String getUserid() {
		return userid;
	}
	public void setUserid(String userid) {
		this.userid = userid;
	}
	public Struct_UnitCost getStruct_unitccost() {
		return struct_unitcost;
	}
	public void setStruct_unitccost(Struct_UnitCost struct_unitccost) {
		this.struct_unitcost = struct_unitccost;
	}
	public int getAbnormal_maxcost() {
		return abnormal_maxcost;
	}
	public void setAbnormal_maxcost(int abnormal_maxcost) {
		this.abnormal_maxcost = abnormal_maxcost;
	}
	public  double getAbnormal_maxtime() {
		return abnormal_maxtime;
	}
	public void setAbnormal_maxtime(double abnormal_maxtime) {
		this.abnormal_maxtime = abnormal_maxtime;
	}
	public int getBusiness_year_days() {
		return business_year_days;
	}
	public void setBusiness_year_days(int business_year_days) {
		this.business_year_days = business_year_days;
	}
	public  int getNormal_maxcost() {
		return normal_maxcost;
	}
	public void setNormal_maxcost(int normal_maxcost) {
		this.normal_maxcost = normal_maxcost;
	}
	public double getNormal_maxtime() {
		return normal_maxtime;
	}
	public void setNormal_maxtime(double normal_maxtime) {
		this.normal_maxtime = normal_maxtime;
	}
	public  double getUnit_cost() {
		return unit_cost;
	}
	public void setUnit_cost(double unit_cost) {
		this.unit_cost = unit_cost;
	}
	public int getWarning_maxcost() {
		return warning_maxcost;
	}
	public void setWarning_maxcost(int warning_maxcost) {
		this.warning_maxcost = warning_maxcost;
	}
	public  double getWarning_maxtime() {
		return warning_maxtime;
	}
	public void setWarning_maxtime(double warning_maxtime) {
		this.warning_maxtime = warning_maxtime;
	}
	public  double getWorking_time() {
		return working_time;
	}
	public void setWorking_time(double working_time) {
		this.working_time = working_time;
	}
	public boolean isStd_chk() {
		return std_chk;
	}
	public void setStd_chk(boolean std_chk) {
		this.std_chk = std_chk;
	}
	public String getAbnormal_kind() {
		return abnormal_kind;
	}
	public void setAbnormal_kind(String abnormal_kind) {
		this.abnormal_kind = abnormal_kind;
	}
	public String getNormal_kind() {
		return normal_kind;
	}
	public void setNormal_kind(String normal_kind) {
		this.normal_kind = normal_kind;
	}
	public String getWarning_kind() {
		return warning_kind;
	}
	public void setWarning_kind(String warning_kind) {
		this.warning_kind = warning_kind;
	}

	public String getSemi_abnormal_kind() {
		return semi_abnormal_kind;
	}

	public void setSemi_abnormal_kind(String semi_abnormal_kind) {
		this.semi_abnormal_kind = semi_abnormal_kind;
	}

	public int getSemi_abnormal_maxcost() {
		return semi_abnormal_maxcost;
	}

	public void setSemi_abnormal_maxcost(int semi_abnormal_maxcost) {
		this.semi_abnormal_maxcost = semi_abnormal_maxcost;
	}

	public double getSemi_abnormal_maxtime() {
		return semi_abnormal_maxtime;
	}

	public void setSemi_abnormal_maxtime(double semi_abnormal_maxtime) {
		this.semi_abnormal_maxtime = semi_abnormal_maxtime;
	}

	public String getSemi_warning_kind() {
		return semi_warning_kind;
	}

	public void setSemi_warning_kind(String semi_warning_kind) {
		this.semi_warning_kind = semi_warning_kind;
	}

	public int getSemi_warning_maxcost() {
		return semi_warning_maxcost;
	}

	public void setSemi_warning_maxcost(int semi_warning_maxcost) {
		this.semi_warning_maxcost = semi_warning_maxcost;
	}

	public double getSemi_warning_maxtime() {
		return semi_warning_maxtime;
	}

	public void setSemi_warning_maxtime(double semi_warning_maxtime) {
		this.semi_warning_maxtime = semi_warning_maxtime;
	}

	public String getEval_rank() {
		return eval_rank;
	}

	public void setEval_rank(String eval_rank) {
		this.eval_rank = eval_rank;
	}

	public int getLast_system_send_number() {
		return last_system_send_number;
	}

	public void setLast_system_send_number(int last_system_send_number) {
		this.last_system_send_number = last_system_send_number;
	}

	public int getCont_maxcost() {
		return cont_maxcost;
	}

	public void setCont_maxcost(int cont_maxcost) {
		this.cont_maxcost = cont_maxcost;
	}

	public double getCont_maxtime() {
		return cont_maxtime;
	}

	public void setCont_maxtime(double cont_maxtime) {
		this.cont_maxtime = cont_maxtime;
	}

	public int getMy_eval_maxcost() {
		return my_eval_maxcost;
	}

	public void setMy_eval_maxcost(int my_eval_maxcost) {
		this.my_eval_maxcost = my_eval_maxcost;
	}

	public double getMy_eval_maxtime() {
		return my_eval_maxtime;
	}

	public void setMy_eval_maxtime(double my_eval_maxtime) {
		this.my_eval_maxtime = my_eval_maxtime;
	}

	public int getOther_eval_maxcost() {
		return other_eval_maxcost;
	}

	public void setOther_eval_maxcost(int other_eval_maxcost) {
		this.other_eval_maxcost = other_eval_maxcost;
	}

	public double getOther_eval_maxtime() {
		return other_eval_maxtime;
	}

	public void setOther_eval_maxtime(double other_eval_maxtime) {
		this.other_eval_maxtime = other_eval_maxtime;
	}

	public int getRead_maxcost() {
		return read_maxcost;
	}

	public void setRead_maxcost(int read_maxcost) {
		this.read_maxcost = read_maxcost;
	}

	public double getRead_maxtime() {
		return read_maxtime;
	}

	public void setRead_maxtime(double read_maxtime) {
		this.read_maxtime = read_maxtime;
	}

	public int getReal_maxcost() {
		return real_maxcost;
	}

	public void setReal_maxcost(int real_maxcost) {
		this.real_maxcost = real_maxcost;
	}

	public double getReal_maxtime() {
		return real_maxtime;
	}

	public void setReal_maxtime(double real_maxtime) {
		this.real_maxtime = real_maxtime;
	}

	public int getTotal_maxcost() {
		return total_maxcost;
	}

	public void setTotal_maxcost(int total_maxcost) {
		this.total_maxcost = total_maxcost;
	}

	public double getTotal_maxtime() {
		return total_maxtime;
	}

	public void setTotal_maxtime(double total_maxtime) {
		this.total_maxtime = total_maxtime;
	}

	public int getWrite_maxcost() {
		return write_maxcost;
	}

	public void setWrite_maxcost(int write_maxcost) {
		this.write_maxcost = write_maxcost;
	}

	public double getWrite_maxtime() {
		return write_maxtime;
	}

	public void setWrite_maxtime(double write_maxtime) {
		this.write_maxtime = write_maxtime;
	}

	public boolean isAutobatch() {
		return autobatch;
	}

	public void setAutobatch(boolean autobatch) {
		this.autobatch = autobatch;
	}

	public String getRelay1_community() {
		return relay1_community;
	}

	public void setRelay1_community(String relay1_community) {
		this.relay1_community = relay1_community;
	}

	public String getRelay1_node() {
		return relay1_node;
	}

	public void setRelay1_node(String relay1_node) {
		this.relay1_node = relay1_node;
	}

	public String getRelay1_project() {
		return relay1_project;
	}

	public void setRelay1_project(String relay1_project) {
		this.relay1_project = relay1_project;
	}

	public String getRelay1_userid() {
		return relay1_userid;
	}

	public void setRelay1_userid(String relay1_userid) {
		this.relay1_userid = relay1_userid;
	}

	public String getRelay2_community() {
		return relay2_community;
	}

	public void setRelay2_community(String relay2_community) {
		this.relay2_community = relay2_community;
	}

	public String getRelay2_node() {
		return relay2_node;
	}

	public void setRelay2_node(String relay2_node) {
		this.relay2_node = relay2_node;
	}

	public String getRelay2_project() {
		return relay2_project;
	}

	public void setRelay2_project(String relay2_project) {
		this.relay2_project = relay2_project;
	}

	public String getRelay2_userid() {
		return relay2_userid;
	}

	public void setRelay2_userid(String relay2_userid) {
		this.relay2_userid = relay2_userid;
	}

	public String getRelay3_community() {
		return relay3_community;
	}

	public void setRelay3_community(String relay3_community) {
		this.relay3_community = relay3_community;
	}

	public String getRelay3_node() {
		return relay3_node;
	}

	public void setRelay3_node(String relay3_node) {
		this.relay3_node = relay3_node;
	}

	public String getRelay3_project() {
		return relay3_project;
	}

	public void setRelay3_project(String relay3_project) {
		this.relay3_project = relay3_project;
	}

	public String getRelay3_userid() {
		return relay3_userid;
	}

	public void setRelay3_userid(String relay3_userid) {
		this.relay3_userid = relay3_userid;
	}

	public boolean isSend_direct() {
		return send_direct;
	}

	public void setSend_direct(boolean send_direct) {
		this.send_direct = send_direct;
	}

	public boolean isSend_direct_option_relay() {
		return send_direct_option_relay;
	}

	public void setSend_direct_option_relay(boolean send_direct_option_relay) {
		this.send_direct_option_relay = send_direct_option_relay;
	}

	public boolean isSend_direct_option_server() {
		return send_direct_option_server;
	}

	public void setSend_direct_option_server(boolean send_direct_option_server) {
		this.send_direct_option_server = send_direct_option_server;
	}

	public boolean isSend_direct_option() {
		return send_direct_option;
	}

	public void setSend_direct_option(boolean send_direct_option) {
		this.send_direct_option = send_direct_option;
	}

	public String getRelay4_community() {
		return relay4_community;
	}

	public void setRelay4_community(String relay4_community) {
		this.relay4_community = relay4_community;
	}

	public String getRelay4_node() {
		return relay4_node;
	}

	public void setRelay4_node(String relay4_node) {
		this.relay4_node = relay4_node;
	}

	public String getRelay4_project() {
		return relay4_project;
	}

	public void setRelay4_project(String relay4_project) {
		this.relay4_project = relay4_project;
	}

	public String getRelay4_userid() {
		return relay4_userid;
	}

	public void setRelay4_userid(String relay4_userid) {
		this.relay4_userid = relay4_userid;
	}

	public String getRelay5_community() {
		return relay5_community;
	}

	public void setRelay5_community(String relay5_community) {
		this.relay5_community = relay5_community;
	}

	public String getRelay5_node() {
		return relay5_node;
	}

	public void setRelay5_node(String relay5_node) {
		this.relay5_node = relay5_node;
	}

	public String getRelay5_project() {
		return relay5_project;
	}

	public void setRelay5_project(String relay5_project) {
		this.relay5_project = relay5_project;
	}

	public String getRelay5_userid() {
		return relay5_userid;
	}

	public void setRelay5_userid(String relay5_userid) {
		this.relay5_userid = relay5_userid;
	}

	public long getLastbatchtimestamp() {
		return lastbatchtimestamp;
	}

	public void setLastbatchtimestamp(long lastbatchtimestamp) {
		this.lastbatchtimestamp = lastbatchtimestamp;
	}



}
