package tool;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import org.apache.tools.zip.ZipEntry; 
import org.apache.tools.zip.ZipOutputStream;



public class Tool_Zip {

	private static int deleteLength;

	public  void submit(String outZipPath,String inDirPath) throws IOException {
		
		//入力ディレクトリの配下を取得
		File[] files=new File(inDirPath).listFiles();
		String[] targetFiles = new String[files.length];
		for(int i=0;i<targetFiles.length;i++){
			targetFiles[i] = files[i].getAbsolutePath();
		}
		
		//出力先のクリア
		File out = new File(outZipPath);
		if(out.exists()){
			out.delete();
		}
		
		createZip(outZipPath, targetFiles);
	}

	  public static void createZip(String zipFile, String[] targetFiles)
	    throws IOException {

	    ZipOutputStream out =
	      new ZipOutputStream(new FileOutputStream(zipFile));
	    out.setEncoding("MS932");                              
	    for (int i = 0; i < targetFiles.length; i++) {
	      File file = new File(targetFiles[i]);
	      deleteLength = file.getPath().length() - file.getName().length();
	      createZip(out, file);
	    }
	    out.close();
	  }

	  private static void createZip(ZipOutputStream out, File targetFile)
	    throws IOException {

	    if (targetFile.isDirectory()) {
	    	
	        File[] files = targetFile.listFiles();
	        for (int i = 0; i < files.length; i++) {
		        createZip(out, files[i]); 
	        }
	        //ディレクトリ登録
	        ZipEntry entry = new ZipEntry(getEntryPath(targetFile)+"/");
	        entry.setSize(0);
	        out.putNextEntry(entry);
	        out.closeEntry();
	      
	    } else {
	    	ZipEntry target = new ZipEntry(getEntryPath(targetFile));
	    	out.putNextEntry(target);
	    	byte buf[] = new byte[1024];
	    	int count;
	    	BufferedInputStream in =
	    		new BufferedInputStream(new FileInputStream(targetFile));
	    	while ((count = in.read(buf, 0, 1024)) != -1) {
	    		out.write(buf, 0, count);
	    	}
	    	in.close();
	    	out.closeEntry();
	    }
	  }

	  private static String getEntryPath(File file) {
	    return file.getPath().replaceAll("\\\\", "/").substring(deleteLength);
	  }


}
