package tool;


import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;

import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipEntry;

import structure.File_Separator;


public class Tool_unZIP {

	public void submit(String inZipPath,String outDirPath,String tmpFilepath,boolean delete) throws IOException {
		
		//*出力ディレクトリにZipファイル名を追加する
		File infile 		= new File(inZipPath);
		String newoutDir 	= new RemoveFileExtension().removeFileExtension(infile.getName());
		String newoutPath 	= outDirPath + new File_Separator().getFs() + newoutDir;

		//*出力ディレクトリのクリア
		new Tool_DirDel(newoutPath).delete();

		//作業用ワークファイルのクリア
		new Tool_DirDel(tmpFilepath).delete();
		
		unZip(inZipPath, newoutPath,tmpFilepath);

		if(delete == true){
			//ZIPファイルのクリア
			File zipfile = new File(inZipPath);
			zipfile.delete();
		}
	}

	  public static void unZip(InputStream in, String outDir,String tmpFilepath)
	  	throws IOException {
		  FileOutputStream out = new FileOutputStream(tmpFilepath);
		  byte[] buf = new byte[1024];
		  int size = 0;
		  while ((size = in.read(buf)) != -1) {
			  out.write(buf, 0, size);
		  }
		  out.close();
		  unZip(tmpFilepath, outDir,tmpFilepath);
		  new File(tmpFilepath).delete();
	  }

	  public static void unZip(String filename, String outDir,String tmpFilepath)
	  	throws IOException {
		  ZipFile zipFile = new ZipFile(filename, "MS932");
		  Enumeration enumx = zipFile.getEntries();
		  while (enumx.hasMoreElements()) {
			  ZipEntry entry = (ZipEntry) enumx.nextElement();
		      if (entry.isDirectory()) {
		    	  String filepath = outDir + "/"+ entry.getName().substring(0,entry.getName().length()-1);
		    	  new File(filepath).mkdirs();
		      } else {
		    	  File parent =
		          new File(outDir + "/" + entry.getName()).getParentFile();
		    	  parent.mkdirs();
		    	  FileOutputStream out =
		          new FileOutputStream(outDir + "/" + entry.getName());
		    	  InputStream in = zipFile.getInputStream(entry);
		    	  byte[] buf = new byte[1024];
		    	  int size = 0;
		    	  while ((size = in.read(buf)) != -1) {
		    		  out.write(buf, 0, size);
		    	  }
		    	  out.close();
		    	  in.close();
		      }
		  }
		  zipFile.close();
	  }

}
