// -*- C++ -*- generated by wxGlade 0.3.5.1 on Wed Jun 29 12:57:38 2005

#include "mnID.h"
#include "mnDef.h"
#include "mnFrame.h"
#include "mnDialog.h"


mnFrame::mnFrame(wxWindow* parent, int id, const wxString& title, const wxPoint& pos, const wxSize& size, long style):
    wxFrame(parent, id, title, pos, size, wxDEFAULT_FRAME_STYLE)
{
    // begin wxGlade: mnFrame::mnFrame
    splitWindow = new wxSplitterWindow(this, -1, wxDefaultPosition, wxDefaultSize, wxSP_3D|wxSP_BORDER);
    rightPanel = new wxPanel(splitWindow, -1);
    leftPanel = new wxPanel(splitWindow, -1);
    panel = new wxPanel(this, -1);
    searchLaebl = new wxStaticText(panel, -1, wxT("Search"), wxDefaultPosition, wxDefaultSize, wxALIGN_CENTRE);
    searchTextCtrl = new wxTextCtrl(this, ID_SearchTextCtrl, wxT(""), wxDefaultPosition, wxDefaultSize, wxTE_PROCESS_ENTER);
    searchTree = new wxTreeCtrl(leftPanel, ID_SearchTree, wxDefaultPosition, wxDefaultSize, wxTR_HAS_BUTTONS|wxTR_LINES_AT_ROOT|wxTR_DEFAULT_STYLE|wxSUNKEN_BORDER|wxTR_EDIT_LABELS);
    wikiPlainTextCtrl = new wxTextCtrl(rightPanel, ID_PlainTextCtrl, wxT(""), wxDefaultPosition, wxDefaultSize, wxTE_MULTILINE|wxHSCROLL|wxTE_AUTO_URL);
	wikiHtmlTextCtrl = new wxHtmlWindow(rightPanel, ID_HtmlTextCtrl, wxDefaultPosition, wxDefaultSize, wxHW_DEFAULT_STYLE, wxT(""));

    // begin add by hand
    menuBar = new wxMenuBar();
    SetMenuBar(menuBar);

	// File menu
    wxMenu* tmp_menu_1 = new wxMenu();
    tmp_menu_1->Append(ID_MenuFileNew, _("New\tCtrl+N"), wxT(""), wxITEM_NORMAL);
    tmp_menu_1->Append(ID_MenuFileEdit, _("Edit\tCtrl+E"), wxT(""), wxITEM_NORMAL);
    tmp_menu_1->Append(ID_MenuFileSave, _("Save\tCtrl+S"), wxT(""), wxITEM_NORMAL);
    tmp_menu_1->Append(ID_MenuFileRemove, _("Remove\tCtrl+R"), wxT(""), wxITEM_NORMAL);
	tmp_menu_1->AppendSeparator();
    tmp_menu_1->Append(ID_MenuFileConfig, _("Configure..."), wxT(""), wxITEM_NORMAL);
	tmp_menu_1->AppendSeparator();
    tmp_menu_1->Append(ID_MenuFileExit, _("Quit\tCtrl+Q"), wxT(""), wxITEM_NORMAL);
	menuBar->Append(tmp_menu_1, _("&File"));

	// Help menu
    wxMenu* tmp_menu_2 = new wxMenu();
    tmp_menu_2->Append(wxID_ABOUT, _("&About"), wxT(""), wxITEM_NORMAL);
	menuBar->Append(tmp_menu_2, _("&Help"));

#ifdef __WXMSW__
    wxIcon icon(wxT(APP_ICON_NAME), wxBITMAP_TYPE_ICO_RESOURCE);
    SetIcon(icon);
#endif
    // end add by hand
    
    set_properties();
    do_layout();
    // end wxGlade

	/* create search tree */
	searchItemRoot = searchTree->AddRoot(wxT(LABEL_ITEM_TREE), -1, -1, NULL);
	newItemRoot = searchTree->AppendItem(searchItemRoot, wxT(LABEL_NEW_ITEM), -1, -1, NULL);
}

void mnFrame::showPlainTextCtrl()
{
	mnWikiDataEntryDialog* dlg = new mnWikiDataEntryDialog(this, -1, wxT("Malon Note"));
	dlg->ShowModal();
}

void mnFrame::hidePlainTextCtrl()
{
}


void mnFrame::set_properties()
{
    // begin wxGlade: mnFrame::set_properties
    SetTitle(wxT("Malon Note"));
    SetSize(wxSize(900, 572));
    searchTextCtrl->SetFocus();
    // end wxGlade
}


void mnFrame::do_layout()
{
    wxBoxSizer* mainSizer = new wxBoxSizer(wxVERTICAL);
    rightPanelSizer = new wxGridSizer(1, 1, 0, 0);
    wxBoxSizer* leftPanelSizer = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* topSizer = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* labelSizer = new wxBoxSizer(wxHORIZONTAL);
    labelSizer->Add(searchLaebl, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
    panel->SetAutoLayout(true);
    panel->SetSizer(labelSizer);
    labelSizer->Fit(panel);
    labelSizer->SetSizeHints(panel);
    topSizer->Add(panel, 0, wxEXPAND, 0);
    topSizer->Add(searchTextCtrl, 1, wxTOP|wxBOTTOM|wxEXPAND|wxFIXED_MINSIZE, 1);
    mainSizer->Add(topSizer, 0, wxEXPAND, 0);
    leftPanelSizer->Add(searchTree, 1, wxEXPAND, 0);
    leftPanel->SetAutoLayout(true);
    leftPanel->SetSizer(leftPanelSizer);
    leftPanelSizer->Fit(leftPanel);
    leftPanelSizer->SetSizeHints(leftPanel);
    rightPanelSizer->Add(wikiHtmlTextCtrl, 0, wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 0);
    rightPanel->SetAutoLayout(true);
    rightPanel->SetSizer(rightPanelSizer);
    rightPanelSizer->Fit(rightPanel);
    rightPanelSizer->SetSizeHints(rightPanel);
    splitWindow->SplitVertically(leftPanel, rightPanel, 250);
    mainSizer->Add(splitWindow, 1, wxEXPAND, 0);
    SetAutoLayout(true);
    SetSizer(mainSizer);
    Layout();

	searchTree->Expand(searchItemRoot);
	searchTree->Expand(newItemRoot);
}

void mnFrame::showSearchResult(mnModel* wiki)
{
	const wxArrayString*  searchStrList;
	WikiList* wikiList;
	WikiList::Node* node;
	int i;

	searchTree->DeleteChildren(searchItemRoot);
	newItemRoot = searchTree->AppendItem(searchItemRoot, wxT(LABEL_NEW_ITEM), -1, -1, NULL);

	searchStrList = wiki->getSearchStrList();
	for(i = 0; i < searchStrList->Count(); i++) {
		wxString& searchStr = searchStrList->Item(i);
	
		wikiList = wiki->search(searchStr.mb_str());
		addSearchResult(&searchStr, wikiList);
	}

	searchTree->ScrollTo(searchItemRoot);
}

void mnFrame::addSearchResult(wxString* searchStr, WikiList* wikiList)
{
	wxTreeItemId    searchItem;
	WikiList::Node* node;
	WikiData*       data;
	const wxString* subject;

	searchItem = searchTree->AppendItem(searchItemRoot, *searchStr, -1, -1, NULL);
	node = wikiList->GetFirst();
	while(node) {
		data = node->GetData();
		subject = data->getSubject();
		searchTree->AppendItem(searchItem, *subject, -1, -1, (wxTreeItemData*)data);
		node = node->GetNext();
	}
	searchTree->Expand(searchItemRoot);
	searchTree->Expand(searchItem);
}

void mnFrame::showSelectedItemText(wxTreeEvent& event)
{
	wxTreeItemData* item    = searchTree->GetItemData(event.GetItem());
	if(item == NULL) {
		wikiHtmlTextCtrl->SetPage(wxT(""));
		return;
	}

	const wxString* fileName = ((WikiData*)(item))->getFileName();
	const wxString* wikiText = ((WikiData*)(item))->getText();
	wxString wikiHtml = wxT("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=EUC-JP\"><pre>") + 
                        *wikiText + 
                        wxT("</pre>");

	wikiHtmlTextCtrl->SetPage(wikiHtml);
}

void mnFrame::showNewItem(WikiData* data) 
{
	wxTreeItemId itemId;

	itemId = searchTree->AppendItem(newItemRoot, *(data->getSubject()), -1, -1, (wxTreeItemData*)data);
	searchTree->Expand(searchItemRoot);
	searchTree->Expand(newItemRoot);
	searchTree->SelectItem(itemId);
}

wxTreeItemData* mnFrame::getSelectedItem()
{
	return searchTree->GetItemData(searchTree->GetSelection());
}

wxString mnFrame::getSelectedLabel()
{
	return searchTree->GetItemText(searchTree->GetSelection());
}

bool mnFrame::isEditableTreeLabel(wxTreeItemId id)
{
	return !(searchTree->GetItemParent(id) == searchItemRoot || id == searchItemRoot);
}

bool mnFrame::isNewItem(wxTreeItemId id)
{
	return (searchTree->GetItemParent(id) == newItemRoot);
}

