// -*- C++ -*- generated by wxGlade 0.3.5.1 on Wed Jun 29 12:57:38 2005

#include <wx/wx.h>
#include <wx/image.h>
#include <wx/snglinst.h>
#include <wx/xrc/xmlres.h>
#include "mnDef.h"
#include "mnFrame.h"
#include "mnFrameController.h"

extern void InitXmlResource(); // defined in mnResource.cpp generated by wxrc

class mnApp: public wxApp {
public:
    bool OnInit();
	int OnExit();

private:
	mnFrame* mainFrame;
	wxSingleInstanceChecker* m_checker;
};

IMPLEMENT_APP(mnApp)

//static wxLocale locale(wxLANGUAGE_DEFAULT);

bool mnApp::OnInit()
{
	wxString* dirName = new wxString();
	wxString gotDirName;
	wxDirDialog* dlg;
	wxString confKey;
	
	const wxString appName = wxString::Format(wxT(MN_APP_NAME) wxT("-%s"), wxGetUserId().c_str());

    m_checker = new wxSingleInstanceChecker(appName);
    if ( m_checker->IsAnotherRunning() ){
        wxMessageBox(wxT("Another program instance is already running, aborting."));
		delete m_checker;
		exit(0);
    }

    wxInitAllImageHandlers();
	wxXmlResource::Get()->InitAllHandlers();
	InitXmlResource();

    mainFrame = new mnFrame(0);

	/* set controller object as event handler */
	mnFrameController* controller = new mnFrameController(mainFrame);
	mainFrame->PushEventHandler(controller);

    SetTopWindow(mainFrame);
    mainFrame->Show();
	
	/* add note panel */
	wxConfig* config = new wxConfig(wxT(CONF_APP_NAME));
	if(config->Read(wxT(CONF_WIKI_DIR), dirName) == FALSE) {
		delete dirName;
		dlg = new wxDirDialog(mainFrame);
		if(dlg->ShowModal() == wxID_OK) {
			gotDirName = dlg->GetPath();
			config->Write(wxT(CONF_WIKI_DIR), gotDirName.c_str());
			mainFrame->addNotePanel(&gotDirName);
		}
		else {
			mainFrame->Close();
		}
	}
	else {
		mainFrame->addNotePanel(dirName);

		for(int i = 1; ;i++) {
 			confKey.sprintf(wxT(CONF_WIKI_DIR) "%d", i);
			if(config->Read(confKey.c_str(), dirName) == FALSE) break;
			mainFrame->addNotePanel(dirName);
		}
		mainFrame->getNotebook()->SetSelection(0);
	}

	delete config;

	mainFrame->setFocusToSearchTextCtrl();
    return true;
}

int mnApp::OnExit() 
{
	delete m_checker;
}
