package jp.dip.commonsense.android.mametalk;

import jp.dip.commonsense.android.provider.Mametalk;
import android.app.Dialog;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Base64Utils;
import android.provider.Im;
import android.provider.Im.AvatarsColumns;
import android.widget.ImageView;
import android.widget.SimpleCursorAdapter;
import android.widget.Spinner;

import com.google.android.gtalkservice.IGTalkSession;

public class PresenceDialog extends Dialog {

	private IGTalkSession gtalkSession = null;
	
	public PresenceDialog(Context c, IGTalkSession session) {
		super(c);
		this.gtalkSession = session;
	}
    
	@Override
	protected void onStart() {
		super.onStart();
		setContentView(R.layout.presence_dialog);
		setTitle(GTalkUtils.getUserName(gtalkSession));
		fillData();
		decodeAvatar();
	}

	private void fillData() {
		Spinner spin = (Spinner) findViewById(R.id.presence_spinner);
        Cursor cursor = Mametalk.Presences.query(getContext().getContentResolver(), null);
		spin.setAdapter(new SimpleCursorAdapter(getContext(), android.R.layout.simple_spinner_dropdown_item,
				cursor, new String[] {Mametalk.Presences.STATUS}, new int[] {android.R.id.text1}));
        int status = GTalkUtils.getPresence(gtalkSession).getStatus();
		int numRows = cursor.count();
		cursor.first();
		for (int position = 0; position < numRows; ++position) {
			if (cursor.getInt(cursor.getColumnIndex(Mametalk.Presences.MODE)) == status) {
				spin.setSelection(position);
				break;
			}
			cursor.next();
		}
	}
	
	private void decodeAvatar() {
		/*
		android.net.Uri.Builder builder = Im.Avatars.CONTENT_URI_AVATARS_BY.buildUpon();
		builder.appendPath("taisuke999@gmail.com");
		ContentUris.appendId(builder, 1);
        ContentUris.appendId(builder, 1);
        Uri uri = builder.build();
        Cursor cursor = getContext().getContentResolver().query(uri, null, null, null, null);
        */
		String contact = GTalkUtils.getUserName(gtalkSession);
        Cursor cursor = getContext().getContentResolver().query(Im.Avatars.CONTENT_URI, null, "contact='" + contact + "'", null, null);
        if (0 < cursor.count()) {
			cursor.first();
			String encodeAvatar = cursor.getString(cursor.getColumnIndex(AvatarsColumns.DATA));
			byte[] data = Base64Utils.decodeBase64(encodeAvatar); 
			Bitmap bm = BitmapFactory.decodeByteArray(data, 0, data.length);
			((ImageView) findViewById(R.id.avatar_image)).setImageBitmap(bm);
		} else {
			((ImageView) findViewById(R.id.avatar_image)).setImageResource(R.drawable.android_robot);
		}
	}
	
	@Override
	protected void onStop() {
		super.onStop();
		Spinner spin = (Spinner)findViewById(R.id.presence_spinner);
		Cursor cur = (Cursor)spin.getSelectedItem();
		int mode = cur.getInt(cur.getColumnIndex(Mametalk.Presences.MODE));
		GTalkUtils.setPresence(gtalkSession, mode);
	}
}
