package jp.dip.commonsense.android.mametalk;

import java.text.SimpleDateFormat;
import java.util.Date;

import jp.dip.commonsense.android.mametalk.dialog.SmileyDialog;
import jp.dip.commonsense.android.util.AnimationUtils;
import jp.dip.commonsense.android.util.MessageUtils;
import jp.dip.commonsense.android.util.StringUtils;
import android.app.Dialog;
import android.app.ListActivity;
import android.database.Cursor;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.provider.Im.BaseMessageColumns;
import android.provider.Im.ContactsColumns;
import android.text.TextUtils;
import android.text.util.Linkify;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ListView;
import android.widget.TextView;

import com.google.android.gtalkservice.IChatSession;

public abstract class AbstractChatActivity extends ListActivity
                                            implements View.OnClickListener, View.OnKeyListener {
    private EditText messageText;
    private IChatSession chatSession;
    protected String contactName;

    @Override
    public void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        setContentView(R.layout.chat);
        messageText = (EditText) findViewById(R.id.message_edit);
        messageText.setOnKeyListener(this);
        contactName = icicle != null ? icicle.getString(ContactsColumns.USERNAME) : null;
        if (contactName == null) {
            Bundle extras = getIntent().getExtras();
            contactName = extras != null ? extras.getString(ContactsColumns.USERNAME) : null;
        }
        reflectExtras(icicle);
        setTitle(StringUtils.getPreparedText(getString(R.string.activity_title_chat), contactName));
        Button button = (Button) findViewById(R.id.smiley_button);
        button.setOnClickListener(this);
    }

    protected abstract void reflectExtras(Bundle icicle);

    @Override
    protected void onListItemClick(ListView l, View v, int position, long id) {
        setSelection(position);
        Cursor cursor = (Cursor) l.getSelectedItem();
        Dialog dialog = new Dialog(this);
        dialog.setContentView(R.layout.message_detail_dialog);
        dialog.setTitle(R.string.dialog_title_message_detail);
        long date = cursor.getLong(cursor.getColumnIndex(BaseMessageColumns.DATE));
        String dispDate = new SimpleDateFormat("dd MMM yyyy HH:mm:ss").format(new Date(date));
        TextView dateText = (TextView) dialog.findViewById(R.id.message_date_text);
        dateText.setText(dispDate);
        TextView bodyText = (TextView) dialog.findViewById(R.id.message_body_text);
        bodyText.setText(cursor.getString(cursor.getColumnIndex(BaseMessageColumns.BODY)));
        Linkify.addLinks(bodyText, Linkify.ALL);
        dialog.show();
    }

    @Override
    protected void onResume() {
        super.onResume();
        View layout = findViewById(R.id.chat_linear_layout);
        layout.startAnimation(AnimationUtils.createPushLeftAnimation(getWindowManager()
            .getDefaultDisplay().getWidth()));
        chatSession = createChatSession();
        fillData();
        if (getListAdapter() != null)
            setSelection(getListAdapter().getCount() - 1);
        messageText.requestFocus();
    }

    @SuppressWarnings("deprecation")
    protected IChatSession createChatSession() {
        return IChatSession.Stub.asInterface(getIntent().getIBinderExtra("chatSession"));
    }

    @Override
    public boolean onKey(View view, int keyCode, KeyEvent keyevent) {
        if (keyCode == KeyEvent.KEYCODE_BACK) {
            setResult(RESULT_OK, contactName);
            return false;
        }
        if (view.getId() == R.id.message_edit && keyevent.getAction() == KeyEvent.ACTION_DOWN) {
            if (keyCode == KeyEvent.KEYCODE_DPAD_CENTER || keyCode == KeyEvent.KEYCODE_NEWLINE) {
                String comment = messageText.getText().toString();
                if (TextUtils.isEmpty(comment)) {
                    return false;
                }
                if (chatSession == null) {
                    MessageUtils.showMessage(this,
                        getText(R.string.error_gtalk_service_not_connected));
                    return false;
                }
                try {
                    chatSession.sendTextMessage(messageText.getText().toString());
                    messageText.setText("");
                } catch (DeadObjectException ex) {
                    Log.e(this.getClass().getName(), "caught " + ex);
                    MessageUtils.showMessage(this,
                        getText(R.string.error_found_stale_gtalk_service));
                    chatSession = null;
                }
            }
        }
        return false;
    }

    @Override
    public void onClick(View view) {
        new SmileyDialog(this).show();
        messageText.requestFocus();
    }

    protected abstract void fillData();
}