package jp.dip.commonsense.android.mametalk;

import jp.dip.commonsense.android.util.StringUtils;
import android.database.ContentObserver;
import android.database.Cursor;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Handler;
import android.provider.Im;
import android.provider.Im.BaseMessageColumns;
import android.provider.Im.ContactsColumns;
import android.provider.Im.MessageType;
import android.widget.SimpleCursorAdapter;
import android.widget.TextView;

public class ChatClient extends AbstractChatActivity {

    private long providerId;
    private long accountId;

    @Override
    protected void reflectExtras(Bundle icicle) {
        providerId = icicle != null ? icicle.getLong(ContactsColumns.PROVIDER) : 0;
        Bundle extras = getIntent().getExtras();
        if (providerId == 0) {
            providerId = extras != null ? extras.getLong(ContactsColumns.PROVIDER) : 0;
        }
        accountId = icicle != null ? icicle.getLong(ContactsColumns.ACCOUNT) : 0;
        if (accountId == 0) {
            accountId = extras != null ? extras.getLong(ContactsColumns.ACCOUNT) : 0;
        }
    }

    @Override
    protected void onFreeze(Bundle outState) {
        super.onFreeze(outState);
        outState.putString(ContactsColumns.USERNAME, contactName);
        outState.putLong(ContactsColumns.PROVIDER, providerId);
        outState.putLong(ContactsColumns.ACCOUNT, accountId);
    }

    @Override
    protected void fillData() {
        Cursor cursor = managedQuery(Im.Messages.getContentUriByContact(providerId, accountId,
            contactName), null, null, null);
        this.setListAdapter(new SimpleCursorAdapter(this, R.layout.message_list_item, cursor,
            new String[] { BaseMessageColumns.TYPE, BaseMessageColumns.BODY }, new int[] {
                R.id.message_type_text, R.id.message_body_text }) {
            @Override
            public void setViewText(TextView v, String text) {
                String disp = text;
                if (v.getId() == R.id.message_type_text) {
                    switch (Integer.valueOf(disp)) {
                    case MessageType.OUTGOING:
                        disp = "";
                        break;
                    case MessageType.INCOMING:
                        disp = "> ";
                        break;
                    case MessageType.PRESENCE_AVAILABLE:
                        disp = StringUtils.getPreparedText(getString(R.string.info_online),
                            contactName);
                        break;
                    case MessageType.PRESENCE_AWAY:
                        disp = StringUtils.getPreparedText(getString(R.string.info_away),
                            contactName);
                        break;
                    case MessageType.PRESENCE_DND:
                        disp = StringUtils.getPreparedText(getString(R.string.info_busy),
                            contactName);
                        break;
                    case MessageType.PRESENCE_UNAVAILABLE:
                        disp = StringUtils.getPreparedText(getString(R.string.info_offline),
                            contactName);
                        break;
                    }
                    v.setTextColor(Color.GRAY);
                }
                super.setViewText(v, disp);
            }
        });
        cursor.registerContentObserver(new ContentObserver(new Handler()) {
            @Override
            public void onChange(boolean selfChange) {
                super.onChange(selfChange);
                if (getListAdapter() != null)
                    setSelection(getListAdapter().getCount() - 1);
            }
        });
    }
}
