package jp.dip.commonsense.android.mametalk;

import jp.dip.commonsense.android.mametalk.dialog.ChatInvitationDialog;
import jp.dip.commonsense.android.mametalk.dialog.GroupChatCreaterDialog;
import jp.dip.commonsense.android.mametalk.dialog.PresenceDialog;
import jp.dip.commonsense.android.mametalk.dialog.SubscriptionRequestDialog;
import jp.dip.commonsense.android.util.AnimationUtils;
import jp.dip.commonsense.android.util.MessageUtils;
import android.app.ListActivity;
import android.content.ComponentName;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.database.Cursor;
import android.os.Bundle;
import android.os.Handler;
import android.provider.Im;
import android.provider.Im.ChatsColumns;
import android.provider.Im.ContactsColumns;
import android.provider.Im.GroupMemberColumns;
import android.provider.Im.PresenceColumns;
import android.view.ContextMenu;
import android.view.Menu;
import android.view.View;
import android.view.Window;
import android.view.Menu.Item;
import android.view.animation.Animation;
import android.widget.ListView;

import com.google.android.gtalkservice.GTalkServiceConstants;
import com.google.android.gtalkservice.IChatSession;

public class ContactList extends ListActivity implements View.OnClickListener {

    private GTalkSessionController gtalkController = new GTalkSessionController();
    // Normal Menu
    private static final int SHOW_PRESENCE_ID = Menu.FIRST;
    private static final int INVITE_CONTACT_ID = Menu.FIRST + 1;
    private static final int CREATE_GROUPCHAT_ID = Menu.FIRST + 2;
    private static final int GTALK_SETTINGS_ID = Menu.FIRST + 3;
    // Context Menu
    private static final int REMOVE_CONTACT_ID = Menu.FIRST + 4;
    // Activity Result
    private static final int ACTIVITY_RESULT_CHAT = 1;
    private static final int ACTIVITY_RESULT_SETTINGS = 2;
    // Animation
    private Animation animation = null;;

    @Override
    public void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        getWindow().requestFeature(Window.FEATURE_LEFT_ICON);
        setContentView(R.layout.contact_list);
        getListView().setOnPopulateContextMenuListener(new View.OnPopulateContextMenuListener() {
            public void onPopulateContextMenu(ContextMenu menu, View v, Object o) {
                menu.add(Menu.SELECTED_ALTERNATIVE, REMOVE_CONTACT_ID,
                    R.string.menu_remove_contact, R.drawable.user_delete);
            }
        });
        findViewById(R.id.request_image_button).setOnClickListener(this);
        IntentFilter filter = new IntentFilter(Constants.ACTION_GTALK_SERVICE_CONNECTED);
        filter.addAction(Constants.ACTION_GROUP_CHAT_INVITATION);
        registerReceiver(new GTalkDataMessageReceiver(), filter);
    }
    
    @Override
    protected void onResume() {
        super.onResume();
        startAnimation();
        bindService((new Intent().
            setComponent(GTalkServiceConstants.GTALK_SERVICE_COMPONENT)), gtalkController, 0);
        fillData();
        initRequestButton();
        getListView().requestFocus();
    }

    private void startAnimation() {
        View layout = findViewById(R.id.contact_list_linear_layout);
        if (animation != null) layout.startAnimation(animation);
        animation = null;
    }
    
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        super.onCreateOptionsMenu(menu);
        menu.add(Menu.SYSTEM, GTALK_SETTINGS_ID, R.string.menu_gtalk_settings, R.drawable.wrench);
        return true;
    }

    @Override
    public boolean onPrepareOptionsMenu(Menu menu) {
        super.onPrepareOptionsMenu(menu);
        boolean havaItems = 0 < getListView().getCount();
        if (gtalkController.isConnected()) {
            if (menu.findItem(INVITE_CONTACT_ID) == null) {
                menu.add(Menu.ALTERNATIVE, SHOW_PRESENCE_ID, R.string.menu_show_presence,
                    R.drawable.status_online);
                menu.add(Menu.ALTERNATIVE, INVITE_CONTACT_ID, R.string.menu_invite_contact,
                    R.drawable.user_add);
            }
            if (havaItems) {
                if (menu.findItem(CREATE_GROUPCHAT_ID) == null) {
                    menu.add(Menu.ALTERNATIVE, CREATE_GROUPCHAT_ID, R.string.menu_create_groupchat,
                        R.drawable.comments);
                }
            } else {
                menu.removeItem(CREATE_GROUPCHAT_ID);
            }
        } else {
            menu.removeGroup(Menu.ALTERNATIVE);
        }
        return true;
    }

    @Override
    public boolean onMenuItemSelected(int featureId, Item item) {
        super.onMenuItemSelected(featureId, item);
        switch (item.getId()) {
        case INVITE_CONTACT_ID:
            new ChatInvitationDialog(this, gtalkController).show();
            break;
        case REMOVE_CONTACT_ID:
            gtalkController.removeContact(getStringColumn(ContactsColumns.USERNAME));
            break;
        case CREATE_GROUPCHAT_ID:
            new GroupChatCreaterDialog(this, gtalkController).show();
            break;
        case SHOW_PRESENCE_ID:
            new PresenceDialog(this, gtalkController).show();
            break;
        case GTALK_SETTINGS_ID:
            launchXmppSettings();
            break;
        }
        return true;
    }

    private void launchXmppSettings() {
        ComponentName comp = new ComponentName("com.google.android.gtalksettings",
            "com.google.android.gtalksettings.GTalkSettingsForwarder");
        startSubActivity((new Intent()).setComponent(comp), ACTIVITY_RESULT_SETTINGS);
    }

    private void fillData() {
        Cursor cursor = Im.Contacts.query(getContentResolver(), null);
        startManagingCursor(cursor);
        this.setListAdapter(new GTalkContactsAdapter(this, R.layout.contact_list_item, cursor,
            new String[] { ContactsColumns.NICKNAME, ChatsColumns.LAST_UNREAD_MESSAGE,
                PresenceColumns.PRESENCE_CUSTOM_STATUS, ContactsColumns.USERNAME }, new int[] {
                R.id.nickname_text, R.id.new_message_image, R.id.custom_status_text,
                R.id.avatar_image }));
    }

    private void initRequestButton() {
        setRequestButtonEnabled();
        getContentResolver().registerContentObserver(Im.Subscriptions.CONTENT_URI, true,
            new ContentObserver(new Handler()) {
                @Override
                public void onChange(boolean flag) {
                    super.onChange(flag);
                    setRequestButtonEnabled();
                }
            });
    }

    void setRequestButtonEnabled() {
        int requestCount = getContentResolver().query(Im.Subscriptions.CONTENT_URI, null, null,
            null, null).count();
        View button = findViewById(R.id.request_image_button);
        if (0 == requestCount) {
            button.setEnabled(false);
        } else {
            button.setEnabled(true);
        }
    }

    @Override
    public void onClick(View view) {
        new SubscriptionRequestDialog(this, gtalkController).show();
    }

    @Override
    protected void onPause() {
        super.onPause();
        unbindService(gtalkController);
    }

    @SuppressWarnings("deprecation")
    @Override
    protected void onListItemClick(ListView l, View v, int position, long id) {
        setSelection(position);
        animation = AnimationUtils.createPushRightAnimation(
                getWindowManager().getDefaultDisplay().getWidth());
        if (!gtalkController.isConnected()) {
            MessageUtils.showMessage(this, getText(R.string.error_gtalk_service_not_connected));
            return;
        }
        String contactName = getStringColumn(ContactsColumns.USERNAME);
        IChatSession chatSession = gtalkController.getChatSession(contactName);
        Intent i = null;
        if (getLongColumn(ChatsColumns.GROUP_CHAT) == 1) {
            i = new Intent(this, GroupChatClient.class);
            i.putExtra(GroupMemberColumns.GROUP, getLongColumn("chats_contact_id"));
        } else {
            i = new Intent(this, ChatClient.class);
            i.putExtra(ContactsColumns.PROVIDER, getLongColumn(ContactsColumns.PROVIDER));
            i.putExtra(ContactsColumns.ACCOUNT, getLongColumn(ContactsColumns.ACCOUNT));
        }
        i.putExtra(ContactsColumns.USERNAME, contactName);
        i.putExtra(Constants.EXTRA_CHAT_SESSION, chatSession.asBinder());
        startSubActivity(i, ACTIVITY_RESULT_CHAT);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, String data, Bundle extras) {
        super.onActivityResult(requestCode, resultCode, data, extras);
        if (requestCode == ACTIVITY_RESULT_CHAT) {
            gtalkController.endChatSession(data);
        }
    }

    private String getStringColumn(String columnName) {
        Cursor cursor = (Cursor) getListView().getSelectedItem();
        return cursor.getString(cursor.getColumnIndex(columnName));
    }

    private long getLongColumn(String columnName) {
        Cursor cursor = (Cursor) getListView().getSelectedItem();
        return cursor.getLong(cursor.getColumnIndex(columnName));
    }

}