package jp.dip.commonsense.android.mametalk;

import jp.dip.commonsense.android.util.AvatarUtils;
import android.content.Context;
import android.database.Cursor;
import android.provider.Im.PresenceColumns;
import android.text.TextUtils;
import android.widget.ImageView;
import android.widget.SimpleCursorAdapter;
import android.widget.TextView;

public class GTalkContactsAdapter extends SimpleCursorAdapter {

    public GTalkContactsAdapter(Context context, int layout, Cursor c, String[] from, int[] to) {
        super(context, layout, c, from, to);
    }

    @Override
    public void setViewText(TextView v, String text) {
        String disp = text;
        if (v.getId() == R.id.custom_status_text) {
            String status = mCursor.getString(mCursor
                .getColumnIndex(PresenceColumns.PRESENCE_STATUS));
            if (TextUtils.isEmpty(status)) {
                disp = "";
            } else if (Integer.parseInt(status) <= PresenceColumns.INVISIBLE) {
                disp = "offline";
            }
        }
        v.setText(disp);
    }

    @Override
    public void setViewImage(ImageView v, String text) {
        if (v.getId() == R.id.new_message_image) {
            // VbZ[W摜̕\
            if (text != "") v.setImageResource(R.drawable.comment);
        } else {
            v.setImageDrawable(AvatarUtils.resolveAvatarIcon(mContext, text));
        }
    }
}
