package jp.dip.commonsense.android.mametalk;

import jp.dip.commonsense.android.util.AvatarUtils;
import jp.dip.commonsense.android.util.StringUtils;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.IntentReceiver;
import android.view.Window;
import android.widget.Toast;

public class GTalkDataMessageReceiver extends IntentReceiver {

    @Override
    public void onReceiveIntent(Context context, Intent intent) {
        if (intent.getAction().equals(Constants.ACTION_GTALK_SERVICE_CONNECTED)) {
            Activity activity = (Activity)context;
            String userName = intent.getStringExtra(Constants.EXTRA_GTALK_USER_NAME);
            activity.setTitle(userName);
            activity.getWindow().setFeatureDrawable(Window.FEATURE_LEFT_ICON,
                    AvatarUtils.resolveAvatarIcon(activity, userName));
        } else {
            // ConcurrentModificationException΍
            synchronized (context) {
                String inviter = intent.getStringExtra(Constants.EXTRA_GROUP_CHAT_INVITER);
                Toast.makeText(context, StringUtils.getPreparedText(
                    context.getString(R.string.info_accept_invitaion), inviter), Toast.LENGTH_LONG).show();
            }
        }
    }

}