package jp.dip.commonsense.android.mametalk;

import java.util.ArrayList;

import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.provider.Im;
import android.util.Log;

import com.google.android.gtalkservice.GroupChatInvitation;
import com.google.android.gtalkservice.IChatSession;
import com.google.android.gtalkservice.IGTalkService;
import com.google.android.gtalkservice.IGTalkSession;
import com.google.android.gtalkservice.IGroupChatInvitationListener;
import com.google.android.gtalkservice.Presence;

public class GTalkSessionController implements ServiceConnection {

    protected IGTalkSession gtalkSession;

    @Override
    public void onServiceConnected(ComponentName componentname, IBinder service) {
        try {
            gtalkSession = IGTalkService.Stub.asInterface(service).getDefaultSession();
            if (gtalkSession == null) {
                return;
            }
            gtalkSession.setPresence(createPresence(Im.PresenceColumns.AVAILABLE));
            gtalkSession.requestRoster();
            gtalkSession.addGroupChatInvitationListener(listener);
            Intent intent = new Intent(Constants.ACTION_GTALK_SERVICE_CONNECTED)
                    .putExtra(Constants.EXTRA_GTALK_USER_NAME, gtalkSession.getUsername());
            // ڑƂIntentReceiverɓ`
            gtalkSession.sendDataMessage(gtalkSession.getUsername(), intent);
        } catch (DeadObjectException e) {
            log(e);
        }
    }

    @Override
    public void onServiceDisconnected(ComponentName componentname) {
        setPresence(Im.PresenceColumns.OFFLINE);
        gtalkSession = null;
    }

    private IGroupChatInvitationListener.Stub listener = new IGroupChatInvitationListener.Stub() {
        public void onInvitationReceived(GroupChatInvitation groupchatinvitation)
                throws DeadObjectException {
            gtalkSession.joinGroupChatSession(groupchatinvitation.getRoomAddress(), "", "");
            Intent intent = new Intent(Constants.ACTION_GROUP_CHAT_INVITATION)
                    .putExtra(Constants.EXTRA_GROUP_CHAT_INVITER, groupchatinvitation.getInviter());
            gtalkSession.sendDataMessage(gtalkSession.getUsername(), intent);
        }
    };

    private Presence createPresence(int mode) {
        Presence presence = new Presence();
        presence.setStatus(mode);
        return presence;
    }
    
    public String getUserName() {
        try {
            return gtalkSession.getUsername();
        } catch (DeadObjectException e) {
            log(e);
            return null;
        }
    }

    public Presence getPresence() {
        try {
            return gtalkSession.getPresence();
        } catch (DeadObjectException e) {
            log(e);
            return null;
        }
    }

    public IChatSession getChatSession(String to) {
        try {
            IChatSession chatSession = gtalkSession.getChatSession(to);
            if (chatSession == null) {
                chatSession = gtalkSession.createChatSession(to);
            }
            return chatSession;
        } catch (DeadObjectException e) {
            log(e);
            return null;
        }
    }

    public void endChatSession(String contactName) {
        try {
            gtalkSession.getChatSession(contactName).leave();
        } catch (DeadObjectException e) {
            log(e);
        }
    }

    public void removeContact(String contact) {
        try {
            gtalkSession.removeContact(contact);
        } catch (DeadObjectException e) {
            log(e);
        }
    }

    public void approveSubscriptionRequest(String contact) {
        try {
            gtalkSession.approveSubscriptionRequest(contact, null);
        } catch (DeadObjectException e) {
            log(e);
        }
    }

    public void declineSubscriptionRequest(String contact) {
        try {
            gtalkSession.declineSubscriptionRequest(contact);
        } catch (DeadObjectException e) {
            log(e);
        }
    }

    public boolean isConnected() {
        if (gtalkSession == null) return false;
        try {
            return gtalkSession.isConnected();
        } catch (DeadObjectException e) {
            log(e);
            return false;
        }
    }

    public int getConnectionState() {
        try {
            return gtalkSession.getConnectionState();
        } catch (DeadObjectException e) {
            log(e);
            return -1;
        }
    }

    public void setPresence(int mode) {
        try {
            gtalkSession.setPresence(createPresence(mode));
        } catch (DeadObjectException e) {
            log(e);
        }
    }

    public void setCustomPresence(int mode, String status) {
        try {
            Presence presence = new Presence(mode, status);
            gtalkSession.setPresence(presence);
        } catch (DeadObjectException e) {
            log(e);
        }
    }

    public void inviteContact(String contactName, String nickName) {
        try {
            gtalkSession.inviteContact(contactName, nickName);
        } catch (DeadObjectException e) {
            log(e);
        }
    }
    
    public void createGroupChatSession(String nickname, ArrayList<String> contacts) {
        try {
            gtalkSession.createGroupChatSession(nickname, contacts.toArray(new String[] {}));
        } catch (DeadObjectException e) {
            log(e);
        }
    }

    public void joinGroupChatSession(String roomAddress) {
        try {
            gtalkSession.joinGroupChatSession(roomAddress, "", "");
        } catch (DeadObjectException e) {
            log(e);
        }
    }

    public void declineGroupChatInvitation(String roomAddress) {
        try {
            gtalkSession.declineGroupChatInvitation(roomAddress);
        } catch (DeadObjectException e) {
            log(e);
        }
    }

    public void logout() {
        try {
            gtalkSession.logout();
        } catch (DeadObjectException e) {
            log(e);
        }
    }

    public void sendDataMessage(String to, Intent intent) {
        try {
            gtalkSession.sendDataMessage(to, intent);
        } catch (DeadObjectException e) {
            log(e);
        }
    }

    private void log(Exception e) {
        Log.e(this.getClass().getName(), e.getMessage(), e);
    }
}