package jp.dip.commonsense.android.mametalk;

import jp.dip.commonsense.android.mametalk.dialog.GroupChatInvitationDialog;
import jp.dip.commonsense.android.mametalk.dialog.ParticipantsDialog;
import jp.dip.commonsense.android.util.StringUtils;
import android.database.ContentObserver;
import android.database.Cursor;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Handler;
import android.provider.Im;
import android.provider.Im.BaseMessageColumns;
import android.provider.Im.ContactsColumns;
import android.provider.Im.GroupMemberColumns;
import android.provider.Im.MessageType;
import android.view.Menu;
import android.view.Menu.Item;
import android.widget.SimpleCursorAdapter;
import android.widget.TextView;

public class GroupChatClient extends AbstractChatActivity {

    private long groupId;

    @Override
    protected void reflectExtras(Bundle icicle) {
        groupId = icicle != null ? icicle.getLong(GroupMemberColumns.GROUP) : 0;
        if (groupId == 0) {
            Bundle extras = getIntent().getExtras();
            groupId = extras != null ? extras.getLong(GroupMemberColumns.GROUP) : 0;
        }
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        super.onCreateOptionsMenu(menu);
        menu.add(Menu.ALTERNATIVE, Menu.FIRST, R.string.menu_show_participants, R.drawable.group);
        menu.add(Menu.ALTERNATIVE, Menu.FIRST + 1, R.string.menu_add_member, R.drawable.user_add);
        return true;
    }

    @Override
    public boolean onMenuItemSelected(int featureId, Item item) {
        super.onMenuItemSelected(featureId, item);
        switch (item.getId()) {
        case Menu.FIRST:
            new ParticipantsDialog(this, groupId).show();
            break;
        case Menu.FIRST + 1:
            new GroupChatInvitationDialog(this, createChatSession()).show();
            break;
        }
        return true;
    }

    @Override
    protected void onFreeze(Bundle outState) {
        super.onFreeze(outState);
        outState.putString(ContactsColumns.USERNAME, contactName);
        outState.putLong(GroupMemberColumns.GROUP, groupId);
    }

    @Override
    protected void fillData() {
        Cursor cursor = managedQuery(Im.GroupMessages.getContentUriByGroup(groupId), null, null,
            null);
        this.setListAdapter(new SimpleCursorAdapter(this, R.layout.message_list_item, cursor,
            new String[] { BaseMessageColumns.CONTACT, BaseMessageColumns.BODY }, new int[] {
                R.id.message_contact_text, R.id.message_body_text }) {
            @Override
            public void setViewText(TextView v, String text) {
                String disp = text;
                if (v.getId() == R.id.message_contact_text) {
                    int type = mCursor.getInt(mCursor.getColumnIndex(BaseMessageColumns.TYPE));
                    switch (type) {
                    case MessageType.PRESENCE_AVAILABLE:
                        disp = StringUtils.getPreparedText(getString(R.string.info_entered_room), disp);
                        v.setTextColor(Color.GRAY);
                        break;
                    case MessageType.PRESENCE_UNAVAILABLE:
                        disp = StringUtils.getPreparedText(getString(R.string.info_left_room), disp);
                        v.setTextColor(Color.GRAY);
                        break;
                    default:
                        disp = disp + " : ";
                        break;
                    }
                }
                super.setViewText(v, disp);
            }
        });
        cursor.registerContentObserver(new ContentObserver(new Handler()) {
            @Override
            public void onChange(boolean selfChange) {
                super.onChange(selfChange);
                if (getListAdapter() != null)
                    setSelection(getListAdapter().getCount() - 1);
            }
        });
    }
}
