package jp.dip.commonsense.android.mametalk.dialog;

import android.app.Dialog;
import android.content.Context;

public abstract class AbstractDialog extends Dialog {

    public AbstractDialog(Context context, boolean cancelable,
            OnCancelListener cancelListener) {
        super(context, cancelable, cancelListener);
    }

    public AbstractDialog(Context context, int theme) {
        super(context, theme);
    }

    public AbstractDialog(Context context) {
        super(context);
    }

    @Override
    protected void onStart() {
        super.onStart();
        setContentView(getLayoutResource());
        createTitle();
        createViews();
        createButtons();
    }

    protected abstract int getLayoutResource();
    
    protected abstract void createTitle();
    
    protected void createViews() {
        //
    }
    
    protected void createButtons() {
        //
    }
}
