package jp.dip.commonsense.android.mametalk.dialog;

import jp.dip.commonsense.android.mametalk.R;
import android.content.Context;
import android.database.Cursor;
import android.provider.Im;
import android.provider.Im.ContactsColumns;
import android.view.View;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.SimpleCursorAdapter;

public abstract class AbstractGroupChatInvitationDialog extends AbstractListDialog
        implements View.OnClickListener {

    public AbstractGroupChatInvitationDialog(Context context) {
        super(context);
    }

    @Override
    protected void createTitle() {
        setTitle(R.string.dialog_title_groupchat_invitation);
    }

    @Override
    protected int getLayoutResource() {
        return R.layout.group_chat_invitation_dialog;
    }

    @Override
    protected void createButtons() {
        Button button = (Button)findViewById(R.id.invite_button);
        button.setOnClickListener(this);
    }

    @Override
    protected void fillData() {
        Cursor cursor = getContext().getContentResolver().query(Im.Contacts.CONTENT_URI, null,
                "type=0", null, null);
        getListView().setAdapter(
                new SimpleCursorAdapter(getContext(), R.layout.selectable_contact_list_item, cursor,
                new String[] { ContactsColumns.NICKNAME }, new int[] { R.id.nickname_text }));

    }
    
    @SuppressWarnings("unchecked")
    @Override
    public void onItemClick(AdapterView adapterview, View view, int i, long l) {
        CheckBox checkBox = (CheckBox) view.findViewById(R.id.contact_checkbox);
        checkBox.setChecked(!checkBox.isChecked());
    }
}
