package jp.dip.commonsense.android.mametalk.dialog;

import android.content.Context;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListView;

public abstract class AbstractListDialog extends AbstractDialog
        implements AdapterView.OnItemClickListener{

    public AbstractListDialog(Context context, boolean cancelable,
            OnCancelListener cancelListener) {
        super(context, cancelable, cancelListener);
    }

    public AbstractListDialog(Context context, int theme) {
        super(context, theme);
    }

    public AbstractListDialog(Context context) {
        super(context);
    }

    private ListView listView;

    protected ListView getListView() {
        return listView;
    }

    @Override
    protected void onStart() {
        super.onStart();
        fillData();
    }

    @Override
    protected void createViews() {
        listView = (ListView)findViewById(android.R.id.list);
        listView.setOnItemClickListener(this);
        listView.setEmptyView(findViewById(android.R.id.empty));
    }

    abstract protected void fillData();
    
    @SuppressWarnings("unchecked")
    @Override
    public void onItemClick(AdapterView adapterview, View view, int i, long l) {
        //
    }
}