package jp.dip.commonsense.android.mametalk.dialog;

import jp.dip.commonsense.android.mametalk.GTalkSessionController;
import jp.dip.commonsense.android.mametalk.R;
import android.content.Context;
import android.database.Cursor;
import android.provider.Contacts;
import android.provider.Contacts.ContactMethodsColumns;
import android.provider.Contacts.PeopleColumns;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.View;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.EditText;
import android.widget.SimpleCursorAdapter;
import android.widget.TextView;

public class ChatInvitationDialog extends AbstractListDialog
        implements View.OnClickListener, View.OnKeyListener {

    private EditText contactText;
    private GTalkSessionController gtalkController;
    
    public ChatInvitationDialog(Context context, GTalkSessionController gtalkController) {
        super(context);
        this.gtalkController = gtalkController;
    }

    @Override
    protected void createButtons() {
        Button addButton = (Button) findViewById(R.id.invite_button);
        addButton.setOnClickListener(this);
    }

    @Override
    protected void createViews() {
        super.createViews();
        contactText = (EditText) findViewById(R.id.newcontact_edit);
        contactText.setOnKeyListener(this);
    }

    private Cursor getCursor() {
        String selection = null;
        if (contactText != null && !TextUtils.isEmpty(contactText.getText().toString())) {
            selection = ContactMethodsColumns.DATA + " like '" + contactText.getText().toString() + "%'";
        }
        return getContext().getContentResolver().query(Contacts.ContactMethods.CONTENT_EMAIL_URI, null, selection, null, null);
    }
    
    @Override
    protected void fillData() {
        getListView().setAdapter(new SimpleCursorAdapter(getContext(), R.layout.email_list_item, getCursor(),
            new String[] { PeopleColumns.NAME, ContactMethodsColumns.DATA },
            new int[] { R.id.person_name_text, R.id.email_text }));
    }

    @Override
    protected void createTitle() {
        setTitle(R.string.dialog_title_chat_invitation);
    }

    @Override
    protected int getLayoutResource() {
        return R.layout.chat_invitation_dialog;
    }
    
    @SuppressWarnings("unchecked")
    @Override
    public void onItemClick(AdapterView adapterview, View view, int i, long l) {
        super.onItemClick(adapterview, view, i, l);
        String email = getStringColumn(ContactMethodsColumns.DATA);
        contactText.setText(email);
    }

    private boolean isValidContact(String contact) {
        if (TextUtils.isEmpty(contact)) {
            return false;
        }
        if (contact.indexOf('@') == -1) {
            return false;
        }
        return true;
    }

    @Override
    public void onClick(View view) {
        if (view.getId() == R.id.invite_button) {
            String contact = contactText.getText().toString();
            if (!isValidContact(contact)) {
                TextView messageText = (TextView) findViewById(R.id.message_text);
                messageText.setText(R.string.error_invalid_username);
                return;
            }
            gtalkController.inviteContact(contact, null);
            dismiss();
        }
    }
    
    private String getStringColumn(String columnName) {
        Cursor cursor = (Cursor) getListView().getSelectedItem();
        return cursor.getString(cursor.getColumnIndex(columnName));
    }

    @Override
    public boolean onKey(View view, int i, KeyEvent keyevent) {
        fillData();
        return false;
    }
}
