package jp.dip.commonsense.android.mametalk.dialog;

import jp.dip.commonsense.android.mametalk.R;
import android.content.Context;
import android.database.Cursor;
import android.provider.Im;
import android.provider.Im.GroupMemberColumns;
import android.widget.SimpleCursorAdapter;

public class ParticipantsDialog extends AbstractListDialog {

    private long groupId;

    public ParticipantsDialog(Context context, long groupId) {
        super(context);
        this.groupId = groupId;
    }

    @Override
    protected void createTitle() {
        setTitle(R.string.dialog_title_participants);
    }

    @Override
    protected int getLayoutResource() {
        return R.layout.simple_list;
    }

    @Override
    protected void fillData() {
        Cursor cursor = getContext().getContentResolver().query(Im.GroupMembers.CONTENT_URI, null,
            GroupMemberColumns.GROUP + "=" + groupId, null, null);
        getListView().setAdapter(new SimpleCursorAdapter(getContext(), R.layout.simple_list_item,
            cursor, new String[] { GroupMemberColumns.NICKNAME }, new int[] { R.id.text }));
    }
}
