package jp.dip.commonsense.android.mametalk.dialog;

import jp.dip.commonsense.android.mametalk.GTalkSessionController;
import jp.dip.commonsense.android.mametalk.R;
import jp.dip.commonsense.android.provider.Mametalk;
import jp.dip.commonsense.android.util.AvatarUtils;
import android.content.Context;
import android.database.Cursor;
import android.widget.ImageView;
import android.widget.SimpleCursorAdapter;
import android.widget.Spinner;

public class PresenceDialog extends AbstractDialog {

    private GTalkSessionController gtalkSession = null;

    public PresenceDialog(Context c, GTalkSessionController session) {
        super(c);
        this.gtalkSession = session;
    }

    @Override
    protected void createTitle() {
        setTitle(gtalkSession.getUserName());
    }

    @Override
    protected int getLayoutResource() {
        return R.layout.presence_dialog;
    }

    @Override
    protected void onStart() {
        super.onStart();
        fillSpinnerData();
        decodeAvatar();
    }

    private void fillSpinnerData() {
        Spinner spin = (Spinner) findViewById(R.id.presence_spinner);
        Cursor cursor = Mametalk.Presences.query(getContext().getContentResolver(), null);
        spin.setAdapter(new SimpleCursorAdapter(getContext(),
            android.R.layout.simple_spinner_dropdown_item, cursor,
            new String[] { Mametalk.Presences.STATUS }, new int[] { android.R.id.text1 }));
        int status = gtalkSession.getPresence().getStatus();
        int numRows = cursor.count();
        cursor.first();
        for (int position = 0; position < numRows; ++position) {
            if (cursor.getInt(cursor.getColumnIndex(Mametalk.Presences.MODE)) == status) {
                spin.setSelection(position);
                break;
            }
            cursor.next();
        }
    }

    private void decodeAvatar() {
        String contact = gtalkSession.getUserName();
        ((ImageView) findViewById(R.id.avatar_image))
            .setImageDrawable(AvatarUtils.resolveAvatarIcon(getContext(), contact));
    }

    @Override
    protected void onStop() {
        super.onStop();
        Spinner spin = (Spinner) findViewById(R.id.presence_spinner);
        Cursor cur = (Cursor) spin.getSelectedItem();
        int mode = cur.getInt(cur.getColumnIndex(Mametalk.Presences.MODE));
        gtalkSession.setPresence(mode);
    }
}
