package jp.dip.commonsense.android.mametalk.dialog;

import jp.dip.commonsense.android.mametalk.R;
import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.GridView;

public class SmileyDialog extends AbstractDialog implements AdapterView.OnItemClickListener {

    // DB邩Kv
    private static final String[] smileyIcons = { ":)", ":D", ";)", ":(",
                                                    ":'(", ":-o", ":-/", "x-(",
                                                    ">.<", ":-|", "B-)", ":P",
                                                    "<3", "</3", "}:)" };

    // getContext()ƌĂяoActivitỹIuWFNg𑀍삷ƃG[ɂȂ̂ŕKv
    private Context context;

    public SmileyDialog(Context context) {
        super(context);
        this.context = context;
    }

    @Override
    protected void onStart() {
        super.onStart();
        GridView gv = (GridView) findViewById(R.id.smiley_grid);
        gv.setAdapter(new ArrayAdapter<String>(
            getContext(), R.layout.smiley_list_item, smileyIcons));
        gv.setOnItemClickListener(this);
    }

    @Override
    protected void createTitle() {
        setTitle(R.string.dialog_title_smiley);
    }

    @Override
    protected int getLayoutResource() {
        return R.layout.smiley_list_dialog;
    }

    @SuppressWarnings( { "unchecked", "synthetic-access" })
    @Override
    public void onItemClick(AdapterView parent, View view, int position, long id) {
        EditText messageText = (EditText) ((Activity) context).findViewById(R.id.message_edit);
        parent.setSelection(position);
        String smiley = (String) parent.getSelectedItem();
        messageText.setText(messageText.getText().toString() + smiley);
        dismiss();
    }
}