package jp.dip.commonsense.android.mametalk.dialog;

import jp.dip.commonsense.android.mametalk.GTalkSessionController;
import jp.dip.commonsense.android.mametalk.R;
import android.content.Context;
import android.database.ContentObserver;
import android.database.Cursor;
import android.os.Handler;
import android.provider.Im;
import android.provider.Im.SubscriptionsColumns;
import android.view.View;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.SimpleCursorAdapter;
import android.widget.TextView;

public class SubscriptionRequestDialog extends AbstractListDialog implements View.OnClickListener {

    private GTalkSessionController gtalkController;

    public SubscriptionRequestDialog(Context context, GTalkSessionController gtalkSession) {
        super(context);
        this.gtalkController = gtalkSession;
    }

        
    @Override
    protected void createTitle() {
        setTitle(R.string.dialog_title_subscription_request);
    }

    @Override
    protected int getLayoutResource() {
        return R.layout.subscription_request_dialog;
    }

    @Override
    protected void onStart() {
        super.onStart();
    }

    @Override
    protected void createButtons() {
        Button approveButton = (Button) findViewById(R.id.approve_button);
        approveButton.setOnClickListener(this);
        Button declineButton = (Button) findViewById(R.id.decline_button);
        declineButton.setOnClickListener(this);
    }


    @Override
    protected void fillData() {
        Cursor cursor = getContext().getContentResolver().query(Im.Subscriptions.CONTENT_URI, null,
            null, null, null);
        getListView().setAdapter(new SimpleCursorAdapter(getContext(),
            R.layout.selectable_contact_list_item, cursor,
            new String[] { SubscriptionsColumns.USERNAME }, new int[] { R.id.nickname_text }));
        if (cursor.count() == 0) {
            ((Button) findViewById(R.id.approve_button)).setVisibility(View.GONE);
            ((Button) findViewById(R.id.decline_button)).setVisibility(View.GONE);
        }
        cursor.registerContentObserver(new ContentObserver(new Handler()) {
            @Override
            public void onChange(boolean selfChange) {
                super.onChange(selfChange);
                ((Button) findViewById(R.id.approve_button)).setVisibility(View.VISIBLE);
                ((Button) findViewById(R.id.decline_button)).setVisibility(View.VISIBLE);
            }
        });
    }

    @SuppressWarnings("unchecked")
    @Override
    public void onItemClick(AdapterView adapterview, View view, int i, long l) {
        CheckBox checkBox = (CheckBox) view.findViewById(R.id.contact_checkbox);
        checkBox.setChecked(!checkBox.isChecked());
    }
    
    @Override
    public void onClick(View view) {
        int size = getListView().getCount();
        int checkedCount = 0;
        for (int i = 0; i < size; i++) {
            View v = getListView().getChildAt(i);
            CheckBox check = (CheckBox) v.findViewById(R.id.contact_checkbox);
            if (check.isChecked()) {
                TextView text = (TextView) v.findViewById(R.id.nickname_text);
                if (view.getId() == R.id.approve_button) {
                    gtalkController.approveSubscriptionRequest(text.getText().toString());
                } else {
                    gtalkController.declineSubscriptionRequest(text.getText().toString());
                }
                checkedCount++;
            }
        }
        TextView error = (TextView) findViewById(R.id.error_message_text);
        if (checkedCount == 0) {
            error.setVisibility(View.VISIBLE);
            error.setText(R.string.error_unchecked);
            return;
        }
        dismiss();
    }
}