package jp.dip.commonsense.android.util;

import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;

public class AnimationUtils {

    private AnimationUtils() {
        //
    }

    public static int DURATION = 750;
    public static int MARGIN = 100;

    public static Animation createPushLeftAnimation(int width) {
        Animation animation = new TranslateAnimation(width + MARGIN, 0, 0, 0);
        animation.setDuration(DURATION);
        return animation;
    }

    public static Animation createPushRightAnimation(int width) {
        Animation animation = new TranslateAnimation(-(width * 2) - MARGIN, 0, 0, 0);
        animation.setDuration(DURATION);
        return animation;
    }

    public static Animation createPushDownAnimation(int height) {
        Animation animation = new TranslateAnimation(0, 0, height + MARGIN, 0);
        animation.setDuration(DURATION);
        return animation;
    }

    public static Animation createPushUpAnimation(int height) {
        Animation animation = new TranslateAnimation(0, 0, -(height * 2) - MARGIN, 0);
        animation.setDuration(DURATION);
        return animation;
    }
}
