#!/usr/bin/env python

from distutils.core import setup

import platform
import sys

DependingPyserialErrorMsg = '''\
Error: ManageRS needs pyserial package to communicate RemoteStation. Install
that package with your linux package manager or by yourself with downloading
pyserial from official web site(http://pyserial.sourceforge.net/).
'''

DependingPexpectErrorMsg = '''\
Error: ManageRS needs pexpect package to decide where RemoteStation is. Install
that package with your linux package manager or by yourself with downloading
pyserial from official web site(http://www.noah.org/wiki/Pexpect).
'''

try :
    import serial
except ImportError, inst :
    sys.stderr.write(DependingPyserialErrorMsg)
    sys.exit(1)

if platform.system().lower() == 'linux' :
    try :
        import pexpect
    except ImportError, inst:
        sys.stderr.write(DependingPexpectErrorMsg)
        sys.exit(1)

setup(
      name='managers',
      scripts=['src/managers.py'],
      py_modules=['portalocker'],
      packages=['rsdevice'],
      package_dir={'':'src','rsdevice':'src/rsdevice'},
      data_files=[('etc', ['etc/managers.conf', 'etc/managers.sig']),
                  ('share/locale/ja/LC_MESSAGES', ['locale/ja/LC_MESSAGES/managers.mo', 'locale/ja/LC_MESSAGES/managers.rsdevice.mo'])],
      version='0.1',
      description='Buffalo RemoteStation PC-OP-RS1 control software',
      author='M.Decimal',
      author_email='deshi_atmark_specurio-studio.com',
)