# coding: utf-8
'''Exception definision for RemoteStaion device module.
'''

__author__ = 'M.Decimal at Specurio Studio.'
__version__ = '0.1'
__date__ = '2009-12-08'
__credits__ = """\
RemoteStation PC-OP-RS1 is a product for trasmitting ir signals made by
Japanese peripheral equipment vender Buffalo,Inc.
This script was coded on Pydev, powerful python IDE by Fabio Zadrozny, and now
becoming Apatana open source product.
Of course, Pydev is plug-in for, THE GREATE IDE, Eclipse provided by Eclipse
Foundation.
"""

class DeviceError( Exception ):
    '''\
    This is base class for all exception
    '''
    
    def __init__(self, msg ) :
        self.msg = msg
    
    def __str__(self):
        return self.msg


class SetupDeviceError( DeviceError ):
    '''Exception for when setting up device
    '''
    pass

class DeviceNotFoundError( DeviceError ):
    '''Exception for when device was not found
    '''
    pass

class InvalidDataError( DeviceError ):
    '''Exception for when signal data was invalid
    '''
    pass

class UnexpectedReplyError( DeviceError ):
    '''Exception for when RS replied unexpected value
    '''
    pass

class TimeoutError( DeviceError ):
    '''Exception for when RS did not reply for certain seconds.
    '''
    pass

class InvalidChannelError( DeviceError ):
    '''Exception for when ir emitter channel was wrong.
    '''
    pass