package mandelbrotExplorer;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Iterator;

import javax.swing.JComponent;

public final class Mandelbrot extends JComponent {
	private static final long serialVersionUID = 1L;
	private MandelbrotImage mndlImg = null;
	private boolean isDragging = false ;
	private Color backColor;
	private Mandelbrot mandelbrot;
	private Point distance,lastPoint,newPoint;
	private double rLeft,rRight,iTop,iBottom;
	
	public Mandelbrot(double rL,double rR,double iT,double iB){
		mandelbrot = this;
		this.rLeft = rL;
		this.rRight = rR;
		this.iTop = iT;
		this.iBottom = iB;

		distance = new Point(0,0);
		newPoint = new Point(0,0);
		lastPoint = new Point(0,0);
		backColor = new Color(255,255,0);

		mndlImg = new MandelbrotImage(this);
		
		this.addMouseMotionListener(new MouseMotionAdapter(){
			public void mouseDragged(MouseEvent e) {
				isDragging  = true;
				newPoint.move(e.getX()-lastPoint.x, e.getY()-lastPoint.y);
				mandelbrot.repaint();
			}

			public void mouseMoved(MouseEvent e) {
				lastPoint = e.getPoint().getLocation();
			}
		});

		this.addMouseListener(new MouseAdapter(){
			public void mouseReleased(MouseEvent e) {
				isDragging = false;
				distance.setLocation(e.getX()-lastPoint.x, e.getY()-lastPoint.y);
				lastPoint = (Point) e.getPoint().getLocation().clone();
				newPoint.move(0,0);

				mndlImg.translate( distance );
				mandelbrot.sendRegionUpdate();
			}
		});


		this.addComponentListener(new ComponentAdapter(){
			public void componentResized(ComponentEvent e) {
				if( mndlImg.imageIsNull() ){// ŏComponentSize肳ꂽꍇ
					mndlImg.createNewImage(e.getComponent().getWidth(),e.getComponent().getHeight()
											,rLeft, rRight, iTop, iBottom);
					mndlImg.drawAll();
					mandelbrot.sendRegionUpdate();
				}else{						// ʏSizeύX̏ꍇ
					if( mndlImg.getWidth()!=mandelbrot.getSize().width
							|| mndlImg.getHeight()!=mandelbrot.getSize().height ){

						mndlImg.setSize(mandelbrot.getSize().width, mandelbrot.getSize().height);

						mandelbrot.sendRegionUpdate();
					}
				}
			}
		});
		
		this.addMouseWheelListener(new MouseWheelListener(){
			public void mouseWheelMoved(MouseWheelEvent e){
				mndlImg.changeMagnification(-e.getWheelRotation());
				mandelbrot.sendRegionUpdate();
			}
		});

	}

	public void setNewRegion(double rLeft,double rRight,double iTop,double iBottom){
		this.rLeft = rLeft;
		this.rRight = rRight;
		this.iTop = iTop;
		this.iBottom = iBottom;
		
		if( !mndlImg.imageIsNull() ){
				mndlImg.createNewImage(mndlImg.getWidth(),mndlImg.getHeight()
										,rLeft, rRight, iTop, iBottom);
				mndlImg.drawAll();
				mandelbrot.sendRegionUpdate();
		}
	}
	
	private void sendRegionUpdate(){
		mandelbrot.sendActionEvent(new MandelbrotEvent(mndlImg.toString()){
			private static final long serialVersionUID = 1L;		
		});
	}

	public void paint(Graphics g){
		if( !mndlImg.imageIsNull() ){
			if( isDragging ){
				// hbOړAmndlImg̎c߂
				g.setColor(backColor);
				int sx, ex, sy, ey;
				if (newPoint.x >= 0) {
					sx = 0;
					ex = newPoint.x;
					sy = 0;
					ey = mndlImg.getHeight();
				} else {
					sx = mndlImg.getWidth() + newPoint.x;
					ex = mndlImg.getWidth();
					sy = 0;
					ey = mndlImg.getHeight();
				}
				g.fillRect(sx, sy,ex,ey);
				if (newPoint.y >= 0) {
					sy = 0;
					ey = newPoint.y;
				} else {
					sy = mndlImg.getHeight() + newPoint.y;
					ey = mndlImg.getHeight();
				}
				if (newPoint.x >= 0) {
					sx = newPoint.x;
					ex = mndlImg.getWidth();
				} else {
					sx = 0;
					ex = mndlImg.getWidth() + newPoint.x;
				}
				g.fillRect(sx, sy,ex,ey);
			}
			g.drawImage(mndlImg.image,newPoint.x,newPoint.y, this);
		}
	}

	////////// Listenerւ̏
	private ArrayList<MandelbrotListener> listeners = new ArrayList<MandelbrotListener>();

	public synchronized void addMandelbrotListener(MandelbrotListener listener) {
		listeners.add(listener);
	}

	public synchronized void removeMandelbrotListener(MandelbrotListener listener) {
		listeners.remove(listener);
	}

	public void sendActionEvent(MandelbrotEvent evt) {
		ArrayList l;
		synchronized (listeners) {
			l = (ArrayList) listeners.clone();
		}		
		for(Iterator it=l.iterator();it.hasNext(); ){
			((MandelbrotListener) it.next()).regionUpdate(evt);
		}
	}



}
