package mandelbrotExplorer;

import javax.swing.JFrame;


public final class MandelbrotExplorer extends JFrame {
	private static final long serialVersionUID = 1L;
	private Mandelbrot mandel;
	private MandelbrotExplorer me;
	
	public MandelbrotExplorer(){
		me = this;
		
		double rLeft,rRight,iTop,iBottom;
		rLeft=-2.0; rRight=0.5; iTop=1.25; iBottom=-1.25;
		//rLeft=-1.255;rRight=-1.253;iTop=0.0237;iBottom=0.0257;
		mandel = new Mandelbrot(rLeft, rRight, iTop, iBottom);
		

		mandel.addMandelbrotListener(new MandelbrotAdapter(){
			public void regionUpdate(MandelbrotEvent e){
				me.setTitle(e.toString());
			}
		});

		this.add(mandel);
		this.setResizable(true);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		this.setSize(600+8,600+27);
		this.setVisible(true);

		/*
		new Thread(new Runnable(){
			public void run(){
				try {
					double rLeft,rRight,iTop,iBottom;
					Thread.sleep(10000);
					
					rLeft=-0.973;rRight=-0.968;iTop=-0.253;iBottom=-0.248;
					mandel.setNewRegion(rLeft, rRight, iTop, iBottom);
					Thread.sleep(10000);

					rLeft=0.2622;rRight=0.2627;iTop=-0.002;iBottom=-0.0025;
					mandel.setNewRegion(rLeft, rRight, iTop, iBottom);
					Thread.sleep(10000);

					rLeft=-1.255;rRight=-1.253;iTop=0.0237;iBottom=0.0257;
					mandel.setNewRegion(rLeft, rRight, iTop, iBottom);
					Thread.sleep(10000);

					rLeft=-1.255;rRight=-1.2545; iTop=0.0252; iBottom=0.0257;
					mandel.setNewRegion(rLeft, rRight, iTop, iBottom);
					
				} catch (InterruptedException e) {
				}
			}
		}).start();
		*/
	}
	
	public static void main(String[] args) {
		new MandelbrotExplorer();
	}
	
}

