package mandelbrotExplorer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;

public class MandelbrotImage {
	private static final long serialVersionUID = 1L;
	private MandelbrotSet mandel;
	private Component imageObserver;
	protected BufferedImage image;
	private ArrayList<MandelbrotDrawing> drawingThread;

	public MandelbrotImage(Component imageObserver) {
		this.imageObserver = imageObserver;
		this.drawingThread = new ArrayList<MandelbrotDrawing>();
	}

	public int getWidth(){
		synchronized (image) {
			return image.getWidth();
		}		
	}

	public int getHeight(){
		synchronized (image) {
			return image.getHeight();
		}		
	}

	public boolean imageIsNull(){
		if (image == null) { 
			return true;
		} else {
			return false;
		}
	}
	
	protected void paintImageThread(MandelbrotDrawing md){
		synchronized (image) {
			image.createGraphics().drawImage(md.getImage(), null,
					md.getOffset().x, md.getOffset().y);
		}		
		this.imageObserver.repaint();
		drawingThread.remove(md);
	}
	
	public void createNewImage(int w,int h,double rLeft,double rRight,double iTop,double iBottom){
		image = new BufferedImage(w,h, BufferedImage.TYPE_INT_BGR);
		mandel = new MandelbrotSet( w , h , rLeft, rRight, iTop, iBottom);
	}
	
	public void drawAll(){
		if( this.imageIsNull() || mandel==null ){ return; }// ExceptionthrowׂH
		this.addDrawingThread(mandel , 0, 0, this.getWidth(), this.getHeight());
		this.startNewDrawing();
	}
	
	public String toString(){
		double rLeft = mandel.getLeft();
		double rRight= mandel.getLeft()+this.getWidth()*mandel.getScaleR();
		double iTop  = mandel.getTop();
		double iBottom=mandel.getTop()+this.getHeight()*mandel.getScaleI();

		return String.format("}fu[W ͈́i%3.10g`%3.10g) ",rLeft,rRight)
		+String.format("͈́i%3.10g`%3.10g)",iBottom,iTop);
	}

	///////////////// gAk
	public void changeMagnification(int z){
		if( this.isBusyDrawing() ){ return; }
		
		double zoomRate = 1.5;
		Point2D.Double p = new Point2D.Double(
					mandel.getLeft()+(double)getWidth()/2.0*mandel.getScaleR()
					,mandel.getTop()+(double)getHeight()/2.0*mandel.getScaleI());
		Point2D.Double leftTop;
		if( z > 0){	// g
			leftTop = new Point2D.Double(
					p.getX()-((double)getWidth()*mandel.getScaleR()/zoomRate)/2.0
					,p.getY()-((double)getHeight()*mandel.getScaleI()/zoomRate)/2.0  );
			mandel = new MandelbrotSet(leftTop
					,mandel.getScaleR()/zoomRate,mandel.getScaleI()/zoomRate);
			//  gimage\
			BufferedImage bi = new BufferedImage( (int)((double)getWidth()*zoomRate),(int)((double)getHeight()*zoomRate), BufferedImage.TYPE_INT_BGR);
			AffineTransformOp ato = new AffineTransformOp(
					AffineTransform.getScaleInstance(zoomRate,zoomRate)
					,null);
			synchronized (image) {
				ato.filter(image,bi);
				Graphics2D g = image.createGraphics();
				g.setColor(new Color(0,0,0));
				g.fillRect(0, 0, image.getWidth(), image.getHeight());
				g.drawImage(bi, null, -(bi.getWidth()/2-image.getWidth()/2), -(bi.getHeight()/2-image.getHeight()/2));
			}
			this.imageObserver.repaint();
		}else{		// k
			leftTop = new Point2D.Double(
					p.getX()-((double)getWidth()*mandel.getScaleR()*zoomRate)/2.0
					,p.getY()-((double)getHeight()*mandel.getScaleI()*zoomRate)/2.0  );
			mandel = new MandelbrotSet(leftTop
					,mandel.getScaleR()*zoomRate,mandel.getScaleI()*zoomRate);
			//	kimage\
			BufferedImage bi = new BufferedImage((int)((double)getWidth()/zoomRate),(int)((double)getHeight()/zoomRate), BufferedImage.TYPE_INT_BGR);
			AffineTransformOp ato = new AffineTransformOp(
					AffineTransform.getScaleInstance(1.0/zoomRate,1.0/zoomRate)
					,null);
			synchronized (image) {
				ato.filter(image,bi);
				Graphics2D g = image.createGraphics();
				g.setColor(new Color(0,0,0));
				g.fillRect(0, 0, image.getWidth(), image.getHeight());
				g.drawImage(bi, null, image.getWidth()/2-bi.getWidth()/2, image.getHeight()/2-bi.getHeight()/2);
			}
			this.imageObserver.repaint();
		}
		this.drawAll();
	}
	
	////////////////////////// ړ
	public void translate(Point distance){
		this.translate( distance.x , distance.y );
	}

	public void translate(int dx,int dy){
		//if( this.isBusyDrawing() ){ return; }
		
		// ÂmandelbrotSetړVmandelbrotSet
		Point2D.Double leftTop = new Point2D.Double(mandel.getLeft()-(double)dx*mandel.getScaleR()
											, mandel.getTop()-(double)dy*mandel.getScaleI());
		mandel = new MandelbrotSet(leftTop , mandel.getScaleR() , mandel.getScaleI());
		
		synchronized (image) {
			// imagẻ摜炷AhbOł炵炷A
			// hbOɂČ̂́A݂AŎۂɂ炷B
			BufferedImage bc = new BufferedImage(image.getWidth()
					, image.getHeight(), BufferedImage.TYPE_INT_BGR);
			bc.createGraphics().drawImage(image, null, dx, dy);
			image.createGraphics().drawImage(bc, null ,0, 0);
			
			//@܂IdrawingThreadAɑ΂ĉʂꂽƂm点
			for(Iterator<MandelbrotDrawing> it = drawingThread.iterator();it.hasNext(); ){
				MandelbrotDrawing th = it.next();
				if( th.getState()!=Thread.State.TERMINATED ){
					th.moveOffset(new Point(dx,dy));
				}
			}
		}			
		imageObserver.repaint();

		// ړʐVɌ̈ɑ΂addDrawingThread()Ă`threadJn
		int sx, ex, sy, ey;
		if (dx >= 0) {
			sx = 0;
			ex = dx;
			sy = 0;
			ey = image.getHeight();
		} else {
			sx = image.getWidth() + dx;
			ex = image.getWidth();
			sy = 0;
			ey = image.getHeight();
		}
		this.addDrawingThread(mandel , sx, sy, ex, ey);
		if (dy >= 0) {
			sy = 0;
			ey = dy;
		} else {
			sy = image.getHeight() + dy;
			ey = image.getHeight();
		}
		if (dx >= 0) {
			sx = dx;
			ex = image.getWidth();
		} else {
			sx = 0;
			ex = image.getWidth() + dx;
		}
		this.addDrawingThread(mandel , sx, sy, ex, ey);

		this.startNewDrawing();
	}

	//////////////////////////resize
	public void setSize(int w,int h){
		int oldWidth,oldHeight;
		oldWidth = image.getWidth();
		oldHeight = image.getHeight();

		//***************ÂimagêĂĐVTCYimage
		synchronized (image) {
			BufferedImage bi = new BufferedImage(image.getWidth(),image.getHeight(), BufferedImage.TYPE_INT_BGR); 
			bi.createGraphics().drawImage(image, null, 0, 0);
			image = new BufferedImage(w, h, BufferedImage.TYPE_INT_BGR);
			image.createGraphics().drawImage(bi,null, 0, 0 );
		}
		imageObserver.repaint();

		// resizeʐVɌ̈ɑ΂addDrawingThread()Ă`threadJn
		int sx,ex,sy,ey;
		if( oldWidth<image.getWidth() ){
			sx = oldWidth;
			ex = image.getWidth();
			sy = 0;
			ey = image.getHeight();
			this.addDrawingThread(mandel , sx, sy, ex, ey);
		}
		if( oldHeight<image.getHeight() ){
			if( oldWidth<image.getWidth() ){
				sx = 0;
				ex = oldWidth;
			}else{
				sx = 0;
				ex = image.getWidth();
			}
			sy = oldHeight;
			ey = image.getHeight();
			this.addDrawingThread(mandel , sx, sy, ex, ey);
		}

		this.startNewDrawing();

	}

	////////////////////////// `ThreadList֌W
	public void addDrawingThread(final MandelbrotSet ms
						,final int sx,final int sy,final int ex,final int ey){
		drawingThread.add( 
				new MandelbrotDrawing(ms,new Rectangle(sx,sy,ex-sx,ey-sy),this)
		);
	}

	public void startNewDrawing(){
		for(Iterator<MandelbrotDrawing> it = drawingThread.iterator();it.hasNext(); ){
			MandelbrotDrawing th = it.next();
			if( th.getState()==Thread.State.NEW ){
				th.start();
			}
		}
	}

	public boolean isBusyDrawing(){
		for(Iterator<MandelbrotDrawing> it = drawingThread.iterator();it.hasNext(); ){
			if( it.next().getState() != Thread.State.TERMINATED ){
				return true;
			}
		}
		return false;
	}

	public void newDrawingThread(){
		this.drawingThread = new ArrayList<MandelbrotDrawing>();
	}

}