package mandelbrotExplorer;

import java.awt.geom.Point2D;

public class MandelbrotSet {

	private double scaleR,scaleI;
	private Point2D.Double leftTop;

	public  MandelbrotSet(int width,int height
			,double r_left,double r_right,double i_top,double i_bottom){

		this.scaleR = (r_right-r_left)/(double)width;
		this.scaleI = (i_bottom-i_top)/(double)height;

		leftTop = new Point2D.Double(r_left,i_top);
	}
	
	public MandelbrotSet(Point2D.Double leftTop,double scaleR,double scaleI){
		this.leftTop = new Point2D.Double(leftTop.x,leftTop.y);
		this.scaleR = scaleR;
		this.scaleI = scaleI;
		
	}
	
	public double getLeft(){
		return leftTop.getX();
	}

	public double getTop(){
		return leftTop.getY();
	}

	public double getScaleI() {
		return scaleI;
	}


	public double getScaleR() {
		return scaleR;
	}

	public int calcMandel(int r,int i,int max_count){
		return calcMandel(leftTop.getX()+r*scaleR , leftTop.getY()+i*scaleI ,max_count);
	}

	public int calcMandel(final double cr,final double ci,final int max_count){
		double r,i;
		double rr,ii;
		int n;

		r=0.0;
		i=0.0;
		rr = 0.0;
		ii = 0.0;
		for(n=0;n<=max_count;++n){
			i=(2.0*r*i)+ci;
			r=rr-ii+cr;
			rr=r*r;
			ii=i*i;
			if( (rr+ii)>4.0 ) return n;
		}
		return -1;
	}

}
