package mandelbrotExplorer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;

import javax.swing.JComponent;

@SuppressWarnings("serial")
public class Mandelbrot extends JComponent {
	private static final long serialVersionUID = 1L;
	private MandelbrotImage mndlImg = null;
	private boolean isDragging = false ;
	private Color backColor;
	private Mandelbrot mandelbrot;
	private Point distance,lastPoint,newPoint;
	private Rectangle2D.Double firstRegion;
	
	public Mandelbrot(){
		this.init();
	}
	
	public Mandelbrot(Rectangle2D.Double r){
		this.firstRegion = new Rectangle2D.Double(r.x , r.y , r.width , r.height);
		this.init();
	}

	private void init(){
		mandelbrot = this;
		
		this.setPreferredSize(new Dimension(480,480));
		
		distance = new Point(0,0);
		newPoint = new Point(0,0);
		lastPoint = new Point(0,0);
		backColor = new Color(255,255,0);

		mndlImg = new MandelbrotImage(this);
		
		this.addMouseMotionListener(new MouseMotionAdapter(){
			public void mouseDragged(MouseEvent e) {
				if( mndlImg==null || mandelbrot==null){ return; }
				isDragging  = true;
				newPoint.move(e.getX()-lastPoint.x, e.getY()-lastPoint.y);
				mandelbrot.repaint();
			}

			public void mouseMoved(MouseEvent e) {
				lastPoint = e.getPoint().getLocation();
			}
		});

		this.addMouseListener(new MouseAdapter(){
			public void mouseReleased(MouseEvent e) {
				if( mndlImg==null || mandelbrot==null){ return; }
				isDragging = false;
				distance.setLocation(e.getX()-lastPoint.x, e.getY()-lastPoint.y);
				lastPoint = (Point) e.getPoint().getLocation().clone();
				newPoint.move(0,0);

				if( distance.x!=0 || distance.y!=0 ){
					mndlImg.translate( distance );
				}
			}
		});


		this.addComponentListener(new ComponentAdapter(){
			public void componentResized(ComponentEvent e) {
				if( mndlImg==null || mandelbrot==null){ return; }
				if( mndlImg.imageIsNull() ){// ŏComponentSize肳ꂽꍇ
					if( firstRegion!=null ){
						mndlImg.createNewImage(e.getComponent().getWidth(),e.getComponent().getHeight()	, firstRegion);
						mndlImg.drawAll();
					}
				}else{						// ʏSizeύX̏ꍇ
					if( mndlImg.getWidth()!=mandelbrot.getSize().width
							|| mndlImg.getHeight()!=mandelbrot.getSize().height ){

						mndlImg.setSize(mandelbrot.getSize().width, mandelbrot.getSize().height);

					}
				}
			}
		});
		
		this.addMouseWheelListener(new MouseWheelListener(){
			public void mouseWheelMoved(MouseWheelEvent e){
				if( mndlImg==null || mandelbrot==null){ return; }
				mndlImg.changeMagnification(-e.getWheelRotation());
			}
		});

	}

	public void setMandelbrotSet(MandelbrotSet m){
		if( !mndlImg.imageIsNull() ){
			mndlImg.createNewImage(mndlImg.getWidth(),mndlImg.getHeight(), m);
			mndlImg.drawAll();
		}
	}

	public void setRegion(Rectangle2D.Double r){
		if( !mndlImg.imageIsNull() ){
			MandelbrotSet m = new MandelbrotSet(new Point2D.Double(r.x,r.y) , r.width , r.height );
			mndlImg.createNewImage(mndlImg.getWidth(),mndlImg.getHeight(), m );
			mndlImg.drawAll();
		}
	}
	
	public MandelbrotSet getMandelbrotSet(){
		return mndlImg.getMandelbrotSet();
	}
	
	public Rectangle2D.Double getRegion(){
		return mndlImg.getRegion();
	}
	
	public void paintComponent(Graphics g){
		super.paintComponent(g);
		if( !mndlImg.imageIsNull() ){
			if( isDragging ){
				// hbOړAmndlImg̎c߂
				g.setColor(backColor);
				int sx, ex, sy, ey;
				if (newPoint.x >= 0) {
					sx = 0;
					ex = newPoint.x;
					sy = 0;
					ey = mndlImg.getHeight();
				} else {
					sx = mndlImg.getWidth() + newPoint.x;
					ex = mndlImg.getWidth();
					sy = 0;
					ey = mndlImg.getHeight();
				}
				g.fillRect(sx, sy,ex,ey);
				if (newPoint.y >= 0) {
					sy = 0;
					ey = newPoint.y;
				} else {
					sy = mndlImg.getHeight() + newPoint.y;
					ey = mndlImg.getHeight();
				}
				if (newPoint.x >= 0) {
					sx = newPoint.x;
					ex = mndlImg.getWidth();
				} else {
					sx = 0;
					ex = mndlImg.getWidth() + newPoint.x;
				}
				g.fillRect(sx, sy,ex,ey);
			}
			mndlImg.drawGraphics(g, newPoint,this );
		}
	}

	////////// Listenerւ̏
	private ArrayList<MandelbrotListener> listeners = new ArrayList<MandelbrotListener>();

	public synchronized void addMandelbrotListener(MandelbrotListener listener) {
		listeners.add(listener);
	}

	public synchronized void removeMandelbrotListener(MandelbrotListener listener) {
		listeners.remove(listener);
	}

	@SuppressWarnings("serial")
	protected void sendRegionUpdate(){
		sendRegionUpdateEvent(new MandelbrotEvent(mndlImg.toString()){
		});
	}
	
	public void sendRegionUpdateEvent(MandelbrotEvent evt) {
		ArrayList l;
		synchronized (listeners) {
			l = (ArrayList) listeners.clone();
		}		
		for(Iterator it=l.iterator();it.hasNext(); ){
			((MandelbrotListener) it.next()).regionUpdate(evt);
		}
	}


	/*
	 * 
	 * Ql
	 * utN^bfRNVvAFGGAsFTCGX
	 * ubɂASYTvAFFAsFZp]_
	 * 
	 */

}
