package mandelbrotExplorer;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.Rectangle2D;
import java.util.prefs.Preferences;

import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSplitPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

@SuppressWarnings("serial")
public final class MandelbrotExplorer extends JFrame implements WindowListener{
	private Mandelbrot mandel;
	private MandelbrotExplorer me;
	private JSplitPane jsp;
	private HistoryTree ht;
	private JCheckBoxMenuItem viewHistory;
	private int dividerPos;
	
	
	private Preferences pref = null;
	private static final String FRAME_POS_X = "frame_pos_x";
	private static final String FRAME_POS_Y = "frame_pos_y";
	private static final String FRAME_WIDTH = "frame_width";
	private static final String FRAME_HEIGHT = "frame_height";
	private static final String DIVIDER_POS = "divider_pos";
	private static final String VIEW_HISTIRY = "view_history";
	
	public MandelbrotExplorer()  {
		me = this;
		
		//-----------------------------------------------------
		JMenuBar menuBar = new JMenuBar();
		JMenu fileMenu = new JMenu("t@C");
		JMenuItem fileExitItem = new JMenuItem("I");
		fileExitItem.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				System.exit(0); // ̏I̎dHRuntimeExceptionH
			}
		});
		fileMenu.add(fileExitItem);
		
		menuBar.add(fileMenu);
		//-----------------------------------------------------
		JMenu viewMenu = new JMenu("\");
		viewHistory = new JCheckBoxMenuItem("",true);
		viewMenu.add(viewHistory);
		viewHistory.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				if( viewHistory.getState()==true ){
					jsp.setDividerLocation(me.dividerPos);
					ht.setVisible(true);
				}else{
					me.dividerPos = jsp.getDividerLocation();
					jsp.setDividerLocation(0);
					ht.setVisible(false);
				}
			}
		});
		//-----------------------------------------------------
		/*
		JMenuItem optionItem = new JMenuItem("ݒ");
		viewMenu.add(optionItem);
		optionItem.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				
			}
		});
		*/		
		
		menuBar.add(viewMenu);

		this.setJMenuBar(menuBar);
		//-----------------------------------------------------
		jsp = new JSplitPane();
		this.getContentPane().add(jsp);
		//--------------------------------
		mandel = new Mandelbrot(new Rectangle2D.Double(-2.0 , -1.25 , 2.5 ,2.5) , 1.0 );
		mandel.addMandelbrotListener(new MandelbrotAdapter(){
			public void regionUpdate(MandelbrotEvent e){
				me.setTitle(e.toString());
				ht.addRow(mandel.getMandelbrotSet());
			}
		});
		jsp.setRightComponent(mandel);
		//-----------------------------------------------------

        ht = new HistoryTree(mandel);
        ht.setPreferredSize(new Dimension(300,mandel.getPreferredSize().height));
        
		jsp.setLeftComponent(ht);
		//-----------------------------------------------------
		
		pref =Preferences.userRoot().node("/jp/sourceforge/mandelbrot");
        int x,y,w,h;
        boolean history;
        
        x = pref.getInt(FRAME_POS_X, 0);
        y = pref.getInt(FRAME_POS_Y, 0);
        w = pref.getInt(FRAME_WIDTH, mandel.getPreferredSize().width+ht.getPreferredSize().width);
        h = pref.getInt(FRAME_HEIGHT, mandel.getPreferredSize().height);
        dividerPos = pref.getInt(DIVIDER_POS, 300);
        history = pref.getBoolean(VIEW_HISTIRY, true);
        viewHistory.setSelected(!history);
        viewHistory.doClick();
        
		this.addWindowListener(this);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		this.setResizable(true);
		this.setSize(w, h);
		this.setLocation(x, y);
		//this.pack();
		jsp.setDividerLocation(dividerPos);
		this.setVisible(true);
		
		/*
		new Thread(new Runnable(){
			public void run(){
				try {
					double rLeft,rRight,iTop,iBottom;
					Thread.sleep(10000);
					
					rLeft=-0.973;rRight=-0.968;iTop=-0.253;iBottom=-0.248;
					mandel.setRegion(new Rectangle2D.Double(rLeft , iTop , rRight-rLeft , iBottom-iTop));
					Thread.sleep(10000);

					rLeft=0.2622;rRight=0.2627;iTop=-0.002;iBottom=-0.0025;
					mandel.setRegion(new Rectangle2D.Double(rLeft , iTop , rRight-rLeft , iBottom-iTop));
					Thread.sleep(10000);

					rLeft=-1.255;rRight=-1.253;iTop=0.0237;iBottom=0.0257;
					mandel.setRegion(new Rectangle2D.Double(rLeft , iTop , rRight-rLeft , iBottom-iTop));
					Thread.sleep(10000);

					rLeft=-1.255;rRight=-1.2545; iTop=0.0252; iBottom=0.0257;
					mandel.setRegion(new Rectangle2D.Double(rLeft , iTop , rRight-rLeft , iBottom-iTop));
					
				} catch (InterruptedException e) {
				}
			}
		}).start();
		*/
	}
	
	public static void main(String[] args) {
		new MandelbrotExplorer();
	}

	public void windowClosing(WindowEvent e) {
		pref.putInt(FRAME_POS_X, this.getLocation().x);
		pref.putInt(FRAME_POS_Y, this.getLocation().y);
		pref.putInt(FRAME_WIDTH, this.getSize().width);
		pref.putInt(FRAME_HEIGHT, this.getSize().height);
		if( viewHistory.getState() ){ dividerPos = jsp.getDividerLocation(); }
		pref.putInt(DIVIDER_POS, dividerPos);
		pref.putBoolean(VIEW_HISTIRY, viewHistory.getState());
	}
		 
	public void windowActivated(WindowEvent e) {
		// TODO ꂽ\bhEX^u
		
	}

	public void windowClosed(WindowEvent e) {
		// TODO ꂽ\bhEX^u
		
	}

	public void windowDeactivated(WindowEvent e) {
		// TODO ꂽ\bhEX^u
		
	}

	public void windowDeiconified(WindowEvent e) {
		// TODO ꂽ\bhEX^u
		
	}

	public void windowIconified(WindowEvent e) {
		// TODO ꂽ\bhEX^u
		
	}

	public void windowOpened(WindowEvent e) {
		// TODO ꂽ\bhEX^u
		
	}
	
	/*
	 * 
	 * Ql
	 * utN^bfRNVvAFGGAsFTCGX
	 * ubɂASYTvAFFAsFZp]_
	 * 
	 */
}

