package mandelbrotExplorer;

import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

@SuppressWarnings("serial")
public class HistoryTree extends JScrollPane  {
	private JTree tree;
	private DefaultTreeModel tm;

	private Mandelbrot mandel;

	public HistoryTree(final Mandelbrot m){

		this.mandel = m;
		
		DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("history");
		tm = new DefaultTreeModel(rootNode);
		
		tree = new JTree(tm);
		tree.setEditable(false);
		tree.setExpandsSelectedPaths(true);
		MandelbrotTreeCellRenderer mcr = new MandelbrotTreeCellRenderer();
		tree.setCellRenderer(mcr);
		this.getViewport().add(tree,null);
		//----------------------------------------------
		tree.addTreeSelectionListener(new TreeSelectionListener(){
			public void valueChanged(TreeSelectionEvent e) {
				TreePath selectPath = e.getPath();
				if( selectPath!=null ){
					DefaultMutableTreeNode node=(DefaultMutableTreeNode)selectPath.getLastPathComponent();
					MandelbrotSet m = (MandelbrotSet)node.getUserObject();
					if( !mandel.getMandelbrotSet().equals(m) ){
						mandel.setMandelbrotSet(m);
					}
				}
			}
		});
	}

	public synchronized void addRow(final MandelbrotSet m ){
		
		if( ((DefaultMutableTreeNode)tm.getRoot()).getUserObject().getClass()!=MandelbrotSet.class ){
			// ŏaddRowłrootNodeMandelbrotSet
			((DefaultMutableTreeNode)tm.getRoot()).setUserObject(m);
			tm.reload();
			return;
		}
		DefaultMutableTreeNode newNode=new DefaultMutableTreeNode(m);
		TreePath selectPath = tree.getSelectionPath();
		if( selectPath!=null ){
			DefaultMutableTreeNode node=(DefaultMutableTreeNode)selectPath.getLastPathComponent();
			DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node.getParent();
			if( parentNode.getChildAfter(node)==null ){
				// ԉ̎qIĂꍇ
				if( ! ((MandelbrotSet)parentNode.getUserObject()).equals(m) 
						&& !((MandelbrotSet)node.getUserObject()).equals(m) ){
					tm.insertNodeInto(newNode,parentNode,parentNode.getChildCount());
					// ǉnewNodeI
					tree.setSelectionPath(new TreePath(tm.getPathToRoot(newNode)));
					// ǉnewNode悤autoScroll
					tree.scrollPathToVisible(new TreePath(tm.getPathToRoot(newNode)));
					this.repaint(); // ȂƁAIEłJAppletŏJTree̕\ꂽBiFireFoxł́AꂪĂȂj
				}
			}else{
				if( node.getChildCount()>0 ){
					// łɎqnodeIĂꍇAInode𕪊nodeƂČ@艺
					if( ! ((MandelbrotSet)node.getUserObject()).equals(m) ){ 
						tm.insertNodeInto(newNode,node,0);
						// ǉnewNodeI
						tree.setSelectionPath(new TreePath(tm.getPathToRoot(newNode)));
						// ǉnewNode悤autoScroll
						tree.scrollPathToVisible(new TreePath(tm.getPathToRoot(newNode)));
						this.repaint(); // ȂƁAIEłJAppletŏJTree̕\ꂽBiFireFoxł́AꂪĂȂj
					}
				}else{
					// qȂnodeIĂꍇ
					if( ! ((MandelbrotSet)node.getUserObject()).equals(m) ){
						tm.insertNodeInto(newNode,node,node.getChildCount());
						// ǉnewNodeI
						tree.setSelectionPath(new TreePath(tm.getPathToRoot(newNode)));
						// ǉnewNode悤autoScroll
						tree.scrollPathToVisible(new TreePath(tm.getPathToRoot(newNode)));
						this.repaint(); // ȂƁAIEłJAppletŏJTree̕\ꂽBiFireFoxł́AꂪĂȂj
					}
				}

			}
		}else{
			// IĂȂBiNj
			tm.insertNodeInto(newNode,((DefaultMutableTreeNode)tm.getRoot()),0);
			// ǉnewNodeI
			tree.setSelectionPath(new TreePath(tm.getPathToRoot(newNode)));
		}
		
		/*
		MandelbrotSet parentMandel,lastMandel=null;
		parentMandel = (MandelbrotSet)(currentParentNode.getUserObject());
		if( currentParentNode.getChildCount()>0 ){
			lastMandel = (MandelbrotSet)((DefaultMutableTreeNode)currentParentNode.getLastChild()).getUserObject();
		}
		//DebugThread.printf("addRow:parent:%s\n",parentMandel);
		if( currentParentNode.getChildCount()!=0 || !parentMandel.equals(m) ){
			//@PԖڂ̎qɐeƓf[^ǉȂi[U[IŎqĂ܂̂hj
			if( true ){
				if( lastMandel==null || !lastMandel.equals(m) ){	// NodeƓf[^͒ǉȂ
					tm.insertNodeInto(newNode,currentParentNode,currentParentNode.getChildCount());

					// ǉnewNodeI
					tree.setSelectionPath(new TreePath(tm.getPathToRoot(newNode)));
					// ǉnewNode悤autoScroll
					tree.scrollPathToVisible(new TreePath(tm.getPathToRoot(newNode)));
					this.repaint(); // ȂƁAIEłJAppletŏJTree̕\ꂽBiFireFoxł́AꂪĂȂj
				}
			}
		}
		*/
	}

}
