package mandelbrotExplorer;

import java.awt.Rectangle;
import java.awt.image.WritableRaster;

public class ImagePiece {
	private final WritableRaster image;
	private final Rectangle rect;
	
	public ImagePiece(WritableRaster image,Rectangle rect){
		this.image = image;
		this.rect = new Rectangle(rect);
	}

	public WritableRaster getImage(){
		return image;
	}

	public Rectangle getRect(){
		return new Rectangle(rect);
	}
	
	public String toString(){
		return String.format("(X,Y)=(%d,%d):(w,h)=(%d,%d)",rect.x,rect.y,rect.width,rect.height);
	}

}
