package mandelbrotExplorer;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

@SuppressWarnings("serial")
public class MandelbrotTreeCellRenderer extends DefaultTreeCellRenderer {
	
	public Component getTreeCellRendererComponent(JTree t, Object o, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
		JLabel sl = (JLabel) super.getTreeCellRendererComponent( t,  o,  selected,  expanded,  leaf,  row,  hasFocus);
		
		DefaultMutableTreeNode tn = (DefaultMutableTreeNode)o;
		if( tn.getUserObject().getClass()==MandelbrotSet.class ){
			//@iconpsmallImageɁA1pixel̘gāAsl(JLabel)iconƂB
			BufferedImage si = ((MandelbrotSet)(tn.getUserObject())).getSmallImage();
			if( si!=null ){
				BufferedImage bi = new BufferedImage(si.getWidth()+2,si.getHeight()+2, BufferedImage.TYPE_INT_BGR);
				Graphics2D g = bi.createGraphics();
				g.drawImage(si, null, 1, 1);
				g.setColor(this.getBackground());
				g.drawRect(0, 0, bi.getWidth(), bi.getHeight());
				sl.setIcon( new ImageIcon( bi ) );
			}
		}
		return sl;
	}

}
