
/* Drop Tables */

DROP TABLE IF EXISTS MNJ_CTXT;
DROP TABLE IF EXISTS MNJ_CTXT_ITEM;
DROP TABLE IF EXISTS MNJ_KWD;
DROP TABLE IF EXISTS MNJ_MURMUR;
DROP TABLE IF EXISTS MNJ_REL_MURMUR_CTXT;
DROP TABLE IF EXISTS MNJ_USER;




/* Create Tables */

CREATE TABLE MNJ_CTXT
(
	CTXT_ID INT NOT NULL,
	VALID_FLG BOOLEAN DEFAULT 'true' NOT NULL,
	LOCALE_ID INT DEFAULT 47 NOT NULL,
	-- 1:target kwd
	-- 0:non keyword
	KWD_ID INT NOT NULL,
	CTXT_ENDPOINT_LEVEL INT NOT NULL,
	-- Small value is high priority.
	SORT_PRIORITY INT DEFAULT 10000 NOT NULL,
	OWNER_USER_ID INT NOT NULL,
	UPD_DT TIMESTAMP NOT NULL,
	UPD_USER_ID INT NOT NULL,
	PRIMARY KEY (CTXT_ID)
) WITHOUT OIDS;


CREATE TABLE MNJ_CTXT_ITEM
(
	CTXT_ID INT NOT NULL,
	CTXT_LEVEL INT NOT NULL,
	-- 1:target kwd
	-- 0:non keyword
	KWD_ID INT NOT NULL,
	UPD_DT TIMESTAMP NOT NULL,
	UPD_USER_ID INT NOT NULL,
	PRIMARY KEY (CTXT_ID, CTXT_LEVEL)
) WITHOUT OIDS;


CREATE TABLE MNJ_KWD
(
	-- 1:target kwd
	-- 0:non keyword
	KWD_ID INT NOT NULL UNIQUE,
	VALID_FLG BOOLEAN DEFAULT 'true' NOT NULL,
	LOCALE_ID INT DEFAULT 0 NOT NULL,
	KWD_NAME VARCHAR(254) NOT NULL UNIQUE,
	KWD_NAME_NORMAL VARCHAR(254) NOT NULL,
	OWNER_USER_ID INT NOT NULL,
	UPD_DT TIMESTAMP NOT NULL,
	UPD_USER_ID INT NOT NULL,
	PRIMARY KEY (KWD_ID)
) WITHOUT OIDS;


CREATE TABLE MNJ_MURMUR
(
	MURMUR_ID INT NOT NULL,
	VALID_FLG BOOLEAN DEFAULT 'true' NOT NULL,
	LOCALE_ID INT DEFAULT 47 NOT NULL,
	-- 1:plain text
	-- 2:url
	-- 3:wiki
	MURMUR_TYPE INT DEFAULT 1 NOT NULL,
	MURMUR_TITLE VARCHAR(254) NOT NULL,
	MURMUR_VALUE VARCHAR(254) NOT NULL,
	-- 0:none
	-- 
	REFER_MURMUR_ID INT DEFAULT 0 NOT NULL,
	OWNER_USER_ID INT NOT NULL,
	UPD_DT TIMESTAMP NOT NULL,
	UPD_USER_ID INT NOT NULL,
	PRIMARY KEY (MURMUR_ID)
) WITHOUT OIDS;


CREATE TABLE MNJ_REL_MURMUR_CTXT
(
	MURMUR_ID INT NOT NULL,
	CTXT_ID INT NOT NULL,
	OWNER_USER_ID INT NOT NULL,
	-- Small value is high priority.
	SORT_PRIORITY INT DEFAULT 10000 NOT NULL,
	VALID_FLG BOOLEAN DEFAULT 'true' NOT NULL,
	UPD_DT TIMESTAMP NOT NULL,
	UPD_USER_ID INT NOT NULL,
	PRIMARY KEY (MURMUR_ID, CTXT_ID, OWNER_USER_ID)
) WITHOUT OIDS;


CREATE TABLE MNJ_USER
(
	-- 0:Anonymous
	-- 1:ToshikiIga
	USER_ID INT NOT NULL,
	VALID_FLG BOOLEAN DEFAULT 'true' NOT NULL,
	USER_CD VARCHAR(254) NOT NULL UNIQUE,
	DEFAULT_LOCALE_ID INT DEFAULT 47 NOT NULL,
	USER_PASSWD VARCHAR(254) NOT NULL,
	USER_FLG_ADMIN BOOLEAN DEFAULT 'false' NOT NULL,
	USER_FLG_EDITOR_KWD BOOLEAN DEFAULT 'false' NOT NULL,
	USER_FLG_EDITOR_MURMUR BOOLEAN DEFAULT 'false' NOT NULL,
	UPD_DT TIMESTAMP NOT NULL,
	UPD_USER_ID INT NOT NULL,
	PRIMARY KEY (USER_ID)
) WITHOUT OIDS;



/* Comments */

COMMENT ON COLUMN MNJ_CTXT.KWD_ID IS '1:target kwd
0:non keyword';
COMMENT ON COLUMN MNJ_CTXT.SORT_PRIORITY IS 'Small value is high priority.';
COMMENT ON COLUMN MNJ_CTXT_ITEM.KWD_ID IS '1:target kwd
0:non keyword';
COMMENT ON COLUMN MNJ_KWD.KWD_ID IS '1:target kwd
0:non keyword';
COMMENT ON COLUMN MNJ_MURMUR.MURMUR_TYPE IS '1:plain text
2:url
3:wiki';
COMMENT ON COLUMN MNJ_MURMUR.REFER_MURMUR_ID IS '0:none
';
COMMENT ON COLUMN MNJ_REL_MURMUR_CTXT.SORT_PRIORITY IS 'Small value is high priority.';
COMMENT ON COLUMN MNJ_USER.USER_ID IS '0:Anonymous
1:ToshikiIga';



