
/* Drop Tables */

DROP TABLE IF EXISTS MNJ_CTXT;
DROP TABLE IF EXISTS MNJ_CTXT_ITEM;
DROP TABLE IF EXISTS MNJ_KWD;
DROP TABLE IF EXISTS MNJ_MURMUR;
DROP TABLE IF EXISTS MNJ_REL_MURMUR_CTXT;
DROP TABLE IF EXISTS MNJ_USER;




/* Create Tables */

CREATE TABLE MNJ_CTXT
(
	CTXT_ID INT NOT NULL,
	-- true: entry is valid.
	-- false: entry is invalid.
	VALID_FLG BOOLEAN DEFAULT 'true' NOT NULL,
	-- 0: For all locales.
	-- 47: en_US
	-- 97: ja_JP
	LOCALE_ID INT DEFAULT 47 NOT NULL,
	-- 1:target kwd
	-- 0:non keyword
	KWD_ID INT NOT NULL,
	CTXT_ENDPOINT_LEVEL INT NOT NULL,
	-- Small value is high priority.
	SORT_PRIORITY INT DEFAULT 10000 NOT NULL,
	OWNER_USER_ID INT NOT NULL,
	-- last update time (timestamp) of row
	UPD_DT TIMESTAMP NOT NULL,
	-- last update user id of row
	UPD_USER_ID INT NOT NULL,
	PRIMARY KEY (CTXT_ID)
) WITHOUT OIDS;


CREATE TABLE MNJ_CTXT_ITEM
(
	CTXT_ID INT NOT NULL,
	CTXT_LEVEL INT NOT NULL,
	-- 1:target kwd
	-- 0:non keyword
	KWD_ID INT NOT NULL,
	-- last update time (timestamp) of row
	UPD_DT TIMESTAMP NOT NULL,
	-- last update user id of row
	UPD_USER_ID INT NOT NULL,
	PRIMARY KEY (CTXT_ID, CTXT_LEVEL)
) WITHOUT OIDS;


CREATE TABLE MNJ_KWD
(
	-- 1:target kwd
	-- 0:non keyword
	KWD_ID INT NOT NULL UNIQUE,
	-- true: entry is valid.
	-- false: entry is invalid.
	VALID_FLG BOOLEAN DEFAULT 'true' NOT NULL,
	-- 0: For all locales.
	-- 47: en_US
	-- 97: ja_JP
	LOCALE_ID INT DEFAULT 0 NOT NULL,
	KWD_NAME VARCHAR(254) NOT NULL UNIQUE,
	KWD_NAME_NORMAL VARCHAR(254) NOT NULL,
	OWNER_USER_ID INT NOT NULL,
	-- last update time (timestamp) of row
	UPD_DT TIMESTAMP NOT NULL,
	-- last update user id of row
	UPD_USER_ID INT NOT NULL,
	PRIMARY KEY (KWD_ID)
) WITHOUT OIDS;


CREATE TABLE MNJ_MURMUR
(
	MURMUR_ID INT NOT NULL,
	-- true: entry is valid.
	-- false: entry is invalid.
	VALID_FLG BOOLEAN DEFAULT 'true' NOT NULL,
	-- 0: For all locales.
	-- 47: en_US
	-- 97: ja_JP
	LOCALE_ID INT DEFAULT 47 NOT NULL,
	-- 1: Plain text
	-- 2: Localized text of keyword
	-- 11: Plain URL
	-- 12: Wiki URL
	-- 
	MURMUR_TYPE INT DEFAULT 1 NOT NULL,
	MURMUR_DATE TIMESTAMP NOT NULL,
	MURMUR_TITLE VARCHAR(254) NOT NULL,
	MURMUR_VALUE VARCHAR(254) NOT NULL,
	-- 0:none
	-- 
	REFER_MURMUR_ID INT DEFAULT 0 NOT NULL,
	OWNER_USER_ID INT NOT NULL,
	-- last update time (timestamp) of row
	UPD_DT TIMESTAMP NOT NULL,
	-- last update user id of row
	UPD_USER_ID INT NOT NULL,
	PRIMARY KEY (MURMUR_ID)
) WITHOUT OIDS;


CREATE TABLE MNJ_REL_MURMUR_CTXT
(
	MURMUR_ID INT NOT NULL,
	CTXT_ID INT NOT NULL,
	OWNER_USER_ID INT NOT NULL,
	-- Small value is high priority.
	SORT_PRIORITY INT DEFAULT 10000 NOT NULL,
	-- true: entry is valid.
	-- false: entry is invalid.
	VALID_FLG BOOLEAN DEFAULT 'true' NOT NULL,
	-- last update time (timestamp) of row
	UPD_DT TIMESTAMP NOT NULL,
	-- last update user id of row
	UPD_USER_ID INT NOT NULL,
	PRIMARY KEY (MURMUR_ID, CTXT_ID, OWNER_USER_ID)
) WITHOUT OIDS;


-- User entry for Manjyu
CREATE TABLE MNJ_USER
(
	-- 0:Anonymous
	-- 1:admin(Initial user), ToshikiIga
	USER_ID INT NOT NULL,
	-- true: entry is valid.
	-- false: entry is invalid.
	VALID_FLG BOOLEAN DEFAULT 'true' NOT NULL,
	USER_CD VARCHAR(254) NOT NULL UNIQUE,
	DEFAULT_LOCALE_ID INT DEFAULT 47 NOT NULL,
	USER_PASSWD VARCHAR(254) NOT NULL,
	-- true: administrator
	-- false: general user
	USER_FLG_ADMIN BOOLEAN DEFAULT 'false' NOT NULL,
	USER_FLG_EDITOR_KWD BOOLEAN DEFAULT 'false' NOT NULL,
	USER_FLG_EDITOR_MURMUR BOOLEAN DEFAULT 'false' NOT NULL,
	-- last update time (timestamp) of row
	UPD_DT TIMESTAMP NOT NULL,
	-- last update user id of row
	UPD_USER_ID INT NOT NULL,
	PRIMARY KEY (USER_ID)
) WITHOUT OIDS;



/* Comments */

COMMENT ON COLUMN MNJ_CTXT.VALID_FLG IS 'true: entry is valid.
false: entry is invalid.';
COMMENT ON COLUMN MNJ_CTXT.LOCALE_ID IS '0: For all locales.
47: en_US
97: ja_JP';
COMMENT ON COLUMN MNJ_CTXT.KWD_ID IS '1:target kwd
0:non keyword';
COMMENT ON COLUMN MNJ_CTXT.SORT_PRIORITY IS 'Small value is high priority.';
COMMENT ON COLUMN MNJ_CTXT.UPD_DT IS 'last update time (timestamp) of row';
COMMENT ON COLUMN MNJ_CTXT.UPD_USER_ID IS 'last update user id of row';
COMMENT ON COLUMN MNJ_CTXT_ITEM.KWD_ID IS '1:target kwd
0:non keyword';
COMMENT ON COLUMN MNJ_CTXT_ITEM.UPD_DT IS 'last update time (timestamp) of row';
COMMENT ON COLUMN MNJ_CTXT_ITEM.UPD_USER_ID IS 'last update user id of row';
COMMENT ON COLUMN MNJ_KWD.KWD_ID IS '1:target kwd
0:non keyword';
COMMENT ON COLUMN MNJ_KWD.VALID_FLG IS 'true: entry is valid.
false: entry is invalid.';
COMMENT ON COLUMN MNJ_KWD.LOCALE_ID IS '0: For all locales.
47: en_US
97: ja_JP';
COMMENT ON COLUMN MNJ_KWD.UPD_DT IS 'last update time (timestamp) of row';
COMMENT ON COLUMN MNJ_KWD.UPD_USER_ID IS 'last update user id of row';
COMMENT ON COLUMN MNJ_MURMUR.VALID_FLG IS 'true: entry is valid.
false: entry is invalid.';
COMMENT ON COLUMN MNJ_MURMUR.LOCALE_ID IS '0: For all locales.
47: en_US
97: ja_JP';
COMMENT ON COLUMN MNJ_MURMUR.MURMUR_TYPE IS '1: Plain text
2: Localized text of keyword
11: Plain URL
12: Wiki URL
';
COMMENT ON COLUMN MNJ_MURMUR.REFER_MURMUR_ID IS '0:none
';
COMMENT ON COLUMN MNJ_MURMUR.UPD_DT IS 'last update time (timestamp) of row';
COMMENT ON COLUMN MNJ_MURMUR.UPD_USER_ID IS 'last update user id of row';
COMMENT ON COLUMN MNJ_REL_MURMUR_CTXT.SORT_PRIORITY IS 'Small value is high priority.';
COMMENT ON COLUMN MNJ_REL_MURMUR_CTXT.VALID_FLG IS 'true: entry is valid.
false: entry is invalid.';
COMMENT ON COLUMN MNJ_REL_MURMUR_CTXT.UPD_DT IS 'last update time (timestamp) of row';
COMMENT ON COLUMN MNJ_REL_MURMUR_CTXT.UPD_USER_ID IS 'last update user id of row';
COMMENT ON TABLE MNJ_USER IS 'User entry for Manjyu';
COMMENT ON COLUMN MNJ_USER.USER_ID IS '0:Anonymous
1:admin(Initial user), ToshikiIga';
COMMENT ON COLUMN MNJ_USER.VALID_FLG IS 'true: entry is valid.
false: entry is invalid.';
COMMENT ON COLUMN MNJ_USER.USER_FLG_ADMIN IS 'true: administrator
false: general user';
COMMENT ON COLUMN MNJ_USER.UPD_DT IS 'last update time (timestamp) of row';
COMMENT ON COLUMN MNJ_USER.UPD_USER_ID IS 'last update user id of row';



