/*
 * Decompiled with CFR 0.152.
 */
package org.manjyu.rss;

import java.io.IOException;
import java.util.logging.Logger;
import org.manjyu.rss.ManjyuRssParser;
import org.manjyu.rss.util.ManjyuRssDateUtil;
import org.manjyu.rss.vo.ManjyuRssCategory;
import org.manjyu.rss.vo.ManjyuRssChannel;
import org.manjyu.rss.vo.ManjyuRssCloud;
import org.manjyu.rss.vo.ManjyuRssEnclosure;
import org.manjyu.rss.vo.ManjyuRssImage;
import org.manjyu.rss.vo.ManjyuRssItem;
import org.manjyu.rss.vo.ManjyuRssSource;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

class ManjyuRssParserHandler
implements ContentHandler {
    protected ManjyuRssParser parser;
    protected ManjyuRssChannel channel = null;
    protected ManjyuRssItem item = null;
    protected ManjyuRssCategory category = null;
    protected ManjyuRssImage image = null;
    protected String characters = "";

    ManjyuRssParserHandler(ManjyuRssParser targetParser) {
        this.parser = targetParser;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.characters = null;
        if ("channel".equals(localName)) {
            this.channel = new ManjyuRssChannel();
        } else if ("item".equals(localName)) {
            if (this.channel != null) {
                try {
                    this.parser.processChannel(this.channel);
                }
                catch (IOException ex) {
                    throw new SAXException(ex);
                }
                this.channel = null;
            }
            this.item = new ManjyuRssItem();
        } else if ("category".equals(localName)) {
            this.category = new ManjyuRssCategory();
            this.category.setDomain(atts.getValue("domain"));
        } else if ("subject".equals(localName) && "http://purl.org/dc/elements/1.1/".equals(uri)) {
            if (this.category == null) {
                this.category = new ManjyuRssCategory();
            }
        } else if ("cloud".equals(localName)) {
            if (this.channel != null) {
                ManjyuRssCloud cloud = new ManjyuRssCloud();
                this.channel.setCloud(cloud);
                cloud.setDomain(atts.getValue("domain"));
                cloud.setPort(atts.getValue("port"));
                cloud.setPath(atts.getValue("path"));
                cloud.setRegisterProcedure(atts.getValue("registerProcedure"));
                cloud.setRegisterProcedure(atts.getValue("protocol"));
            }
        } else if ("image".equals(localName)) {
            this.image = new ManjyuRssImage();
            if ("http://purl.org/rss/1.0/".equals(uri)) {
                this.image.setUrl(atts.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource"));
                this.image.setLink(this.image.getUrl());
            }
        } else if ("enclosure".equals(localName)) {
            if (this.item != null) {
                if (this.item.getEnclosure() == null) {
                    this.item.setEnclosure(new ManjyuRssEnclosure());
                }
                this.item.getEnclosure().setUrl(atts.getValue("url"));
                this.item.getEnclosure().setLength(atts.getValue("length"));
                this.item.getEnclosure().setType(atts.getValue("type"));
            }
        } else if ("source".equals(localName) && this.item != null) {
            if (this.item.getSource() == null) {
                this.item.setSource(new ManjyuRssSource());
            }
            this.item.getSource().setUrl(atts.getValue("url"));
        }
    }

    /*
     * Unable to fully structure code
     */
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("channel".equals(localName)) {
            if (this.channel != null) {
                try {
                    this.parser.processChannel(this.channel);
                }
                catch (IOException ex) {
                    throw new SAXException(ex);
                }
                this.channel = null;
            }
        } else if ("item".equals(localName)) {
            if (this.item != null) {
                try {
                    this.parser.processItem(this.item);
                }
                catch (IOException ex) {
                    throw new SAXException(ex);
                }
                this.item = null;
            }
        } else if ("title".equals(localName)) {
            if (this.channel != null) {
                this.channel.setTitle(this.characters);
            }
            if (this.item != null) {
                this.item.setTitle(this.characters);
            }
            if (this.image != null) {
                this.image.setTitle(this.characters);
            }
        } else if ("link".equals(localName)) {
            if (this.channel != null && localName.equals(qName)) {
                this.channel.setLink(this.characters);
            }
            if (this.item != null) {
                this.item.setLink(this.characters);
            }
            if (this.image != null) {
                this.image.setLink(this.characters);
            }
        } else if ("description".equals(localName)) {
            if (this.channel != null) {
                this.channel.setDescription(this.characters);
            }
            if (this.item != null) {
                this.item.setDescription(this.characters);
            }
            if (this.image != null) {
                this.image.setDescription(this.characters);
            }
        } else if ("language".equals(localName)) {
            if (this.channel != null) {
                this.channel.setLanguage(this.characters);
            }
        } else if ("copyright".equals(localName)) {
            if (this.channel != null) {
                this.channel.setCopyright(this.characters);
            }
        } else if ("managingEditor".equals(localName)) {
            if (this.channel != null) {
                this.channel.setManagingEditor(this.characters);
            }
        } else if ("webMaster".equals(localName)) {
            if (this.channel != null) {
                this.channel.setWebMaster(this.characters);
            }
        } else if ("pubDate".equals(localName)) {
            try {
                date = ManjyuRssDateUtil.rfc822String2Date(this.characters);
                if (this.channel != null) {
                    this.channel.setPubDate(date);
                }
                if (this.item == null) ** GOTO lbl171
                this.item.setPubDate(date);
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        } else if ("lastBuildDate".equals(localName)) {
            try {
                date = ManjyuRssDateUtil.rfc822String2Date(this.characters);
                if (this.channel == null) ** GOTO lbl171
                this.channel.setLastBuildDate(date);
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        } else if ("category".equals(localName)) {
            this.category.setCharacters(this.characters);
            if (this.channel != null) {
                this.channel.getCategoryList().add(this.category);
            }
            if (this.item != null) {
                this.item.getCategoryList().add(this.category);
            }
            this.category = null;
        } else if ("subject".equals(localName) && "http://purl.org/dc/elements/1.1/".equals(uri)) {
            this.category.setCharacters(this.characters);
            if (this.channel != null) {
                this.channel.getCategoryList().add(this.category);
            }
            if (this.item != null) {
                this.item.getCategoryList().add(this.category);
            }
            this.category = null;
        } else if ("generator".equals(localName)) {
            if (this.channel != null) {
                this.channel.setGenerator(this.characters);
            }
        } else if ("docs".equals(localName)) {
            if (this.channel != null) {
                this.channel.setDocs(this.characters);
            }
        } else if ("ttl".equals(localName)) {
            if (this.channel != null) {
                this.channel.setTtl(this.characters);
            }
        } else if ("image".equals(localName)) {
            if (this.channel != null) {
                this.channel.setImage(this.image);
            }
            this.image = null;
        } else if (!("rating".equals(localName) || "textInput".equals(localName) || "skipHours".equals(localName) || "skipDays".equals(localName))) {
            if ("author".equals(localName)) {
                if (this.item != null) {
                    this.item.setAuthor(this.characters);
                }
            } else if ("comments".equals(localName)) {
                if (this.item != null) {
                    this.item.setComments(this.characters);
                }
            } else if ("guid".equals(localName)) {
                if (this.item != null) {
                    this.item.setGuid(this.characters);
                }
            } else if ("source".equals(localName)) {
                if (this.item != null) {
                    if (this.item.getSource() == null) {
                        this.item.setSource(new ManjyuRssSource());
                    }
                    this.item.getSource().setCharacters(this.characters);
                }
            } else if ("url".equals(localName)) {
                if (this.image != null) {
                    this.image.setUrl(this.characters);
                }
            } else if ("width".equals(localName)) {
                if (this.image != null) {
                    this.image.setWidth(this.characters);
                }
            } else if ("height".equals(localName)) {
                if (this.image != null) {
                    this.image.setHeight(this.characters);
                }
            } else if ("date".equals(localName) && "http://purl.org/dc/elements/1.1/".equals(uri)) {
                try {
                    date = ManjyuRssDateUtil.w3cdtfString2Date(this.characters);
                    if (this.channel != null) {
                        this.channel.setPubDate(date);
                    }
                    if (this.item == null) ** GOTO lbl171
                    this.item.setPubDate(date);
                }
                catch (IOException e) {
                    throw new SAXException(e);
                }
            } else if ("rights".equals(localName) && "http://purl.org/dc/elements/1.1/".equals(uri)) {
                if (this.channel != null) {
                    this.channel.setCopyright(this.characters);
                }
            } else if ("publisher".equals(localName) && "http://purl.org/dc/elements/1.1/".equals(uri)) {
                if (this.channel != null) {
                    this.channel.setCopyright(this.characters);
                }
            } else if ("creator".equals(localName) && "http://purl.org/dc/elements/1.1/".equals(uri)) {
                if (this.item != null) {
                    this.item.setAuthor(this.characters);
                }
            } else if (!("li".equals(localName) || "Seq".equals(localName) || "items".equals(localName) || "RDF".equals(localName))) {
                Logger.getLogger("org.manjyu.rss").fine("Skipped endElement tag: " + localName + " [" + uri + "]: value=" + this.characters);
            }
        }
lbl171:
        // 36 sources

        this.characters = null;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.characters = new String(ch, start, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.characters = new String(ch, start, length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }
}

