/*
 * Decompiled with CFR 0.152.
 */
package org.manjyu.rss;

import java.io.IOException;
import java.io.OutputStream;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.manjyu.rss.ManjyuRssConstants;
import org.manjyu.rss.util.ManjyuRssDateUtil;
import org.manjyu.rss.util.ManjyuRssSerializerUtil;
import org.manjyu.rss.vo.ManjyuRss;
import org.manjyu.rss.vo.ManjyuRssAttribute;
import org.manjyu.rss.vo.ManjyuRssAttributes;
import org.manjyu.rss.vo.ManjyuRssCategory;
import org.manjyu.rss.vo.ManjyuRssChannel;
import org.manjyu.rss.vo.ManjyuRssCloud;
import org.manjyu.rss.vo.ManjyuRssEnclosure;
import org.manjyu.rss.vo.ManjyuRssImage;
import org.manjyu.rss.vo.ManjyuRssItem;
import org.manjyu.rss.vo.ManjyuRssSource;
import org.xml.sax.SAXException;

public abstract class ManjyuRssSerializer {
    protected TransformerHandler saxHandler = null;
    protected int indent = 0;

    protected abstract void processItems() throws IOException;

    public void serialize(ManjyuRss rss, OutputStream outStream) throws IOException {
        TransformerFactory tf = TransformerFactory.newInstance();
        SAXTransformerFactory saxTf = (SAXTransformerFactory)tf;
        try {
            this.saxHandler = saxTf.newTransformerHandler();
            this.saxHandler.getTransformer().setOutputProperty("version", "1.0");
            this.saxHandler.getTransformer().setOutputProperty("encoding", "UTF-8");
        }
        catch (TransformerConfigurationException e) {
            throw new IllegalArgumentException("Fail to generate TransformerHandler: " + e.toString(), e);
        }
        this.saxHandler.setResult(new StreamResult(outStream));
        try {
            ManjyuRssSerializerUtil.newLine(this.saxHandler);
            this.saxHandler.startDocument();
            ManjyuRssAttributes attrs = new ManjyuRssAttributes();
            ManjyuRssAttribute attr = new ManjyuRssAttribute();
            attrs.getAttrList().add(attr);
            attr.setLocalName("version");
            attr.setValue(rss.getVersion());
            this.saxHandler.startElement(null, "rss", "rss", attrs);
            ManjyuRssSerializerUtil.newLine(this.saxHandler);
            this.serializeChannel(rss.getChannel());
            this.saxHandler.endElement(null, "rss", "rss");
            ManjyuRssSerializerUtil.newLine(this.saxHandler);
            this.saxHandler.endDocument();
        }
        catch (SAXException ex) {
            throw new IOException(ex.toString(), ex);
        }
        outStream.flush();
    }

    void serializeChannel(ManjyuRssChannel channel) throws SAXException, IOException {
        ++this.indent;
        ManjyuRssSerializerUtil.indent(this.indent, this.saxHandler);
        char[] commentChars = (" Generated by ManjyuRss (" + ManjyuRssConstants.getVersion() + ") ").toCharArray();
        this.saxHandler.comment(commentChars, 0, commentChars.length);
        ManjyuRssSerializerUtil.newLine(this.saxHandler);
        ManjyuRssSerializerUtil.indent(this.indent, this.saxHandler);
        this.saxHandler.startElement(null, "channel", "channel", null);
        ManjyuRssSerializerUtil.newLine(this.saxHandler);
        ++this.indent;
        if (channel.getTitle() != null) {
            ManjyuRssSerializerUtil.indent(this.indent, this.saxHandler);
            this.saxHandler.startElement(null, "title", "title", null);
            ManjyuRssSerializerUtil.writeCharacters(channel.getTitle(), this.saxHandler);
            this.saxHandler.endElement(null, "title", "title");
            ManjyuRssSerializerUtil.newLine(this.saxHandler);
        }
        if (channel.getLink() != null) {
            ManjyuRssSerializerUtil.indent(this.indent, this.saxHandler);
            this.saxHandler.startElement(null, "link", "link", null);
            ManjyuRssSerializerUtil.writeCharacters(channel.getLink(), this.saxHandler);
            this.saxHandler.endElement(null, "link", "link");
            ManjyuRssSerializerUtil.newLine(this.saxHandler);
        }
        if (channel.getDescription() != null) {
            ManjyuRssSerializerUtil.indent(this.indent, this.saxHandler);
            this.saxHandler.startElement(null, "description", "description", null);
            ManjyuRssSerializerUtil.writeCharacters(channel.getDescription(), this.saxHandler);
            this.saxHandler.endElement(null, "description", "description");
            ManjyuRssSerializerUtil.newLine(this.saxHandler);
        }
        if (channel.getLanguage() != null) {
            ManjyuRssSerializerUtil.indent(this.indent, this.saxHandler);
            this.saxHandler.startElement(null, "language", "language", null);
            ManjyuRssSerializerUtil.writeCharacters(channel.getLanguage(), this.saxHandler);
            this.saxHandler.endElement(null, "language", "language");
            ManjyuRssSerializerUtil.newLine(this.saxHandler);
        }
        if (channel.getCopyright() != null) {
            ManjyuRssSerializerUtil.indent(this.indent, this.saxHandler);
            this.saxHandler.startElement(null, "copyright", "copyright", null);
            ManjyuRssSerializerUtil.writeCharacters(channel.getCopyright(), this.saxHandler);
            this.saxHandler.endElement(null, "copyright", "copyright");
            ManjyuRssSerializerUtil.newLine(this.saxHandler);
        }
        if (channel.getManagingEditor() != null) {
            ManjyuRssSerializerUtil.indent(this.indent, this.saxHandler);
            this.saxHandler.startElement(null, "managingEditor", "managingEditor", null);
            ManjyuRssSerializerUtil.writeCharacters(channel.getManagingEditor(), this.saxHandler);
            this.saxHandler.endElement(null, "managingEditor", "managingEditor");
            ManjyuRssSerializerUtil.newLine(this.saxHandler);
        }
        if (channel.getWebMaster() != null) {
            ManjyuRssSerializerUtil.indent(this.indent, this.saxHandler);
            this.saxHandler.startElement(null, "webMaster", "webMaster", null);
            ManjyuRssSerializerUtil.writeCharacters(channel.getWebMaster(), this.saxHandler);
            this.saxHandler.endElement(null, "webMaster", "webMaster");
            ManjyuRssSerializerUtil.newLine(this.saxHandler);
        }
        if (channel.getPubDate() != null) {
            ManjyuRssSerializerUtil.indent(this.indent, this.saxHandler);
            this.saxHandler.startElement(null, "pubDate", "pubDate", null);
            ManjyuRssSerializerUtil.writeCharacters(ManjyuRssDateUtil.date2Rfc822String(channel.getPubDate()), this.saxHandler);
            this.saxHandler.endElement(null, "pubDate", "pubDate");
            ManjyuRssSerializerUtil.newLine(this.saxHandler);
        }
        if (channel.getLastBuildDate() != null) {
            ManjyuRssSerializerUtil.indent(this.indent, this.saxHandler);
            this.saxHandler.startElement(null, "lastBuildDate", "lastBuildDate", null);
            ManjyuRssSerializerUtil.writeCharacters(ManjyuRssDateUtil.date2Rfc822String(channel.getLastBuildDate()), this.saxHandler);
            this.saxHandler.endElement(null, "lastBuildDate", "lastBuildDate");
            ManjyuRssSerializerUtil.newLine(this.saxHandler);
        }
        for (ManjyuRssCategory category : channel.getCategoryList()) {
            this.serializeCategory(category);
        }
        if (channel.getGenerator() != null) {
            ManjyuRssSerializerUtil.indent(this.indent, this.saxHandler);
            this.saxHandler.startElement(null, "generator", "generator", null);
            ManjyuRssSerializerUtil.writeCharacters(channel.getGenerator(), this.saxHandler);
            this.saxHandler.endElement(null, "generator", "generator");
            ManjyuRssSerializerUtil.newLine(this.saxHandler);
        }
        if (channel.getDocs() != null) {
            ManjyuRssSerializerUtil.indent(this.indent, this.saxHandler);
            this.saxHandler.startElement(null, "docs", "docs", null);
            ManjyuRssSerializerUtil.writeCharacters(channel.getDocs(), this.saxHandler);
            this.saxHandler.endElement(null, "docs", "docs");
            ManjyuRssSerializerUtil.newLine(this.saxHandler);
        }
        if (channel.getCloud() != null) {
            this.serializeCloud(channel.getCloud());
        }
        if (channel.getTtl() != null) {
            ManjyuRssSerializerUtil.indent(this.indent, this.saxHandler);
            this.saxHandler.startElement(null, "ttl", "ttl", null);
            ManjyuRssSerializerUtil.writeCharacters(channel.getTtl(), this.saxHandler);
            this.saxHandler.endElement(null, "ttl", "ttl");
            ManjyuRssSerializerUtil.newLine(this.saxHandler);
        }
        if (channel.getImage() != null) {
            this.serializeImage(channel.getImage());
        }
        this.processItems();
        --this.indent;
        ManjyuRssSerializerUtil.indent(this.indent, this.saxHandler);
        this.saxHandler.endElement(null, "channel", "channel");
        ManjyuRssSerializerUtil.newLine(this.saxHandler);
        --this.indent;
    }

    void serializeCategory(ManjyuRssCategory category) throws SAXException {
        ManjyuRssAttributes attrs = new ManjyuRssAttributes();
        ManjyuRssAttribute attr = new ManjyuRssAttribute();
        attrs.getAttrList().add(attr);
        attr.setLocalName("domain");
        attr.setValue(category.getDomain());
        ManjyuRssSerializerUtil.indent(this.indent, this.saxHandler);
        this.saxHandler.startElement(null, "category", "category", attrs);
        ManjyuRssSerializerUtil.writeCharacters(category.getCharacters(), this.saxHandler);
        this.saxHandler.endElement(null, "category", "category");
        ManjyuRssSerializerUtil.newLine(this.saxHandler);
    }

    void serializeImage(ManjyuRssImage image) throws SAXException {
        ManjyuRssSerializerUtil.indent(this.indent, this.saxHandler);
        this.saxHandler.startElement(null, "image", "image", null);
        ManjyuRssSerializerUtil.newLine(this.saxHandler);
        ++this.indent;
        if (image.getUrl() != null) {
            ManjyuRssSerializerUtil.indent(this.indent, this.saxHandler);
            this.saxHandler.startElement(null, "url", "url", null);
            ManjyuRssSerializerUtil.writeCharacters(image.getUrl(), this.saxHandler);
            this.saxHandler.endElement(null, "url", "url");
            ManjyuRssSerializerUtil.newLine(this.saxHandler);
        }
        if (image.getTitle() != null) {
            ManjyuRssSerializerUtil.indent(this.indent, this.saxHandler);
            this.saxHandler.startElement(null, "title", "title", null);
            ManjyuRssSerializerUtil.writeCharacters(image.getTitle(), this.saxHandler);
            this.saxHandler.endElement(null, "title", "title");
            ManjyuRssSerializerUtil.newLine(this.saxHandler);
        }
        if (image.getLink() != null) {
            ManjyuRssSerializerUtil.indent(this.indent, this.saxHandler);
            this.saxHandler.startElement(null, "link", "link", null);
            ManjyuRssSerializerUtil.writeCharacters(image.getLink(), this.saxHandler);
            this.saxHandler.endElement(null, "link", "link");
            ManjyuRssSerializerUtil.newLine(this.saxHandler);
        }
        if (image.getDescription() != null) {
            ManjyuRssSerializerUtil.indent(this.indent, this.saxHandler);
            this.saxHandler.startElement(null, "description", "description", null);
            ManjyuRssSerializerUtil.writeCharacters(image.getDescription(), this.saxHandler);
            this.saxHandler.endElement(null, "description", "description");
            ManjyuRssSerializerUtil.newLine(this.saxHandler);
        }
        if (image.getWidth() != null) {
            ManjyuRssSerializerUtil.indent(this.indent, this.saxHandler);
            this.saxHandler.startElement(null, "width", "width", null);
            ManjyuRssSerializerUtil.writeCharacters(image.getWidth(), this.saxHandler);
            this.saxHandler.endElement(null, "width", "width");
            ManjyuRssSerializerUtil.newLine(this.saxHandler);
        }
        if (image.getHeight() != null) {
            ManjyuRssSerializerUtil.indent(this.indent, this.saxHandler);
            this.saxHandler.startElement(null, "height", "height", null);
            ManjyuRssSerializerUtil.writeCharacters(image.getHeight(), this.saxHandler);
            this.saxHandler.endElement(null, "height", "height");
            ManjyuRssSerializerUtil.newLine(this.saxHandler);
        }
        --this.indent;
        ManjyuRssSerializerUtil.indent(this.indent, this.saxHandler);
        this.saxHandler.endElement(null, "image", "image");
        ManjyuRssSerializerUtil.newLine(this.saxHandler);
    }

    void serializeCloud(ManjyuRssCloud cloud) throws SAXException {
        ManjyuRssAttribute attr;
        ManjyuRssAttributes attrs = new ManjyuRssAttributes();
        if (cloud.getDomain() != null) {
            attr = new ManjyuRssAttribute();
            attrs.getAttrList().add(attr);
            attr.setLocalName("domain");
            attr.setValue(cloud.getDomain());
        }
        if (cloud.getPort() != null) {
            attr = new ManjyuRssAttribute();
            attrs.getAttrList().add(attr);
            attr.setLocalName("port");
            attr.setValue(cloud.getPort());
        }
        if (cloud.getPath() != null) {
            attr = new ManjyuRssAttribute();
            attrs.getAttrList().add(attr);
            attr.setLocalName("path");
            attr.setValue(cloud.getPath());
        }
        if (cloud.getRegisterProcedure() != null) {
            attr = new ManjyuRssAttribute();
            attrs.getAttrList().add(attr);
            attr.setLocalName("registerProcedure");
            attr.setValue(cloud.getRegisterProcedure());
        }
        if (cloud.getProtocol() != null) {
            attr = new ManjyuRssAttribute();
            attrs.getAttrList().add(attr);
            attr.setLocalName("protocol");
            attr.setValue(cloud.getProtocol());
        }
        ManjyuRssSerializerUtil.indent(this.indent, this.saxHandler);
        this.saxHandler.startElement(null, "cloud", "cloud", attrs);
        this.saxHandler.endElement(null, "cloud", "cloud");
        ManjyuRssSerializerUtil.newLine(this.saxHandler);
    }

    void serializeEnclosure(ManjyuRssEnclosure enclosure) throws SAXException {
        ManjyuRssAttribute attr;
        ManjyuRssAttributes attrs = new ManjyuRssAttributes();
        if (enclosure.getUrl() != null) {
            attr = new ManjyuRssAttribute();
            attrs.getAttrList().add(attr);
            attr.setLocalName("url");
            attr.setValue(enclosure.getUrl());
        }
        if (enclosure.getLength() != null) {
            attr = new ManjyuRssAttribute();
            attrs.getAttrList().add(attr);
            attr.setLocalName("length");
            attr.setValue(enclosure.getLength());
        }
        if (enclosure.getType() != null) {
            attr = new ManjyuRssAttribute();
            attrs.getAttrList().add(attr);
            attr.setLocalName("type");
            attr.setValue(enclosure.getType());
        }
        ManjyuRssSerializerUtil.indent(this.indent, this.saxHandler);
        this.saxHandler.startElement(null, "enclosure", "enclosure", attrs);
        this.saxHandler.endElement(null, "enclosure", "enclosure");
        ManjyuRssSerializerUtil.newLine(this.saxHandler);
    }

    void serializeSource(ManjyuRssSource source) throws SAXException {
        ManjyuRssAttributes attrs = new ManjyuRssAttributes();
        ManjyuRssAttribute attr = new ManjyuRssAttribute();
        attrs.getAttrList().add(attr);
        attr.setLocalName("url");
        attr.setValue(source.getUrl());
        ManjyuRssSerializerUtil.indent(this.indent, this.saxHandler);
        this.saxHandler.startElement(null, "source", "source", attrs);
        ManjyuRssSerializerUtil.writeCharacters(source.getCharacters(), this.saxHandler);
        this.saxHandler.endElement(null, "source", "source");
        ManjyuRssSerializerUtil.newLine(this.saxHandler);
    }

    protected void serializeItem(ManjyuRssItem item) throws IOException {
        try {
            ManjyuRssSerializerUtil.indent(this.indent, this.saxHandler);
            this.saxHandler.startElement(null, "item", "item", null);
            ManjyuRssSerializerUtil.newLine(this.saxHandler);
            ++this.indent;
            if (item.getTitle() != null) {
                ManjyuRssSerializerUtil.indent(this.indent, this.saxHandler);
                this.saxHandler.startElement(null, "title", "title", null);
                ManjyuRssSerializerUtil.writeCharacters(item.getTitle(), this.saxHandler);
                this.saxHandler.endElement(null, "title", "title");
                ManjyuRssSerializerUtil.newLine(this.saxHandler);
            }
            if (item.getLink() != null) {
                ManjyuRssSerializerUtil.indent(this.indent, this.saxHandler);
                this.saxHandler.startElement(null, "link", "link", null);
                ManjyuRssSerializerUtil.writeCharacters(item.getLink(), this.saxHandler);
                this.saxHandler.endElement(null, "link", "link");
                ManjyuRssSerializerUtil.newLine(this.saxHandler);
            }
            if (item.getDescription() != null) {
                ManjyuRssSerializerUtil.indent(this.indent, this.saxHandler);
                this.saxHandler.startElement(null, "description", "description", null);
                ManjyuRssSerializerUtil.writeCharacters(item.getDescription(), this.saxHandler);
                this.saxHandler.endElement(null, "description", "description");
                ManjyuRssSerializerUtil.newLine(this.saxHandler);
            }
            if (item.getAuthor() != null) {
                ManjyuRssSerializerUtil.indent(this.indent, this.saxHandler);
                this.saxHandler.startElement(null, "author", "author", null);
                ManjyuRssSerializerUtil.writeCharacters(item.getAuthor(), this.saxHandler);
                this.saxHandler.endElement(null, "author", "author");
                ManjyuRssSerializerUtil.newLine(this.saxHandler);
            }
            for (ManjyuRssCategory category : item.getCategoryList()) {
                this.serializeCategory(category);
            }
            if (item.getComments() != null) {
                ManjyuRssSerializerUtil.indent(this.indent, this.saxHandler);
                this.saxHandler.startElement(null, "comments", "comments", null);
                ManjyuRssSerializerUtil.writeCharacters(item.getComments(), this.saxHandler);
                this.saxHandler.endElement(null, "comments", "comments");
                ManjyuRssSerializerUtil.newLine(this.saxHandler);
            }
            if (item.getEnclosure() != null) {
                this.serializeEnclosure(item.getEnclosure());
            }
            if (item.getGuid() != null) {
                ManjyuRssSerializerUtil.indent(this.indent, this.saxHandler);
                this.saxHandler.startElement(null, "guid", "guid", null);
                ManjyuRssSerializerUtil.writeCharacters(item.getGuid(), this.saxHandler);
                this.saxHandler.endElement(null, "guid", "guid");
                ManjyuRssSerializerUtil.newLine(this.saxHandler);
            }
            if (item.getPubDate() != null) {
                ManjyuRssSerializerUtil.indent(this.indent, this.saxHandler);
                this.saxHandler.startElement(null, "pubDate", "pubDate", null);
                ManjyuRssSerializerUtil.writeCharacters(ManjyuRssDateUtil.date2Rfc822String(item.getPubDate()), this.saxHandler);
                this.saxHandler.endElement(null, "pubDate", "pubDate");
                ManjyuRssSerializerUtil.newLine(this.saxHandler);
            }
            if (item.getSource() != null) {
                this.serializeSource(item.getSource());
            }
            --this.indent;
            ManjyuRssSerializerUtil.indent(this.indent, this.saxHandler);
            this.saxHandler.endElement(null, "item", "item");
            ManjyuRssSerializerUtil.newLine(this.saxHandler);
        }
        catch (SAXException ex) {
            throw new IOException(ex);
        }
    }
}

