;GIMP Script-Fu Mansiki Libs
;Tiny-fu版に変更
(define ( Mansiki-ini ) 
	(gimp-message  "ini")
	
)

;--------------------------------------------------iniファイル名
(define ( MSK-getINIFileName) 
    "Mansiki.ini"
)
;--------------------------------------------------
(define ( MSK-exceptINIComments input) 
    (MSK-getValueByIndex (MSK-split input ";") 0)
)
;--------------------------------------------------
(define ( MSK-parseBigSect input) 
	(let* (
	        (result "")
	    )
        (if (>= (MSK-index "[" input 0) 0)
            (begin 
                (set! result (MSK-getValueByIndex (MSK-split input "[")1))
                (if (>= (MSK-index "]" result 0) 0)
                    (MSK-getValueByIndex (MSK-split result "]")0)
                    ""
                )
            )
            result
        )
    )
)
;--------------------------------------------------
(define ( MSK-LoadINI) 
	(let* (
			(iniRows (MSK-ReadIn ( MSK-getINIFileName) ))
			(iniRowsCount (MSK-count iniRows))
			(count 0)
			(bigSect "")
			(row "")
			(result (list ""))b
		)
		
		(while (> iniRowsCount count)
		    (set! row (MSK-getValueByIndex iniRows count))
		    (set! row ( MSK-exceptINIComments row))
		    (set! bigSect ( MSK-parseBigSect row) )
		    (set! result (MSK-push result bigSect))
		    (set! count (+ count 1))
		)
		result
    )
)
;--------------------------------------------------文字コード　Scheme　Gimp

(define ( MSK-getBigSectHash bigSect) 
	(let* (
			(fileName ( MSK-getINIFileName) )
		)
		( MSK-getBigSectHashByFile bigSect fileName)
    )
)
;--------------------------------------------------文字コード　Scheme　Gimp

(define ( MSK-getBigSectHashByFile bigSect fileName) 
	(let* (
			(iniRows (MSK-ReadIn fileName ))
			(iniRowsCount (MSK-count iniRows))
			(count 0)
			(tempSect "")
			(nowSect "")
			(row "")
			(result (list ))
			(keyAndValue (list "" ""))
		)
		(while (> iniRowsCount count)
		    (set! row (MSK-getValueByIndex iniRows count))
		    (set! row ( MSK-exceptINIComments row))
		    (set! tempSect ( MSK-parseBigSect row) )
		    (if (and (equal? tempSect bigSect)(not (equal? tempSect nowSect)))
		        (set! nowSect tempSect)
		        (begin
		            (if (and (equal? bigSect nowSect) (not (equal? row "")) (equal? tempSect ""))
		                (begin
	                        (set! keyAndValue (MSK-getKeyAndValue row))
	                        (set! result ( MSK-addElement2Hash result (MSK-getValueByIndex keyAndValue 0) (MSK-getValueByIndex keyAndValue 1)))
		                )
		            )
		        )
		    )
		    (if (and (not (equal? tempSect nowSect))(not (equal? tempSect "")))
                (set! nowSect tempSect)
            )
		    (set! count (+ count 1))
		)
		result
    )
)

;--------------------------------------------------


(define ( MSK-getKeyAndValue row) 
	(let* (
	        (splited (MSK-split row "="))
	        (key "")
	        (value "")
	    )
	    (if (> (MSK-count splited) 1)
	        (begin
	            (set! key (MSK-getValueByIndex splited 0))
	            (set! value (MSK-getValueByIndex splited 1))
	        )
	    )
	    (set! key( MSK-replace key " " ""))
	    (set! key( MSK-replace key "\t" ""))
	    (set! value( MSK-replace value " " ""))
	    (set! value( MSK-replace value "\t" ""))
	    (set! value( MSK-replace value "'" ""))
	    (set! value( MSK-replace value "\"" ""))
	    (list key value)
	)
)

;--------------------------------------------------
(script-fu-register "Mansiki-ini"
		    "Mansiki-ini(Lib)"
		    "Mansiki"
		    "name"
		    "copyright"
		    "2007/05/27"
		    "GPL"
	)

(script-fu-menu-register "Mansiki-ini"
		    "<Toolbox>/Xtns/Script-Fu/Mansiki")
