; GIMP Script-Fu Mansiki Libs

(define ( Mansiki-Image ) 
	(gimp-message  "Image")
	
)
;--------------------------------------------------ハッシュ変数の作成
(define ( MSK-getDrowableInfoList img ) 
    
)
;--------------------------------------------------画像ファイル読み込み
(define ( MSK-loadImage loadFileName ) 

    (car (gimp-file-load RUN-NONINTERACTIVE loadFileName loadFileName))
)
;--------------------------------------------------ハッシュ変数の作成
(define ( MSK-getLayerCount imageID ) 
(print imageID)
    (car (gimp-image-get-layers imageID))
)
;--------------------------------------------------表示レイヤーマージ
(define ( MSK-mergeVisibleLayers imageID) 
     (MSK-getValueByIndex (gimp-image-merge-visible-layers imageID 1) 0)
)
;--------------------------------------------------表示レイヤーマージ
(define ( MSK-saveImageByExt imageID saveFileName) 
     (gimp-file-save RUN-NONINTERACTIVE
					               imageID
                                   ( MSK-mergeVisibleLayers imageID)
					               saveFileName
					               saveFileName)
)
;--------------------------------------------------ハッシュ変数の作成
(define ( MSK-getLayerIDList imageID ) 
    (vector->list(cadr (gimp-image-get-layers imageID)))
)
;--------------------------------------------------現在のLayer取得
(define ( MSK-getCurrentLayerID imageID ) 
    (car (gimp-image-get-active-layer imageID))
)
;--------------------------------------------------横取得
(define ( MSK-getImageWidth imageID ) 
    (car (gimp-image-width imageID))
)
;--------------------------------------------------縦取得
(define ( MSK-getImageHeight imageID ) 
    (car (gimp-image-height imageID))
)
;--------------------------------------------------縦横比取得
(define ( MSK-getImageRatio imageID ) 
    (/ ( MSK-getImageHeight imageID ) ( MSK-getImageWidth imageID ) )
)
;--------------------------------------------------縦横比取得
(define ( MSK-addLayer2Image imageID layerID) 
     ( gimp-image-add-layer imageID layerID -1) 
)
;--------------------------------------------------XCFファイルコピー（なんで普通にできないんだ〜）
(define ( MSK-copyXCFfile loadFileName saveFileName) 			        
    (let*
;--------------------------------------------------新規Image作成＋ID取得(グレイスケール)
(define ( MSK-newGrayImage width height) 
     ( gimp-image-new width height 1) 
)
        (
	        (imageID (MSK-loadImage loadFileName))
        )
        ( MSK-saveXcfImage imageID saveFileName)
        ( MSK-saveXcfThumbnail imageID saveFileName)
        (gimp-image-delete imageID)
    )
)
;--------------------------------------------------新規Image作成＋ID取得
(define ( MSK-newImage width height) 
     ( gimp-image-new width height 0) 
)
;--------------------------------------------------新規Image作成＋ID取得(グレイスケール)
(define ( MSK-newGrayImage width height) 
     ( gimp-image-new width height 1) 
)
;--------------------------------------------------Xcfファイル無条件保存
(define ( MSK-saveXcfImage imageID fileName) 
    (gimp-xcf-save 0 imageID ( MSK-getCurrentLayerID imageID ) fileName fileName) 
)

;--------------------------------------------------Xcfファイルサムネイル無条件保存
(define ( MSK-saveXcfThumbnail imageID fileName)
    (if (>imageID 0) 
        (begin 
            (MSK-saveXcfImage imageID fileName)
            (gimp-file-save-thumbnail imageID  fileName) 
        )
        (begin
            (gimp-file-save-thumbnail ( MSK-loadImage loadFileName )  fileName) 
        )
    )
)
;--------------------------------------------------Xcfイメージ一括拡大縮小
(define ( MSK-scaleXcfImage imageID width height)
     (let* 
        (
             (layerIDList   ( MSK-getLayerIDList imageID ))
             (layerCount    ( MSK-getLayerCount imageID ))
        )
        (while (> layerCount 0)
            (set! layerCount(- layerCount 1))
            (gimp-drawable-transform-scale 
                (MSK-getValueByIndex layerIDList layerCount) 0 0 width height TRANSFORM-FORWARD INTERPOLATION-CUBIC 1 3 0)
        )
        (gimp-image-resize imageID width height 0 0) 
    )
)
;--------------------------------------------------dpi設定
(define ( MSK-setDPI imageID dpi)
    (gimp-image-set-resolution imageID dpi dpi) 
)
;--------------------------------------------------グレイスケール
(define ( MSK-convertGrascale imageID )
    (if (= (MSK-getValueByIndex(gimp-drawable-is-gray( MSK-getCurrentLayerID imageID ))0) 1)
        ()
        (gimp-image-convert-grayscale imageID) 
    )
)
;--------------------------------------------------モノトーン
(define ( MSK-convertMonotone imageID )
    ( MSK-convertGrascale imageID )
    (if (= (MSK-getValueByIndex(gimp-drawable-is-indexed( MSK-getCurrentLayerID imageID ))0) 1)
        ()
        (gimp-image-convert-indexed imageID FS-DITHER MAKE-PALETTE 2 FALSE TRUE "")
    )
)
;--------------------------------------------------インデックス（最適パレット）
(define ( MSK-convertIndexColor imageID )
    (if (= (MSK-getValueByIndex(gimp-drawable-is-indexed( MSK-getCurrentLayerID imageID ))0) 1)
        ()
        (gimp-image-convert-indexed imageID FS-DITHER MAKE-PALETTE 256 FALSE TRUE "")
    )
)
;--------------------------------------------------インデックス Webカラーパレット
(define ( MSK-convertWebColor imageID )
    (if (= (MSK-getValueByIndex(gimp-drawable-is-indexed( MSK-getCurrentLayerID imageID ))0) 1)
        ()
        (gimp-image-convert-indexed image FS-DITHER WEB-PALETTE 250 FALSE TRUE "")
    )
)
;--------------------------------------------------RGBカラー
(define ( MSK-convertRGBColor imageID )
    (if (= (MSK-getValueByIndex(gimp-drawable-is-rgb( MSK-getCurrentLayerID imageID ))0) 1)
        ()
        (gimp-image-convert-rgb image)  
    )
)
;--------------------------------------------------レイヤー名取得
(define ( MSK-getLayerName layerID )
    (gimp-drawable-get-name layerID)
)
;--------------------------------------------------レイヤー名取得
(define ( MSK-setLayerName layerID newName)
    (if (number? newName)
        (set! newName (number->string newName))
    )
    (if (string? newName)
        (gimp-drawable-set-name layerID newName)
    )
)

;--------------------------------------------------レイヤー名取得
(define ( MSK-resizeImage imageID x y offX offY)
    (let* 
        (
             (layerIDList   ( MSK-getLayerIDList imageID ))
             (layerCount    ( MSK-getLayerCount imageID ))
        )
        (gimp-image-resize imageID x y offX offY)
        (while (> layerCount 0)
            (gimp-layer-resize-to-image-size (MSK-getValueByIndex layerCount))
            (set! layerCount (- layerCount 1))
        )
    )
)

;--------------------------------------------------
(script-fu-register "Mansiki-Image"
		    "Mansiki-Image(Lib)"
		    "Mansiki"
		    "name"
		    "copyright"
		    "2008/03/07"
		    "GPL"
	) 

(script-fu-menu-register "Mansiki-Image"
		    "<Toolbox>/Xtns/Script-Fu/Mansiki")
