; GIMP Script-Fu Mansiki Libs

(define ( Mansiki-Parasite ) 
	(gimp-message  "Parasite")
)
;--------------------------------------------------以下Image
(define ( MSK-setParasiteToImage img keyString valueString) 
		(MSK-detachParasite 0 img keyString)
		(MSK-attachParasite 0 img keyString valueString)
)
;--------------------------------------------------
(define ( MSK-addParasiteToImage img keyString valueString) 
	(let* (
            (originalString (MSK-getParasiteString 0 img keyString) )
		)
		(MSK-detachParasite 0 img keyString)
		(MSK-attachParasite 0 img keyString (string-append originalString valueString ))
	)
)
;--------------------------------------------------
(define ( MSK-deleteParasiteOnImage img keyString ) 
		(MSK-detachParasite 0 img keyString)
)
;--------------------------------------------------
(define ( MSK-getParasiteStringFromImage img keyString) 
	( MSK-getParasiteString 0 img keyString) 
)
;--------------------------------------------------
(define ( MSK-existParasiteOnImage img keyString) 
	( MSK-existParasite 0 img keyString) 
)
;--------------------------------------------------
(define ( MSK-getIndexOfParasiteOnImage img keyString) 
	( MSK-getIndexOfParasite 0 img keyString)
)
;--------------------------------------------------
(define ( MSK-getParasiteKeyListOnImage img ) 
	(MSK-getParasiteKeyList 0 img)
)
;--------------------------------------------------以下Drowable
(define ( MSK-setParasiteToDrowable drw keyString valueString) 
		(MSK-detachParasite 1 drw keyString)
		(MSK-attachParasite 1 drw keyString valueString)
)
;--------------------------------------------------
(define ( MSK-addParasiteToDrowable drw keyString valueString) 
	(let* (
            (originalString (MSK-getParasiteString 1 drw keyString) )
		)
		(MSK-detachParasite 1 drw keyString)
		(MSK-attachParasite 1 drw keyString (string-append originalString valueString ))
	)
)
;--------------------------------------------------
(define ( MSK-deleteParasiteOnDrowable drw keyString ) 
		(MSK-detachParasite 1 drwkeyString)
)
;--------------------------------------------------
(define ( MSK-getParasiteStringFromDrowable drw keyString) 
	( MSK-getParasiteString 1 drw keyString) 
)
;--------------------------------------------------
(define ( MSK-existParasiteOnDrowable drw keyString) 
	( MSK-existParasite 1 drw keyString) 
)
;--------------------------------------------------
(define ( MSK-getIndexOfParasiteOnDrowable drw keyString) 
	( MSK-getIndexOfParasite 1 drw keyString)
)
;--------------------------------------------------
(define ( MSK-getParasiteKeyListOnDrowable drw ) 
	(MSK-getParasiteKeyList 1 drw)
)
;--------------------------------------------------
(define ( MSK-getParasiteString level target keyString) 
	(let* (
            (parasiteString (list ""))
            (tempString "")
		)
		;(typeof parasiteString)
		(if (eqv? ( MSK-existParasite level target keyString)  1)
		    (begin 
		        (set! parasiteString  (MSK-getParasiteByteList level target keyString))
		        (set! tempString( MSK-convertParasite2String parasiteString) )
		    )
		    ""
		)
	)
)

;--------------------------------------------------
(define ( MSK-makeParasiteFromString parasiteName parasiteMessageString ) 
    (let* (
        (temp64Message (base64encode parasiteMessageString))
        (parasiteMessage (bytes-append (hexstr->bytes (array->hexstr temp64Message)) "¥0"))
        )
	    (list parasiteName 1 parasiteMessage)
	)
)
;--------------------------------------------------
(define ( MSK-convertParasite2String parasiteString) 
    (let* (
            (resultString "")
            (lengthPS 0)
            (indexOfBytes 0) 
            (tempList (MSK-getValueByIndex (MSK-getValueByIndex parasiteString 0)2))
            (count 0)
            (notEnought 0)
        )
        (if(null?  tempList)
            (set! lengthPS 0)
            (set! lengthPS (length tempList))
        )
        (while (< indexOfBytes lengthPS)
            (set! resultString
                (string-append resultString ;(typeof tempList)
                    (integer->char ;lengthPS
                        (aref tempList indexOfBytes);arefはByteArray専用
                    )
                )
            )
            (set! indexOfBytes (+ indexOfBytes 1))
        )
		(set! resultString (MSK-Left resultString (- (length resultString) 7)));なぜかついてくる後ろ７文字を除去
        (set! notEnought(MSK-mod (string-length resultString) 4 ))
        (while (< count notEnought)
            (set! resultString (string-append resultString "="))
            (set! count (+ count 1))
        )
        (base64decode resultString)
    )
)
;--------------------------------------------------
(define ( MSK-existParasite level target keyString) 
	(if (>( MSK-getIndexOfParasite level target keyString) 0)
	    TRUE
	    FALSE
	)
)
;--------------------------------------------------
(define ( MSK-getIndexOfParasite level target keyString) 
	(let* (
            (parasiteKeyList (MSK-getParasiteKeyList level target))
            (PScount (length parasiteKeyList))
            (count 0)
		)
		(while (and 
    		        (< count PScount) 
    		        (not (equal? (MSK-getValueByIndex parasiteKeyList count) keyString))
		       )
    	    (set! count (+ count 1))
		)
		(if (or (eqv? count PScount) (<= PScount 0))
		    -1
		    count
		)
	)
)
;--------------------------------------------------
 (define (MSK-getParasiteKeyList level target)
	(let* (
            (parasiteList (MSK-getParasiteList level target) )
            (parasiteKeyList (MSK-getValueByIndex parasiteList 1) )
            (PScount (length parasiteKeyList))
            (count 0)
		)
		(if (or (null? parasiteKeyList) (eqv? PScount 0))
		    (list "")
		    parasiteKeyList
		)
	)
 )
;--------------------------------------------------
 (define (MSK-getParasiteList level target)
         (cond 
               ((eqv? level 0) (gimp-image-parasite-list target))
               ((eqv? level 1) (gimp-drawable-parasite-list target))
               ((eqv? level 2) (gimp-parasite-list))
          )
 )
;--------------------------------------------------
 (define (MSK-attachParasite level target keyString valueString)
         (cond 
               ((eqv? level 0) (gimp-image-parasite-attach target (MSK-makeParasiteFromString keyString valueString )))
               ((eqv? level 1) (gimp-drawable-parasite-attach target (MSK-makeParasiteFromString keyString valueString )))
               ((eqv? level 2) (gimp-parasite-attach target (MSK-makeParasiteFromString keyString valueString )))
          )
 )
;--------------------------------------------------
 (define (MSK-detachParasite level target keyString)
         (cond 
               ((eqv? level 0) (gimp-image-parasite-detach target keyString))
               ((eqv? level 1) (gimp-drawable-parasite-detach target keyString))
               ((eqv? level 2) (gimp-parasite-detach target keyString))
          )
 )
;--------------------------------------------------
 (define (MSK-getParasiteByteList level target keyString)
         (cond 
               ((eqv? level 0) (gimp-image-parasite-find target keyString))
               ((eqv? level 1) (gimp-drawable-parasite-find target keyString))
               ((eqv? level 2) (gimp-parasite-find target keyString))
          )
 )
;--------------------------------------------------
(script-fu-register "Mansiki-Parasite"
		    "Mansiki-Parasite(Lib)"
		    "Mansiki"
		    "name"
		    "copyright"
		    "2007/05/27"
		    "GPL"
	) 

(script-fu-menu-register "Mansiki-Parasite"
		    "<Toolbox>/Xtns/Script-Fu/Mansiki")
